/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc.renewal;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SQLConditionDefinePanel
extends Composite {
    private Table conditionTable;
    private Text dataText;
    private Text userConditionText;
    private Text sqlText;
    private Combo operatorSelector;
    private Combo columnSelector;
    private Combo opSelector;
    private Vector conditionItems = new Vector(20);
    private String columnTypeName;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private TableInfo tableInfo;
    private TableInfo[] tableInfos;

    public SQLConditionDefinePanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label_1 = new Label((Composite)this, 0);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 6;
        label_1.setLayoutData((Object)gridData_3);
        label_1.setText(Messages.getString("SQLConditionDefinePanel.Define_the_condition_1"));
        Label label_3 = new Label((Composite)this, 0);
        label_3.setText(Messages.getString("SQLConditionDefinePanel.Condition_Str__2"));
        this.sqlText = new Text((Composite)this, 2048);
        GridData gridData_4 = new GridData(768);
        this.sqlText.setLayoutData((Object)gridData_4);
        this.conditionTable = new Table((Composite)this, 67584);
        GridData gridData_10 = new GridData(1808);
        gridData_10.horizontalSpan = 2;
        this.conditionTable.setLayoutData((Object)gridData_10);
        this.conditionTable.setLinesVisible(true);
        this.conditionTable.setHeaderVisible(true);
        TableColumn tableColumn_2 = new TableColumn(this.conditionTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText("\u5b50\u53e5\u7c7b\u578b");
        TableColumn tableColumn_3 = new TableColumn(this.conditionTable, 0);
        tableColumn_3.setWidth(100);
        tableColumn_3.setText(Messages.getString("SQLConditionDefinePanel.Column_Name_3"));
        TableColumn tableColumn_4 = new TableColumn(this.conditionTable, 0);
        tableColumn_4.setWidth(100);
        tableColumn_4.setText(Messages.getString("SQLConditionDefinePanel.Operation_4"));
        TableColumn tableColumn_5 = new TableColumn(this.conditionTable, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("SQLConditionDefinePanel.Dest_Data_5"));
        Composite composite_1 = new Composite((Composite)this, 0);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData_1);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 5;
        composite_1.setLayout((Layout)gridLayout_2);
        Label label_4 = new Label(composite_1, 0);
        label_4.setLayoutData((Object)new GridData(64));
        label_4.setText("\u5173\u7cfb");
        Label label_5 = new Label(composite_1, 0);
        label_5.setLayoutData((Object)new GridData(64));
        label_5.setText(Messages.getString("SQLConditionDefinePanel.Column_7"));
        Label label_6 = new Label(composite_1, 0);
        label_6.setLayoutData((Object)new GridData(64));
        label_6.setText(Messages.getString("SQLConditionDefinePanel.operator_8"));
        Label label_7 = new Label(composite_1, 0);
        GridData gridData = new GridData(64);
        gridData.horizontalSpan = 2;
        label_7.setLayoutData((Object)gridData);
        label_7.setText(Messages.getString("SQLConditionDefinePanel.Data_Or_fixed_9"));
        this.opSelector = new Combo(composite_1, 0);
        this.opSelector.setItems(new String[]{"WHERE", "AND", "OR"});
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 55;
        this.opSelector.setLayoutData((Object)gridData_2);
        this.opSelector.setText("WHERE");
        this.columnSelector = new Combo(composite_1, 0);
        this.columnSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLConditionDefinePanel.this.setUpDataField();
            }
        });
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 122;
        this.columnSelector.setLayoutData((Object)gridData_5);
        this.operatorSelector = new Combo(composite_1, 0);
        this.operatorSelector.setItems(new String[]{"=", "<>", ">", "<", " LIKE "});
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 47;
        this.operatorSelector.setLayoutData((Object)gridData_6);
        this.dataText = new Text(composite_1, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 102;
        this.dataText.setLayoutData((Object)gridData_7);
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLConditionDefinePanel.this.selectData();
            }
        });
        button_1.setText(Messages.getString("SQLConditionDefinePanel.Select_16"));
        Composite composite = new Composite((Composite)this, 0);
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData_9);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLConditionDefinePanel.this.addConditionItem();
            }
        });
        GridData gridData_12 = new GridData();
        gridData_12.widthHint = 80;
        button_2.setLayoutData((Object)gridData_12);
        button_2.setText(Messages.getString("SQLConditionDefinePanel.Add_17"));
        Button button_3 = new Button(composite, 0);
        button_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLConditionDefinePanel.this.removeSelectedConditionItem();
            }
        });
        GridData gridData_13 = new GridData();
        gridData_13.widthHint = 80;
        button_3.setLayoutData((Object)gridData_13);
        button_3.setText(Messages.getString("SQLConditionDefinePanel.Remove_18"));
        Button button = new Button(composite, 0);
        GridData gridData_15 = new GridData();
        gridData_15.widthHint = 80;
        button.setLayoutData((Object)gridData_15);
        button.setText(Messages.getString("SQLConditionDefinePanel.Generate_it_19"));
        Label label_8 = new Label((Composite)this, 0);
        label_8.setText(Messages.getString("SQLConditionDefinePanel.User_Defined_condition__20"));
        this.userConditionText = new Text((Composite)this, 2048);
        GridData gridData_11 = new GridData(768);
        this.userConditionText.setLayoutData((Object)gridData_11);
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.columnSelector.removeAll();
        if (tableInfo.columns == null) {
            return;
        }
        int i = 0;
        while (i < tableInfo.columns.size()) {
            TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
            this.columnSelector.add(String.valueOf(tableInfo.tableName) + "." + column.columnName);
            ++i;
        }
    }

    public void setTableInfos(TableInfo[] infos) {
        this.tableInfos = infos;
        this.columnSelector.removeAll();
        int k = 0;
        while (k < infos.length) {
            TableInfo tableInfo = infos[k];
            if (tableInfo.columns != null) {
                int i = 0;
                while (i < tableInfo.columns.size()) {
                    TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                    this.columnSelector.add(String.valueOf(tableInfo.tableName) + "." + column.columnName);
                    ++i;
                }
            }
            ++k;
        }
    }

    public void setUpDataField() {
        int idx = this.columnSelector.getSelectionIndex();
        if (idx == -1) {
            return;
        }
        if (this.tableInfo != null) {
            TableColumnInfo column = (TableColumnInfo)this.tableInfo.columns.elementAt(idx);
            if (column.dataName != null) {
                this.dataText.setText("$" + column.dataName + ";");
            }
            this.columnTypeName = column.columnTypeName;
            return;
        }
        int tableIdx = 0;
        int off = 0;
        while (true) {
            int size = this.tableInfos[tableIdx].columns.size();
            if (idx >= off && idx < off + size) break;
            ++tableIdx;
            off += size;
        }
        TableColumnInfo column = (TableColumnInfo)this.tableInfos[tableIdx].columns.elementAt(idx -= off);
        if (column.dataName != null) {
            this.dataText.setText("$" + column.dataName + ";");
        }
        this.columnTypeName = column.columnTypeName;
    }

    private void selectData() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        String dataID = dataNode.getAttrValue("id");
        if (dataID != null) {
            this.dataText.setText("$" + dataID + ";");
        }
    }

    private void removeSelectedConditionItem() {
        TableItem[] items = this.conditionTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ConditionItem cItem = (ConditionItem)items[0].getData();
        this.conditionItems.removeElement(cItem);
        this.conditionTable.remove(this.conditionTable.indexOf(items[0]));
    }

    private void addConditionItem() {
        String op = this.opSelector.getText();
        String columnName = this.columnSelector.getText();
        String operator = this.operatorSelector.getText();
        String data = this.dataText.getText();
        if (op.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("SQLConditionDefinePanel.Warning_27"), (String)"\u5b50\u53e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        if ("WHERE".equalsIgnoreCase(op)) {
            int i = 0;
            while (i < this.conditionItems.size()) {
                String s = ((ConditionItem)this.conditionItems.get((int)i)).OP;
                if ("WHERE".equalsIgnoreCase(s)) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("SQLConditionDefinePanel.Warning_27"), (String)"WHERE\u5b50\u53e5\u4e0d\u53ef\u91cd\u590d\u5b9a\u4e49\uff01");
                    return;
                }
                ++i;
            }
        }
        if (columnName.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("SQLConditionDefinePanel.Warning_27"), (String)Messages.getString("SQLConditionDefinePanel.Please_select_a_column._28"));
            return;
        }
        if (operator.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("SQLConditionDefinePanel.Warning_29"), (String)Messages.getString("SQLConditionDefinePanel.Please_select_an_operator._30"));
            return;
        }
        if (data.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("SQLConditionDefinePanel.Warning_31"), (String)Messages.getString("SQLConditionDefinePanel.Please_select_a_data_or_input_the_dataValue._32"));
            return;
        }
        ConditionItem cItem = new ConditionItem();
        cItem.columnName = columnName;
        cItem.OP = op;
        cItem.operator = operator;
        cItem.columnTypeName = this.columnTypeName;
        if (data.indexOf(36) != -1) {
            cItem.dataName = data;
        } else {
            cItem.value = data;
        }
        TableItem item = new TableItem(this.conditionTable, 0);
        item.setText(op);
        item.setText(1, columnName);
        item.setText(2, operator);
        item.setText(3, data);
        item.setData((Object)cItem);
        if ("WHERE".equalsIgnoreCase(op)) {
            this.conditionItems.add(0, cItem);
        } else {
            this.conditionItems.addElement(cItem);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Vector getConditions() {
        return this.conditionItems;
    }

    public String getUserCondition() {
        return this.userConditionText.getText();
    }
}

