/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc.renewal;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataDictionarySelectDialog;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.SQLDefineDialog;
import com.ecc.ide.editor.wizard.jdbc.SQLDefineInfo;
import com.ecc.ide.editor.wizard.jdbc.SelectedColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editorprofile.EditorProfile;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SQLDefinePage
extends WizardPage {
    private Text errorMessageText;
    private Text errorCodeText;
    private Text sqlIDText;
    private Combo sqlTypeSelector;
    private Text iCollNameText;
    private Text maxRecordsText;
    private Text sqlStrText;
    private TableInfo[] tableInfos;
    private XMLNode dataDictionary;
    private EditorProfile dataEditorProfile;
    private Vector sqlDefines = new Vector(10);

    public SQLDefinePage(String pageName) {
        super(pageName);
    }

    public SQLDefinePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 10;
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("JDBCSQLDefinePage.SQL_Type__6"));
        this.sqlTypeSelector = new Combo(container, 0);
        this.sqlTypeSelector.setItems(new String[]{Messages.getString("JDBCSQLDefinePage.Insert_7"), Messages.getString("JDBCSQLDefinePage.Delete_8"), Messages.getString("JDBCSQLDefinePage.Update_9"), Messages.getString("JDBCSQLDefinePage.Select_10")});
        this.sqlTypeSelector.setText(Messages.getString("JDBCSQLDefinePage.Insert_7"));
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 94;
        this.sqlTypeSelector.setLayoutData((Object)gridData_1);
        Label label_1 = new Label(container, 0);
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 122;
        gridData_4.horizontalSpan = 3;
        label_1.setLayoutData((Object)gridData_4);
        Label label_4 = new Label(container, 0);
        label_4.setText(Messages.getString("JDBCSQLDefinePage.maxRecords__15"));
        this.maxRecordsText = new Text(container, 2048);
        this.maxRecordsText.setLayoutData((Object)gridData_1);
        Label label_5 = new Label(container, 0);
        label_5.setText(Messages.getString("JDBCSQLDefinePage.ICollName__14"));
        this.iCollNameText = new Text(container, 2048);
        this.iCollNameText.setEditable(false);
        this.iCollNameText.setLayoutData((Object)new GridData(768));
        Button iCollButton = new Button(container, 0);
        iCollButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDefinePage.this.selectICollName();
            }
        });
        iCollButton.setText(Messages.getString("DataMapPage.>>_10"));
        Label label_2 = new Label(container, 0);
        label_2.setText(Messages.getString("JDBCSQLDefinePage.ErrorCode__12"));
        this.errorCodeText = new Text(container, 2048);
        this.errorCodeText.setLayoutData((Object)gridData_1);
        Label label_3 = new Label(container, 0);
        label_3.setText(Messages.getString("JDBCSQLDefinePage.ErrorMessage__13"));
        this.errorMessageText = new Text(container, 2048);
        GridData gridData_5 = new GridData(768);
        gridData_5.horizontalSpan = 2;
        this.errorMessageText.setLayoutData((Object)gridData_5);
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 5;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        Label label_6 = new Label(composite, 16384);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 4;
        label_6.setLayoutData((Object)gridData_3);
        label_6.setText("SQL\u8bed\u53e5\u5b9a\u4e49");
        this.sqlStrText = new Text(composite, 2626);
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 3;
        gridData_6.heightHint = 50;
        this.sqlStrText.setLayoutData((Object)gridData_6);
        Button button_2 = new Button(composite, 0);
        GridData gridData_2 = new GridData(1040);
        gridData_2.widthHint = 80;
        button_2.setLayoutData((Object)gridData_2);
        button_2.setText("\u8f85\u52a9\u751f\u6210SQL");
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDefineInfo info = SQLDefinePage.this.createSQL();
                if (info == null) {
                    return;
                }
                SQLDefinePage.this.sqlStrText.setText(String.valueOf(SQLDefinePage.this.getSQLStr(info)));
                SQLDefinePage.this.sqlStrText.setData((Object)info);
            }
        });
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
    }

    public void setDataEditorProfile(EditorProfile profile) {
        this.dataEditorProfile = profile;
    }

    public void setTableInfos(TableInfo[] infos) {
        this.tableInfos = infos;
    }

    private SQLDefineInfo createSQL() {
        String sqlType = this.sqlTypeSelector.getText();
        SQLDefineDialog dialog = new SQLDefineDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setTableInfos(this.tableInfos);
        dialog.setSQLType(sqlType);
        SQLDefineInfo info = (SQLDefineInfo)dialog.open();
        if (info == null) {
            return null;
        }
        info.sqlType = sqlType;
        return info;
    }

    public boolean CreateNewSQL() {
        String sqlType = this.sqlTypeSelector.getText();
        String iCollName = this.iCollNameText.getText();
        String maxRecords = this.maxRecordsText.getText();
        String sqlStr = this.sqlStrText.getText();
        String errorCode = this.errorCodeText.getText();
        String errorMsg = this.errorMessageText.getText();
        try {
            if (maxRecords != null && maxRecords.trim().length() != 0) {
                Integer.parseInt(maxRecords);
            }
        }
        catch (NumberFormatException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JDBCSQLDefinePage.Warning_20"), (String)Messages.getString("JDBCSQLDefinePage.Please_input_a_Integer_21"));
            return false;
        }
        if (sqlStr.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("JDBCSQLDefinePage.Warning_16"), (String)"Please input a SQL String!");
            return false;
        }
        SQLDefineInfo info = (SQLDefineInfo)this.sqlStrText.getData();
        if (info == null) {
            info = new SQLDefineInfo();
        }
        info.sqlType = sqlType;
        info.iCollName = iCollName;
        info.maxRecords = maxRecords;
        info.sqlStr = sqlStr;
        info.errorCode = errorCode;
        info.errorMessage = errorMsg;
        this.sqlDefines.addElement(info);
        return true;
    }

    public void RemoveSQL() {
    }

    public Vector getSQLDefines() {
        return this.sqlDefines;
    }

    private String getSQLStr(SQLDefineInfo sqlInfo) {
        String sqlType = sqlInfo.sqlType;
        if ("Select".equals(sqlType)) {
            String tables = "";
            String sqlStr = "Select ";
            boolean oIdx = true;
            int iIdx = 1;
            int k = 0;
            while (k < sqlInfo.selectedColumns.size()) {
                TableColumnInfo column = (TableColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                sqlStr = k != 0 ? String.valueOf(sqlStr) + "," + column.tableName + "." + column.columnName + " " : String.valueOf(sqlStr) + column.tableName + "." + column.columnName + " ";
                if (tables.indexOf(column.tableName) == -1) {
                    tables = tables.length() != 0 ? String.valueOf(tables) + " , " + column.tableName + " " : String.valueOf(tables) + column.tableName + " ";
                }
                ++k;
            }
            sqlStr = String.valueOf(sqlStr) + "From " + tables;
            String conditionStr = "";
            conditionStr = this.getConditionStr(sqlInfo.conditions, iIdx);
            if (conditionStr.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + conditionStr + sqlInfo.userCondition;
            } else if (sqlInfo.userCondition.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + sqlInfo.userCondition;
            }
            return sqlStr;
        }
        if ("Update".equals(sqlType)) {
            String tables = "";
            String sqlStr = " set ";
            int iIdx = 1;
            int k = 0;
            while (k < sqlInfo.selectedColumns.size()) {
                SelectedColumnInfo column = (SelectedColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                int idx = column.columnName.lastIndexOf(".");
                String tableName = column.columnName.substring(0, idx);
                if (tables.indexOf(tableName) == -1) {
                    tables = tables.length() > 0 ? String.valueOf(tables) + "," + tableName : tableName;
                }
                if (k != 0) {
                    sqlStr = String.valueOf(sqlStr) + ",";
                }
                if (column.dataName != null) {
                    sqlStr = String.valueOf(sqlStr) + column.columnName + "=? ";
                } else {
                    String aValueStr = this.getValueStr(column.value, column.columnTypeName);
                    sqlStr = String.valueOf(sqlStr) + column.columnName + "=" + aValueStr + " ";
                }
                ++k;
            }
            sqlStr = "Update " + tables + sqlStr;
            String conditionStr = "";
            conditionStr = this.getConditionStr(sqlInfo.conditions, iIdx);
            if (conditionStr.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + conditionStr + sqlInfo.userCondition;
            } else if (sqlInfo.userCondition.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + sqlInfo.userCondition;
            }
            return sqlStr;
        }
        if ("Insert".equals(sqlType)) {
            String tables = "";
            String sqlStr = "Insert Into ";
            String columnsStr = " (";
            String valuesStr = " Values (";
            boolean iIdx = true;
            int k = 0;
            while (k < sqlInfo.selectedColumns.size()) {
                SelectedColumnInfo column = (SelectedColumnInfo)sqlInfo.selectedColumns.elementAt(k);
                int idx = column.columnName.lastIndexOf(".");
                String tableName = column.columnName.substring(0, idx);
                if (tables.indexOf(tableName) == -1) {
                    tables = tables.length() > 0 ? String.valueOf(tables) + "," + tableName : tableName;
                }
                if (k != 0) {
                    columnsStr = String.valueOf(columnsStr) + ",";
                    valuesStr = String.valueOf(valuesStr) + ",";
                }
                if (column.dataName != null) {
                    columnsStr = String.valueOf(columnsStr) + column.columnName;
                    valuesStr = String.valueOf(valuesStr) + "?";
                } else {
                    columnsStr = String.valueOf(columnsStr) + column.columnName;
                    String aValueStr = this.getValueStr(column.value, column.columnTypeName);
                    valuesStr = String.valueOf(valuesStr) + aValueStr + " ";
                }
                ++k;
            }
            sqlStr = String.valueOf(sqlStr) + tables + columnsStr + ")" + valuesStr + ")";
            return sqlStr;
        }
        if ("Delete".equals(sqlType)) {
            String tables = "";
            String sqlStr = "delete From ";
            if (sqlInfo.tableInfo.schemaName != null && sqlInfo.tableInfo.schemaName.trim().length() != 0) {
                sqlStr = String.valueOf(sqlStr) + sqlInfo.tableInfo.schemaName + ".";
            }
            sqlStr = String.valueOf(sqlStr) + sqlInfo.tableInfo.tableName;
            int iIdx = 1;
            String conditionStr = "";
            conditionStr = this.getConditionStr(sqlInfo.conditions, iIdx);
            if (conditionStr.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + conditionStr + sqlInfo.userCondition;
            } else if (sqlInfo.userCondition.length() > 0) {
                sqlStr = String.valueOf(sqlStr) + " Where " + sqlInfo.userCondition;
            }
            return sqlStr;
        }
        return "";
    }

    private String getConditionStr(Vector conditions, int iIdx) {
        if (conditions == null) {
            return "";
        }
        String conditionStr = "";
        int k = 0;
        while (k < conditions.size()) {
            ConditionItem item = (ConditionItem)conditions.elementAt(k);
            conditionStr = String.valueOf(conditionStr) + item.OP + " " + item.columnName + item.operator;
            if (item.dataName != null) {
                conditionStr = String.valueOf(conditionStr) + "? ";
            } else {
                String valueStr = this.getValueStr(item.value, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + valueStr + " ";
            }
            ++k;
        }
        return conditionStr;
    }

    private String getValueStr(String value, String columnType) {
        if (columnType == null) {
            return value;
        }
        if ((columnType = columnType.toUpperCase()).indexOf("INT") != -1) {
            return value;
        }
        if (columnType.equals("DOUBLE")) {
            return value;
        }
        if (columnType.equals("REAL")) {
            return value;
        }
        if (columnType.equals("DECIMAL")) {
            return value;
        }
        return "'" + value + "'";
    }

    private void selectICollName() {
        DataDictionarySelectDialog dialog = new DataDictionarySelectDialog(this.getShell(), 0);
        dialog.setProfile(this.dataEditorProfile);
        dialog.setDataDictionary(this.dataDictionary);
        dialog.setFilterStr("dataCollection");
        Vector datas = (Vector)dialog.open();
        if (datas == null || datas.size() == 0) {
            return;
        }
        XMLNode dataNode = (XMLNode)datas.elementAt(0);
        if (!dataNode.getNodeName().equals("dataCollection")) {
            return;
        }
        String dataID = dataNode.getAttrValue("id");
        this.iCollNameText.setText(dataID);
        this.getContainer().updateButtons();
    }
}

