/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.jdbc.renewal;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.ECCIDEWizard;
import com.ecc.ide.editor.wizard.jdbc.ConditionItem;
import com.ecc.ide.editor.wizard.jdbc.DataMapPage;
import com.ecc.ide.editor.wizard.jdbc.JDBCTableAccessModeSelectPage;
import com.ecc.ide.editor.wizard.jdbc.Messages;
import com.ecc.ide.editor.wizard.jdbc.ServiceSelectPage;
import com.ecc.ide.editor.wizard.jdbc.TableColumnInfo;
import com.ecc.ide.editor.wizard.jdbc.TableInfo;
import com.ecc.ide.editor.wizard.jdbc.renewal.SQLConditionDefinePage;
import com.ecc.ide.editor.wizard.jdbc.renewal.TableSequenceColumnPage;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.wizard.IWizardPage;

public class TableActionWizard
extends ECCIDEWizard {
    private ServiceSelectPage serviceSelectPage;
    private ServiceSelectPage defineSelectPage;
    private ServiceSelectPage dataSourceSelectPage;
    private JDBCTableAccessModeSelectPage accessModeSelectPage;
    private DataMapPage dataMapPage;
    private SQLConditionDefinePage conditionPage;
    private TableSequenceColumnPage sequenceColumnPage;
    private int accessMode;
    private TableInfo[] tableInfos;
    private Vector conditions;
    private String userCondition;
    private String tableServiceName;
    private String tableDefineName;
    private String dataSourceName;
    private String iCollName;
    private String sequenceColumnName;
    private String maxLines;

    public void addPages() {
        this.serviceSelectPage = new ServiceSelectPage(Messages.getString("JDBCTableOpStepWizard.Service_Select_Page_1"), Messages.getString("JDBCTableOpStepWizard.Please_select_the_service_this_step_will_operate_!_2"), null);
        this.serviceSelectPage.setCommonServiceNode(this.commonServiceNode);
        this.serviceSelectPage.setSelfDefineNode(this.selfDefineNode);
        this.serviceSelectPage.setFilter("TableService");
        this.addPage((IWizardPage)this.serviceSelectPage);
        this.defineSelectPage = new ServiceSelectPage(Messages.getString("JDBCTableOpStepWizard.Service_Select_Page_1"), "\u8bf7\u9009\u62e9\u6570\u636e\u5e93\u8868\u5b9a\u4e49\u670d\u52a1", null);
        this.defineSelectPage.setCommonServiceNode(this.commonServiceNode);
        this.defineSelectPage.setSelfDefineNode(this.selfDefineNode);
        this.defineSelectPage.setFilter("TableDefine");
        this.defineSelectPage.setIsMulti(true);
        this.addPage((IWizardPage)this.defineSelectPage);
        this.dataSourceSelectPage = new ServiceSelectPage(Messages.getString("JDBCTableOpStepWizard.DataSource_Select_Page_1"), "\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u670d\u52a1", null);
        this.dataSourceSelectPage.setCommonServiceNode(this.commonServiceNode);
        this.dataSourceSelectPage.setSelfDefineNode(this.selfDefineNode);
        this.dataSourceSelectPage.setFilter("JDBCDriverDataSource;JNDIDataSource");
        this.addPage((IWizardPage)this.dataSourceSelectPage);
        this.accessModeSelectPage = new JDBCTableAccessModeSelectPage(Messages.getString("JDBCTableOpStepWizard.Access_Mode_Select_Page_4"), Messages.getString("JDBCTableOpStepWizard.Please_select_the_Access_mode_!_5"), null);
        this.addPage((IWizardPage)this.accessModeSelectPage);
        this.dataMapPage = new DataMapPage(Messages.getString("JDBCTableOpStepWizard.Column_select_and_dataMap_Page_6"), Messages.getString("JDBCTableOpStepWizard.Please_select_the_Column_you_want_to_operate_and_map_the_data_if_your_wanted_!_7"), null);
        this.dataMapPage.setDataEditorProfile(this.dataEditorProfile);
        this.dataMapPage.setDataDictionary(this.dataDictionary);
        this.addPage((IWizardPage)this.dataMapPage);
        this.conditionPage = new SQLConditionDefinePage(Messages.getString("JDBCTableOpStepWizard.Condition_define_page_8"), Messages.getString("JDBCTableOpStepWizard.please_define_the_SQL_condition._9"), null);
        this.conditionPage.setDataEditorProfile(this.dataEditorProfile);
        this.conditionPage.setDataDictionary(this.dataDictionary);
        this.addPage((IWizardPage)this.conditionPage);
        this.sequenceColumnPage = new TableSequenceColumnPage(Messages.getString("JDBCTableServiceWizard.Table_Service_Final_Page_7"), Messages.getString("JDBCTableServiceWizard.Please_confirm_the_table_service_selection_!_8"), null);
        this.addPage((IWizardPage)this.sequenceColumnPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.serviceSelectPage) {
            this.tableServiceName = this.serviceSelectPage.getServiceID();
            return this.defineSelectPage;
        }
        if (page == this.defineSelectPage) {
            this.tableInfos = this.loadTableInfo(this.defineSelectPage.getServiceNodes());
            this.dataMapPage.setTableInfos(this.tableInfos);
            this.conditionPage.setTableInfos(this.tableInfos);
            return this.dataSourceSelectPage;
        }
        if (page == this.dataSourceSelectPage) {
            this.dataSourceName = this.dataSourceSelectPage.getServiceID();
            return this.accessModeSelectPage;
        }
        if (page == this.accessModeSelectPage) {
            this.accessMode = this.accessModeSelectPage.getAccessMode();
            if (this.accessMode == 2) {
                this.conditionPage.setTableInfos(this.tableInfos);
                return this.conditionPage;
            }
            this.dataMapPage.setAccessMode(this.accessMode);
            return this.dataMapPage;
        }
        if (page == this.dataMapPage) {
            if (this.accessMode != 0) {
                this.conditionPage.setTableInfos(this.tableInfos);
                return this.conditionPage;
            }
        } else if (page == this.conditionPage && this.accessMode == 5) {
            this.sequenceColumnPage.setTableInfos(this.tableInfos);
            return this.sequenceColumnPage;
        }
        return null;
    }

    public XMLNode getXMLNode() {
        String[] opModes = new String[]{"insert", "update", "delete", "retrieve", "enquiry", "pageEnquiry"};
        XMLNode node = this.xmlContentNode;
        if (node == null) {
            node = new XMLNode();
            node.setNodeName("TableAction");
        }
        node.setAttrValue("tableService", this.tableServiceName);
        node.setAttrValue("tableDefine", this.tableDefineName);
        node.setAttrValue("dataSource", this.dataSourceName);
        node.setAttrValue("op", opModes[this.accessMode]);
        node.setAttrValue("tableSequenceColumn", this.sequenceColumnName);
        node.setAttrValue("maxLine", this.maxLines);
        String conditionStr = "";
        int k = 0;
        while (k < this.conditions.size()) {
            String aStr;
            ConditionItem item = (ConditionItem)this.conditions.elementAt(k);
            conditionStr = String.valueOf(conditionStr) + item.OP + " " + item.columnName + item.operator;
            if (item.dataName != null) {
                aStr = this.getValueStr(item.dataName, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + aStr + " ";
            } else {
                aStr = this.getValueStr(item.value, item.columnTypeName);
                conditionStr = String.valueOf(conditionStr) + aStr + " ";
            }
            ++k;
        }
        if (this.userCondition != null) {
            conditionStr = String.valueOf(conditionStr) + this.userCondition;
        }
        if (conditionStr.length() > 0) {
            node.setAttrValue("condition", conditionStr);
        }
        String columns = "";
        String dataMap = "";
        int j = 0;
        while (j < this.tableInfos.length) {
            TableInfo tableInfo = this.tableInfos[j];
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                if (column.isSelected) {
                    columns = String.valueOf(columns) + tableInfo.tableName + "." + column.columnName + ";";
                }
                if (column.mapedDataName != null) {
                    dataMap = String.valueOf(dataMap) + tableInfo.tableName + "." + column.columnName + ":" + column.mapedDataName + ";";
                }
                ++i;
            }
            ++j;
        }
        if (columns.length() != 0) {
            node.setAttrValue("columns", columns);
        }
        if (dataMap.length() != 0) {
            node.setAttrValue("dataMapping", dataMap);
        }
        node.setAttrValue("iCollName", this.iCollName);
        return node;
    }

    public boolean performFinish() {
        this.conditions = this.conditionPage.getConditions();
        this.userCondition = this.conditionPage.getUserDefinedCondition();
        this.iCollName = this.dataMapPage.getICollName();
        this.sequenceColumnName = this.sequenceColumnPage.getSequenceColumnName();
        this.maxLines = this.sequenceColumnPage.getMaxLines();
        return true;
    }

    private TableInfo[] loadTableInfo(XMLNode[] serviceNodes) {
        this.tableDefineName = "";
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        int i = 0;
        while (i < serviceNodes.length) {
            XMLNode serviceNode = serviceNodes[i];
            this.tableDefineName = serviceNodes.length == 1 ? serviceNode.getAttrValue("id") : String.valueOf(this.tableDefineName) + serviceNode.getAttrValue("id") + ";";
            TableInfo tableInfo = new TableInfo();
            tableInfoList.add(tableInfo);
            tableInfo.tableName = serviceNode.getAttrValue("tableName");
            tableInfo.schemaName = serviceNode.getAttrValue("schema");
            Vector childs = serviceNode.getChilds();
            if (childs != null) {
                int j = 0;
                while (j < childs.size()) {
                    XMLNode columnNode = (XMLNode)childs.elementAt(j);
                    if (columnNode.getNodeName().equals("column")) {
                        TableColumnInfo column = new TableColumnInfo();
                        column.columnName = columnNode.getAttrValue("columnName");
                        column.columnTypeName = columnNode.getAttrValue("columnType");
                        column.dataName = columnNode.getAttrValue("dataName");
                        column.isSelected = true;
                        tableInfo.addColumn(column);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tableInfoList.toArray(new TableInfo[0]);
    }

    private String getValueStr(String value, String columnType) {
        if (columnType == null) {
            return value;
        }
        if ((columnType = columnType.toUpperCase()).indexOf("INT") != -1) {
            return value;
        }
        if (columnType.equals("DOUBLE")) {
            return value;
        }
        if (columnType.equals("REAL")) {
            return value;
        }
        if (columnType.equals("DECIMAL")) {
            return value;
        }
        return "'" + value + "'";
    }
}

