/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.wizard.teller;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.teller.Messages;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LinkBeanModeSelectPage
extends WizardPage {
    private Text trxCodeText;
    private Combo linkEventSelector;
    private Combo linkComponentSelector;
    private Button trxSelectButton;
    private Button inViewButton;
    private Button outViewButton;
    private String linkOutComponent;
    private String linkOutEvent;
    private String trxCode;
    boolean linkToTrx = true;
    private XMLNode refDataNode;
    private String rootPath;
    private XMLNode viewNode;

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public LinkBeanModeSelectPage(String pageName) {
        super(pageName);
    }

    public LinkBeanModeSelectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        layout.verticalSpacing = 9;
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("LinkBeanModeSelectPage.Link_Out_Point__1"));
        this.linkComponentSelector = new Combo(container, 0);
        this.linkComponentSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LinkBeanModeSelectPage.this.getContainer().updateButtons();
            }
        });
        if (this.viewNode != null) {
            this.linkComponentSelector.add("View [Current View]");
            this.loadXMLContent(this.viewNode);
        }
        GridData gridData = new GridData();
        gridData.widthHint = 193;
        gridData.horizontalSpan = 2;
        this.linkComponentSelector.setLayoutData((Object)gridData);
        Label label_1 = new Label(container, 0);
        label_1.setText(Messages.getString("LinkBeanModeSelectPage.Link_out_Event__3"));
        this.linkEventSelector = new Combo(container, 0);
        this.linkEventSelector.setItems(new String[]{"VALUECHANGED", "SELECTED", "OUT", "SELECT", "OPENED", "ALLFIELDOUT", "KEYPRESSED", "BEFORESUBMIT", "AFTERSUBMIT", "BEFORECLOSE"});
        this.linkEventSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LinkBeanModeSelectPage.this.getContainer().updateButtons();
            }
        });
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 186;
        gridData_1.horizontalSpan = 2;
        this.linkEventSelector.setLayoutData((Object)gridData_1);
        final Button linkToTaskButton = new Button(container, 16);
        linkToTaskButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (linkToTaskButton.getSelection()) {
                    LinkBeanModeSelectPage.this.trxCodeText.setEnabled(true);
                    LinkBeanModeSelectPage.this.trxSelectButton.setEnabled(true);
                    LinkBeanModeSelectPage.this.inViewButton.setEnabled(true);
                    LinkBeanModeSelectPage.this.outViewButton.setEnabled(true);
                    LinkBeanModeSelectPage.this.linkToTrx = true;
                }
            }
        });
        linkToTaskButton.setSelection(true);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 3;
        linkToTaskButton.setLayoutData((Object)gridData_2);
        linkToTaskButton.setText(Messages.getString("LinkBeanModeSelectPage.Link_to_Task_14"));
        Label label_2 = new Label(container, 0);
        label_2.setText(Messages.getString("LinkBeanModeSelectPage.Transaction_Code__15"));
        this.trxCodeText = new Text(container, 2048);
        this.trxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LinkBeanModeSelectPage.this.getContainer().updateButtons();
            }
        });
        this.trxCodeText.setLayoutData((Object)new GridData(768));
        this.trxSelectButton = new Button(container, 0);
        this.trxSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkBeanModeSelectPage.this.selectLinkTaskCode();
            }
        });
        this.trxSelectButton.setText(">>");
        Label label_3 = new Label(container, 0);
        GridData gridData_4 = new GridData();
        gridData_4.horizontalSpan = 3;
        label_3.setLayoutData((Object)gridData_4);
        label_3.setText(Messages.getString("LinkBeanModeSelectPage.Link_To_Transaction_Mode__17"));
        this.inViewButton = new Button(container, 32);
        this.inViewButton.setText(Messages.getString("LinkBeanModeSelectPage.Include_Input_View_18"));
        this.outViewButton = new Button(container, 32);
        this.outViewButton.setText(Messages.getString("LinkBeanModeSelectPage.Include_Output_View_19"));
        final Button linkToFormulaButton = new Button(container, 16);
        linkToFormulaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (linkToFormulaButton.getSelection()) {
                    LinkBeanModeSelectPage.this.trxCodeText.setEnabled(false);
                    LinkBeanModeSelectPage.this.trxSelectButton.setEnabled(false);
                    LinkBeanModeSelectPage.this.inViewButton.setEnabled(false);
                    LinkBeanModeSelectPage.this.outViewButton.setEnabled(false);
                    LinkBeanModeSelectPage.this.linkToTrx = false;
                }
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 3;
        linkToFormulaButton.setLayoutData((Object)gridData_3);
        linkToFormulaButton.setText(Messages.getString("LinkBeanModeSelectPage.Link_To_Formula_20"));
    }

    public void dispose() {
        super.dispose();
        this.trxCodeText.dispose();
        this.linkEventSelector.dispose();
        this.linkComponentSelector.dispose();
        this.trxSelectButton.dispose();
        this.inViewButton.dispose();
        this.outViewButton.dispose();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = true;
        this.linkOutComponent = this.linkComponentSelector.getText();
        if (this.linkOutComponent.length() == 0) {
            canFlip = false;
        } else {
            int idx = this.linkOutComponent.indexOf(32);
            this.linkOutComponent = this.linkOutComponent.substring(0, idx);
        }
        this.linkOutEvent = this.linkEventSelector.getText();
        if (this.linkOutEvent.length() == 0) {
            canFlip = false;
        }
        this.trxCode = this.trxCodeText.getText();
        if (this.linkToTrx && this.trxCode.length() == 0) {
            canFlip = false;
        }
        return canFlip;
    }

    public String getLinkOutComponent() {
        return this.linkOutComponent;
    }

    public String getLinkOutEvent() {
        return this.linkOutEvent;
    }

    public String getLinkToTrxCode() {
        return this.trxCode;
    }

    public boolean linkToTask() {
        return this.linkToTrx;
    }

    private void selectLinkTaskCode() {
        Object opName = null;
        String[] extensions = new String[]{"*.ttx"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        System.out.println("RootPath:" + this.rootPath);
        if (this.rootPath != null) {
            fileDialog.setFilterPath(String.valueOf(this.rootPath) + "/designFiles/TellerTrxs");
        } else {
            fileDialog.setFilterPath("./designFiles/MCITrxs");
        }
        fileDialog.setFilterExtensions(extensions);
        String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        this.loadTrxFileInfo(fileName);
    }

    private void loadTrxFileInfo(String fileName) {
        try {
            XMLElementObjectMaker maker = new XMLElementObjectMaker();
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)maker);
            XMLNode aNode = (XMLNode)loader.loadXMLFile(fileName);
            if (aNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file!");
                return;
            }
            String trxCode = aNode.getAttrValue("trxCode");
            if (trxCode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file [trxCode] not defined!");
                return;
            }
            this.trxCodeText.setText(trxCode);
            XMLNode datasNode = aNode.getChild("datas");
            if (datasNode == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Invalide Teller Transaction define file [trxCode] not defined!");
                return;
            }
            this.refDataNode = datasNode;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setXMLContent(XMLNode node) {
        this.viewNode = node;
    }

    public XMLNode getLinkToDatasNode() {
        return this.refDataNode;
    }

    private void loadXMLContent(XMLNode node) {
        Vector childs = node.getChilds();
        if (childs == null) {
            return;
        }
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            String nodeName = aNode.getNodeName();
            if (!(nodeName.equals("LinkBean") || nodeName.equals("Label") || nodeName.equals("OperationPanel"))) {
                this.linkComponentSelector.add(String.valueOf(aNode.getAttrValue("name")) + " [" + aNode.getNodeName() + "]");
                this.loadXMLContent(aNode);
            }
            ++i;
        }
    }

    public boolean getHaveInView() {
        return this.inViewButton.getSelection();
    }

    public boolean getHaveOutView() {
        return this.outViewButton.getSelection();
    }
}

