/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.xml;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.xml.Messages;
import com.ecc.ide.editor.xml.XMLEditorFramePanel;
import com.ecc.ide.editor.xml.XMLElementWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementChild;
import com.swtdesigner.ResourceManager;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class XMLContentPanel
extends Composite
implements SelectionListener {
    private Tree contentTree;
    private XMLElementWrapper rootWrapper;
    Menu newMenu;
    XMLEditorFramePanel editor;
    private boolean isCtrlDown = false;
    private int cutMode;
    private TreeItem[] copyItems;
    private String elementType;
    private XMLNode[] copyNodes;
    private Element element;
    static /* synthetic */ Class class$0;

    public XMLContentPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.contentTree = new Tree((Composite)this, 2050);
        this.contentTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    XMLContentPanel.this.deleteSelectedItems();
                }
                if (e.keyCode == 262144) {
                    XMLContentPanel.this.isCtrlDown = true;
                }
                if (XMLContentPanel.this.isCtrlDown && e.keyCode == 99) {
                    XMLContentPanel.this.copySelectedItems();
                }
                if (XMLContentPanel.this.isCtrlDown && e.keyCode == 120) {
                    XMLContentPanel.this.cutSelectedItems();
                }
                if (XMLContentPanel.this.isCtrlDown && e.keyCode == 118) {
                    XMLContentPanel.this.pastSelectedItems();
                }
            }

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 262144) {
                    XMLContentPanel.this.isCtrlDown = false;
                }
            }
        });
        this.contentTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = XMLContentPanel.this.contentTree.getSelection();
                if (items.length > 0) {
                    XMLElementWrapper wrapper = (XMLElementWrapper)items[0].getData();
                    if (XMLContentPanel.this.editor != null) {
                        XMLContentPanel.this.editor.setActivateWrapper(wrapper);
                    }
                }
            }
        });
        Menu popupmenu = new Menu((Control)this.contentTree);
        MenuItem newMenuItem = new MenuItem(popupmenu, 64);
        newMenuItem.setText(Messages.getString("XMLContentPanel.New_1"));
        this.newMenu = new Menu(popupmenu);
        newMenuItem.setMenu(this.newMenu);
        new MenuItem(popupmenu, 2);
        MenuItem menuItem = new MenuItem(popupmenu, 0);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLContentPanel.this.copySelectedItems();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem.setImage(ResourceManager.getImage(clazz, "/images/copy_edit.gif"));
        menuItem.setText(Messages.getString("XMLContentPanel.Copy_2"));
        MenuItem menuItem_1 = new MenuItem(popupmenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLContentPanel.this.pastSelectedItems();
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_1.setImage(ResourceManager.getImage(clazz2, "/images/paste_edit.gif"));
        menuItem_1.setText(Messages.getString("XMLContentPanel.Past_4"));
        MenuItem menuItem_2 = new MenuItem(popupmenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLContentPanel.this.cutSelectedItems();
            }
        });
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_2.setImage(ResourceManager.getImage(clazz3, "/images/cut_edit.gif"));
        menuItem_2.setText(Messages.getString("XMLContentPanel.Cut_6"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_3 = new MenuItem(popupmenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLContentPanel.this.deleteSelectedItems();
            }
        });
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("com.ecc.ide.editor.xml.XMLContentPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        menuItem_3.setImage(ResourceManager.getImage(clazz4, "/images/delete_edit.gif"));
        menuItem_3.setText(Messages.getString("XMLContentPanel.Delete_8"));
        this.contentTree.setMenu(popupmenu);
    }

    public void addXMLElement(XMLElementWrapper wrapper) {
        if (this.rootWrapper == null) {
            TreeItem item;
            this.rootWrapper = wrapper;
            wrapper.item = item = new TreeItem(this.contentTree, 0);
            item.setData((Object)wrapper);
            item.setText(wrapper.getText());
            if (wrapper.getElement() != null && wrapper.getElement().getImage() != null) {
                item.setImage(wrapper.getElement().getImage());
            }
        } else {
            TreeItem[] items = this.contentTree.getSelection();
            TreeItem item = items[0];
            XMLElementWrapper aWrapper = (XMLElementWrapper)item.getData();
            TreeItem aItem = new TreeItem(item, 0);
            aItem.setText(wrapper.getText());
            aItem.setData((Object)wrapper);
            if (wrapper.getElement() != null && wrapper.getElement().getImage() != null) {
                aItem.setImage(wrapper.getElement().getImage());
            }
            wrapper.item = aItem;
        }
    }

    public void addXMLElement(XMLElementWrapper parent, XMLElementWrapper wrapper) {
        TreeItem item = parent.item;
        TreeItem aItem = new TreeItem(item, 0);
        aItem.setText(wrapper.getText());
        aItem.setData((Object)wrapper);
        if (wrapper.getElement().getImage() != null) {
            aItem.setImage(wrapper.getElement().getImage());
        }
        wrapper.item = aItem;
    }

    public void deleteSelectedItems() {
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length != 0) {
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.sure_to_Delete_1"), (String)Messages.getString("XMLContentPanel.are_you_sure_to_delete_the_Selected_XMLNode__2"))) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                if (items[i].getParentItem() == null) {
                    return;
                }
                XMLElementWrapper wrapper = (XMLElementWrapper)items[i].getData();
                if (this.editor != null) {
                    this.editor.deleteWrapper(wrapper);
                    items[i].dispose();
                }
                ++i;
            }
        }
    }

    public void copySelectedItems() {
        XMLElementWrapper aWrapper;
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length == 0) {
            return;
        }
        XMLElementWrapper wrapper = (XMLElementWrapper)items[0].getData();
        String nodeName = wrapper.xmlNode.getNodeName();
        int i = 0;
        while (i < items.length) {
            aWrapper = (XMLElementWrapper)items[i].getData();
            String aNodeName = aWrapper.xmlNode.getNodeName();
            if (!aNodeName.equals(nodeName)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.Warning_9"), (String)Messages.getString("XMLContentPanel.You_are_not_allowed_to_copy_different_type_elements_!_10"));
                return;
            }
            ++i;
        }
        this.element = wrapper.element;
        this.elementType = nodeName;
        this.cutMode = 0;
        this.copyItems = new TreeItem[items.length];
        this.copyNodes = new XMLNode[items.length];
        i = 0;
        while (i < items.length) {
            this.copyItems[i] = items[i];
            aWrapper = (XMLElementWrapper)items[i].getData();
            this.copyNodes[i] = aWrapper.xmlNode;
            ++i;
        }
    }

    public void pastSelectedItems() {
        if (this.copyItems == null || this.copyItems.length == 0) {
            return;
        }
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLElementWrapper wrapper = (XMLElementWrapper)items[0].getData();
        Vector elementChilds = wrapper.element.getChilds();
        if (elementChilds == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.Warning_11"), (String)Messages.getString("XMLContentPanel.You_are_not_allow_to_past_such_element_to_selected_item_!_12"));
            return;
        }
        boolean allowed = false;
        int i = 0;
        while (i < elementChilds.size()) {
            ElementChild child = (ElementChild)elementChilds.elementAt(i);
            String elementId = child.getChildElementId();
            if (elementId.equals(this.elementType)) {
                allowed = true;
                break;
            }
            ++i;
        }
        if (!allowed) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.Warning_13"), (String)Messages.getString("XMLContentPanel.You_are_not_allow_to_past_such_element_to_selected_item_!_14"));
            return;
        }
        if (this.cutMode == 1) {
            i = 0;
            while (i < this.copyItems.length) {
                this.copyItems[i].dispose();
                ++i;
            }
            this.cutMode = 0;
        }
        if (items[0].isDisposed()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.Error_15"), (String)Messages.getString("XMLContentPanel.You_are_have_past_the_item_to_cuted_item_!_16"));
            return;
        }
        XMLNode pNode = wrapper.xmlNode;
        int i2 = 0;
        while (i2 < this.copyNodes.length) {
            XMLNode aNode = (XMLNode)this.copyNodes[i2].clone();
            pNode.add(aNode);
            XMLElementWrapper aWrapper = new XMLElementWrapper(aNode, this.editor.profile);
            aWrapper.setWrapperOwner(this.editor);
            aWrapper.parent = wrapper;
            this.addXMLElement(wrapper, aWrapper);
            this.addXMLElementToContent(aWrapper, aNode);
            ++i2;
        }
    }

    public void addXMLElementToContent(XMLElementWrapper parent, XMLNode node) {
        Vector childs = node.getChilds();
        EditorProfile profile = this.editor.profile;
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (profile.getElement(aNode.getNodeName()) != null) {
                XMLElementWrapper wrapper = new XMLElementWrapper(aNode, profile);
                wrapper.setWrapperOwner(this.editor);
                wrapper.parent = parent;
                this.addXMLElement(parent, wrapper);
                this.addXMLElementToContent(wrapper, aNode);
            }
            ++i;
        }
    }

    public void cutSelectedItems() {
        XMLElementWrapper aWrapper;
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length == 0) {
            return;
        }
        XMLElementWrapper wrapper = (XMLElementWrapper)items[0].getData();
        String nodeName = wrapper.xmlNode.getNodeName();
        int i = 0;
        while (i < items.length) {
            aWrapper = (XMLElementWrapper)items[i].getData();
            String aNodeName = aWrapper.xmlNode.getNodeName();
            if (!aNodeName.equals(nodeName)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("XMLContentPanel.Warning_17"), (String)Messages.getString("XMLContentPanel.You_are_not_allowed_to_copy_different_type_elements_!_18"));
                return;
            }
            ++i;
        }
        this.element = wrapper.element;
        this.elementType = nodeName;
        this.cutMode = 1;
        this.copyItems = new TreeItem[items.length];
        this.copyNodes = new XMLNode[items.length];
        i = 0;
        while (i < items.length) {
            this.copyItems[i] = items[i];
            aWrapper = (XMLElementWrapper)items[i].getData();
            this.copyNodes[i] = aWrapper.xmlNode;
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void clear() {
        this.rootWrapper = null;
        this.contentTree.removeAll();
    }

    public void setAllowedChilds(Vector elementChilds, EditorProfile profile) {
        while (this.newMenu.getItemCount() > 0) {
            this.newMenu.getItem(0).dispose();
        }
        if (elementChilds == null) {
            return;
        }
        int i = 0;
        while (i < elementChilds.size()) {
            ElementChild child = (ElementChild)elementChilds.elementAt(i);
            String elementId = child.getChildElementId();
            Element aElement = profile.getElement(elementId);
            MenuItem item = new MenuItem(this.newMenu, 0);
            item.setText(elementId);
            item.setData((Object)aElement);
            if (aElement.getImage() != null) {
                item.setImage(aElement.getImage());
            }
            item.addSelectionListener((SelectionListener)this);
            ++i;
        }
    }

    public void moveCurrentItemUp() {
        XMLNode node;
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length == 0) {
            return;
        }
        XMLElementWrapper wrapper = (XMLElementWrapper)items[0].getData();
        XMLNode curNode = wrapper.xmlNode;
        XMLNode pNode = curNode.getParent();
        if (pNode == null) {
            return;
        }
        Vector pNodes = pNode.getChilds();
        int idx = pNodes.indexOf(curNode);
        if (idx == 0) {
            return;
        }
        if ("#text".equals((node = (XMLNode)pNodes.elementAt(--idx)).getNodeName())) {
            --idx;
        }
        int itemIdx = this.getCurrentItemIdx(items[0]);
        if (--itemIdx < 0) {
            return;
        }
        TreeItem pItem = items[0].getParentItem();
        int i = 0;
        while (i < items.length) {
            TreeItem item;
            XMLElementWrapper aWrapper = (XMLElementWrapper)items[i].getData();
            XMLNode aNode = aWrapper.xmlNode;
            items[i].dispose();
            items[i] = item = new TreeItem(pItem, 0, itemIdx);
            item.setData((Object)aWrapper);
            item.setText(aWrapper.getText());
            if (aWrapper.getElement() != null && aWrapper.getElement().getImage() != null) {
                item.setImage(wrapper.getElement().getImage());
            }
            aWrapper.item = item;
            this.addXMLElementToContent(aWrapper, aWrapper.xmlNode);
            pNodes.remove(aNode);
            pNodes.add(idx, aNode);
            ++idx;
            ++itemIdx;
            ++i;
        }
        curNode.fireContentChangedEvent();
        this.contentTree.setSelection(items);
    }

    private int getCurrentItemIdx(TreeItem item) {
        TreeItem pItem = item.getParentItem();
        TreeItem[] childItems = pItem.getItems();
        int i = 0;
        while (i < childItems.length) {
            if (item == childItems[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveCurrentItemDown() {
        XMLNode node;
        TreeItem[] items = this.contentTree.getSelection();
        if (items.length == 0) {
            return;
        }
        XMLElementWrapper wrapper = (XMLElementWrapper)items[items.length - 1].getData();
        XMLNode curNode = wrapper.xmlNode;
        XMLNode pNode = curNode.getParent();
        if (pNode == null) {
            return;
        }
        Vector pNodes = pNode.getChilds();
        int idx = pNodes.indexOf(curNode);
        if (idx == pNodes.size() - 1) {
            return;
        }
        if ("#text".equals((node = (XMLNode)pNodes.elementAt(++idx)).getNodeName())) {
            ++idx;
        }
        TreeItem pItem = items[0].getParentItem();
        int itemIdx = this.getCurrentItemIdx(items[items.length - 1]);
        if (++itemIdx >= pItem.getItemCount()) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            TreeItem item;
            XMLElementWrapper aWrapper = (XMLElementWrapper)items[i].getData();
            XMLNode aNode = aWrapper.xmlNode;
            items[i].dispose();
            items[i] = item = new TreeItem(pItem, 0, itemIdx);
            item.setData((Object)aWrapper);
            item.setText(aWrapper.getText());
            if (aWrapper.getElement() != null && aWrapper.getElement().getImage() != null) {
                item.setImage(wrapper.getElement().getImage());
            }
            aWrapper.item = item;
            this.addXMLElementToContent(aWrapper, aWrapper.xmlNode);
            pNodes.remove(aNode);
            pNodes.add(idx, aNode);
            ++i;
        }
        curNode.fireContentChangedEvent();
        this.contentTree.setSelection(items);
    }

    public void widgetSelected(SelectionEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        Element element = (Element)item.getData();
        this.editor.doInsert(element);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

