/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.yui;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.yui.PanelWrapper;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MenuWrapper
extends VisualElementWrapper {
    boolean drawTitle = true;
    String[] attrToShow;
    String[] attrToShowLabel;
    public static int vSpace = 5;
    public static int hSpace = 5;
    public static int panelHeight = 35;

    public boolean isRelaDiv(PanelWrapper divWrapper) {
        if (!this.isActivated) {
            return false;
        }
        String id = divWrapper.getAttrValue("id");
        if (id == null) {
            return false;
        }
        if (id.equals(this.getAttrValue("ContentDiv"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("RelativeDiv"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("HelpDiv"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("AdvertDiv"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("menu1"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("menu2"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("menu3"))) {
            return true;
        }
        if (id.equals(this.getAttrValue("menu4"))) {
            return true;
        }
        return id.equals(this.getAttrValue("menu5"));
    }

    public MenuWrapper() {
        this.setResizable(false);
        this.setMoveable(false);
    }

    public MenuWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public int getRectColor() {
        if (this.isActivated) {
            return 5;
        }
        return 15;
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        this.x = this.getParentWrapper().width / 2 + 20;
        this.y = 5;
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Image image = this.element.getImage();
        int txtY = y + 2;
        int imgW = 0;
        if (image != null) {
            txtY += image.getBounds().height;
            imgW = image.getBounds().width;
        }
        String label = this.getElement().getLabel();
        if (this.getAttrValue("id") != null) {
            label = String.valueOf(this.getAttrValue("id")) + ":[" + label + "]";
        }
        int w = gc.getFontMetrics().getAverageCharWidth() * label.getBytes().length;
        int h = gc.getFontMetrics().getHeight();
        if (this.isActivated) {
            gc.setBackground(Display.getDefault().getSystemColor(this.getRectColor()));
            gc.fillRectangle(x + (this.width - w) / 2, y + 3, this.width / 2, this.height / 2 - 3);
        }
        if (image != null) {
            gc.drawImage(image, x + (this.width - w) / 2, y + 3);
        }
        gc.drawText(label, x + imgW + 3 + (this.width - w) / 2, y + 3);
    }

    public boolean isCanLinkOut() {
        return true;
    }

    public boolean isCanLinkIn(VisualElementWrapper wrapper) {
        return false;
    }

    protected void paintActivateSymbol(GC gc, int xOff, int yOff) {
        super.paintActivateSymbol(gc, xOff, yOff);
        this.paintLayoutData(gc, xOff, yOff);
    }

    protected void paintLayoutData(GC gc, int xOff, int yOff) {
    }

    public boolean canBeDelete() {
        if ("true".equals(this.getAttrValue("fromTemplate"))) {
            MessageDialog.openError(null, (String)"\u786e\u8ba4", (String)"\u8be5\u9879\u4e0d\u5141\u8bb8\u5220\u9664");
            return false;
        }
        return true;
    }
}

