/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.yui;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.yui.YUIMVCSelectDialog;
import com.ecc.ide.visualeditor.VisualEditorContentPanel;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class YUILayoutPanel
extends VisualEditorFramePanel {
    private IProject project;

    public void setProject(IProject prj) {
        this.project = prj;
    }

    public IProject getProject() {
        return this.project;
    }

    public YUILayoutPanel(Composite parent, int style) {
        super(parent, style);
        this.workingArea.setBackground(Display.getCurrent().getSystemColor(1));
    }

    private XMLNode loadXMLFile(IFile file) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void mouseMove(int offx, int offy) {
        int temp = this.workingArea.getBounds().y;
        Composite obj = this.getParent();
        while (obj != null) {
            temp += obj.getBounds().y;
            obj = obj.getParent();
        }
        offy = temp = offy - temp - 60;
        temp = this.workingArea.getBounds().x;
        obj = this.getParent();
        while (obj != null) {
            temp += obj.getBounds().x;
            obj = obj.getParent();
        }
        VisualElementWrapper wrapper = this.workingArea.editor.getVisualElement(offx = (temp = offx - temp) - this.editorToolPanel.getBounds().width, offy);
        if (wrapper == null) {
            return;
        }
        this.setActivateWrapper(wrapper);
        this.redraw();
    }

    public void addMVCRef(IFile file, int offx, int offy) {
        VisualElementWrapper wrapper = this.getActivateVisualElement();
        if (wrapper == null) {
            return;
        }
        this.setActivateWrapper(wrapper);
        this.redraw();
        if (!"panel".equals(wrapper.getXMLNode().getNodeName()) && !"div".equals(wrapper.getXMLNode().getNodeName())) {
            return;
        }
        XMLNode node = this.loadXMLFile(file);
        Vector<String> actions = new Vector<String>();
        int i = 0;
        while (i < node.getChilds().size()) {
            XMLNode child = (XMLNode)node.getChilds().elementAt(i);
            if ("action".equals(child.getNodeName())) {
                actions.add(child.getAttrValue("id"));
            }
            ++i;
        }
        if (actions.size() == 0) {
            return;
        }
        if (actions.size() == 1) {
            wrapper.setAttrValue("source", actions.elementAt(0) + ".do");
            this.updateWrapperProperties(wrapper);
            return;
        }
        if (actions.size() > 1) {
            YUIMVCSelectDialog dialog = new YUIMVCSelectDialog(this.getShell());
            dialog.setList(actions);
            dialog.open();
            wrapper.setAttrValue("source", actions.elementAt(dialog.selectIdx) + ".do");
            this.updateWrapperProperties(wrapper);
        }
    }

    public void addGRDRef(IFile file, int offx, int offy) {
        VisualElementWrapper wrapper = this.getActivateVisualElement();
        if (wrapper == null) {
            return;
        }
        this.setActivateWrapper(wrapper);
        this.redraw();
        if (!"menu".equals(wrapper.getXMLNode().getNodeName())) {
            return;
        }
        String path = file.getLocation().toOSString();
        String group = IDEContent.getGroupId(path);
        path = path.substring(path.indexOf("designFiles\\mvcs\\" + group + "\\") + ("designFiles\\mvcs\\" + group + "\\").length());
        wrapper.setAttrValue("MenuData", path);
        this.updateWrapperProperties(wrapper);
    }

    public VisualEditorContentPanel getWorkArea() {
        return this.workingArea;
    }
}

