/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editor.yui;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.yui.ContentWrapper;
import com.ecc.ide.editor.yui.DesktopWrapper;
import com.ecc.ide.editor.yui.YUILayoutPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class YUIWrapper
extends VisualElementWrapper {
    boolean drawTitle = true;
    String[] attrToShow;
    String[] attrToShowLabel;
    public static int vSpace = 5;
    public static int hSpace = 5;

    public YUIWrapper() {
        this.setResizable(false);
        this.setMoveable(false);
    }

    abstract int getRectColor();

    public YUIWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        if (this instanceof DesktopWrapper) {
            this.layout();
            ((YUILayoutPanel)this.editor).getWorkArea().setSize(this.width + 10, this.height + 10);
        }
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        gc.setForeground(Display.getDefault().getSystemColor(2));
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        if (this.showHead()) {
            Image image = this.element.getImage();
            int txtY = y + 2;
            int imgW = 0;
            if (image != null) {
                txtY += image.getBounds().height;
                imgW = image.getBounds().width;
            }
            Color bk = gc.getBackground();
            gc.setBackground(Display.getDefault().getSystemColor(this.getRectColor()));
            gc.fillRectangle(x + 1, y + 1, this.width, txtY - y + 2);
            String label = this.getElement().getLabel();
            if (this.getAttrValue("id") != null) {
                label = String.valueOf(this.getAttrValue("id")) + ":[" + label + "]";
            }
            int w = gc.getFontMetrics().getAverageCharWidth() * label.getBytes().length;
            int h = gc.getFontMetrics().getHeight();
            if (image != null) {
                gc.drawImage(image, x + (this.width - w) / 2, y + 3);
            }
            gc.drawText(label, x + imgW + 3 + (this.width - w) / 2, y + 3);
            gc.drawLine(x, txtY + 3, x + this.width, txtY + 3);
            txtY += h + 1;
            gc.setBackground(Display.getDefault().getSystemColor(1));
            if (this.attrToShow != null) {
                int i = 0;
                while (i < this.attrToShow.length) {
                    String str = this.attrToShowLabel[i];
                    String attrValue = this.getAttrValue(this.attrToShow[i]);
                    if (attrValue != null) {
                        str = String.valueOf(str) + attrValue;
                    }
                    gc.drawText(str, x + 10, txtY);
                    txtY += h + 3;
                    ++i;
                }
            }
        } else if (!(this instanceof DesktopWrapper)) {
            gc.setBackground(Display.getDefault().getSystemColor(this.getRectColor()));
            gc.fillRectangle(xOffset + this.x + 1, yOffset + this.y + 1, this.getCWidth() - 1, this.getCHeight() - 1);
        }
        gc.drawRectangle(x, y, this.width, this.height);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            if (this instanceof ContentWrapper) {
                boolean bl = false;
            }
            wrapper.paintControl(gc, x, y);
            ++i;
        }
        gc.setClipping(parentClipRect);
    }

    public boolean isCanLinkOut() {
        return true;
    }

    public boolean isCanLinkIn(VisualElementWrapper wrapper) {
        return false;
    }

    protected void paintActivateSymbol(GC gc, int xOff, int yOff) {
        super.paintActivateSymbol(gc, xOff, yOff);
        this.paintLayoutData(gc, xOff, yOff);
    }

    protected void paintLayoutData(GC gc, int xOff, int yOff) {
    }

    public abstract boolean showHead();

    public abstract int getCHeight();

    public abstract int getCWidth();

    public DesktopWrapper getDesktopWrapper() {
        YUIWrapper tempWrapper;
        block4: {
            try {
                tempWrapper = this;
                while (!(tempWrapper instanceof DesktopWrapper)) {
                    if ((tempWrapper = (YUIWrapper)tempWrapper.getParentWrapper()) == null) break;
                }
                if (tempWrapper != null) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return (DesktopWrapper)tempWrapper;
    }

    public int getCX() {
        this.x = hSpace;
        return this.x;
    }

    public int getCY() {
        this.y = vSpace;
        return this.y;
    }

    public void layout() {
        this.getCWidth();
        this.getCX();
        int i = 0;
        while (i < this.childs.size()) {
            if (this.childs.elementAt(i) instanceof YUIWrapper) {
                ((YUIWrapper)this.childs.elementAt(i)).layout();
            }
            ++i;
        }
        this.getCHeight();
        this.getCY();
    }

    public Vector getDivs() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.childs.size()) {
            if (this.childs.elementAt(i) instanceof YUIWrapper) {
                YUIWrapper child = (YUIWrapper)this.childs.elementAt(i);
                if ("div".equals(child.node.getNodeName()) && child.getAttrValue("id") != null) {
                    result.add(child.getAttrValue("id"));
                }
                Vector aResult = child.getDivs();
                int w = 0;
                while (w < aResult.size()) {
                    if (aResult.elementAt(w) != null) {
                        result.add((String)aResult.elementAt(w));
                    }
                    ++w;
                }
            }
            ++i;
        }
        return result;
    }

    public Vector getMenuBars() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.childs.size()) {
            if (this.childs.elementAt(i) instanceof YUIWrapper) {
                YUIWrapper child = (YUIWrapper)this.childs.elementAt(i);
                if ("menubar".equals(child.node.getNodeName()) && child.getAttrValue("id") != null) {
                    result.add(child.getAttrValue("id"));
                }
                Vector aResult = child.getMenuBars();
                int w = 0;
                while (w < aResult.size()) {
                    if (aResult.elementAt(w) != null) {
                        result.add((String)aResult.elementAt(w));
                    }
                    ++w;
                }
            }
            ++i;
        }
        return result;
    }

    public boolean canBeDelete() {
        if ("true".equals(this.getAttrValue("fromTemplate"))) {
            MessageDialog.openError(null, (String)"\u786e\u8ba4", (String)"\u8be5\u9879\u4e0d\u5141\u8bb8\u5220\u9664");
            return false;
        }
        return true;
    }

    public boolean isAcceptable(Element anElement) {
        if (!super.isAcceptable(anElement)) {
            return false;
        }
        if (this instanceof ContentWrapper) {
            if (((ContentWrapper)this).isGridStyle() && ((ContentWrapper)this).isUnitStyle()) {
                return true;
            }
            if (((ContentWrapper)this).isGridStyle() && "unit".equals(anElement.getElementName())) {
                return false;
            }
            if (((ContentWrapper)this).isUnitStyle()) {
                if ("grid".equals(anElement.getElementName())) {
                    return false;
                }
                if ("panel".equals(anElement.getElementName())) {
                    return false;
                }
                if ("div".equals(anElement.getElementName())) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public void addChild(VisualElementWrapper child) {
        if (child.getAttrValue("id") == null || child.getAttrValue("id").length() == 0) {
            child.setAttrValue("id", child.getAttrValue("name"));
        }
        this.childs.addElement(child);
        child.setTabOrder(this.childs.size() - 1);
    }
}

