/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.ProfileObject;
import com.ecc.util.xmlloader.Externalizable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.w3c.dom.Node;

public class EditorProfile
extends ProfileObject
implements Externalizable {
    private String projectRootPath;
    private Vector elementCatalogs = new Vector(10);
    private String title;
    private String rootElementName;

    public Externalizable initializeFrom(Node node) {
        this.title = this.getAttributeValue("title", node);
        this.rootElementName = this.getAttributeValue("rootElement", node);
        return this;
    }

    public Vector getCagalogs() {
        return this.elementCatalogs;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String value) {
        this.rootElementName = value;
    }

    public void add(Externalizable obj) {
        this.elementCatalogs.addElement(obj);
        ((ElementCatalog)obj).profile = this;
    }

    public void toXMLString(StringBuffer strBuf) {
        strBuf.append("<?xml version=\"1.0\" encoding=\"");
        strBuf.append(System.getProperty("file.encoding"));
        strBuf.append("\" ?>\r\n\r\n");
        strBuf.append("<EditorProfile");
        if (this.rootElementName != null) {
            strBuf.append(" rootElement=\"" + this.rootElementName + "\"");
        }
        if (this.title != null) {
            strBuf.append(" title=\"" + this.title + "\"");
        }
        strBuf.append(">\r\n");
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ProfileObject po = (ProfileObject)this.elementCatalogs.elementAt(i);
            po.toXMLString(strBuf);
            ++i;
        }
        strBuf.append("</EditorProfile>\r\n");
    }

    public void addElementCatalog(ElementCatalog catalog) {
        this.elementCatalogs.addElement(catalog);
        catalog.profile = this;
    }

    public void deleteElementCatalog(ElementCatalog catalog) {
        this.elementCatalogs.removeElement(catalog);
        int i = 0;
        while (i < catalog.getElements().size()) {
            Element element = (Element)catalog.getElements().elementAt(i);
            this.removeElementReference(element.getElementName());
            ++i;
        }
    }

    public ElementCatalog getElementCatalog(String catalogId) {
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            if (catalogId.equals(catalog.getCatalogName())) {
                return catalog;
            }
            ++i;
        }
        return null;
    }

    public Element getElement(String elementId) {
        if (elementId == null) {
            return null;
        }
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            Element aElement = catalog.getElement(elementId);
            if (aElement != null) {
                aElement.setEditorProfile(this);
                return aElement;
            }
            ++i;
        }
        return null;
    }

    public Element getElement2(String elementId) {
        if (elementId == null) {
            return null;
        }
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            Element aElement = catalog.getElement2(elementId);
            if (aElement != null) {
                aElement.setEditorProfile(this);
                return aElement;
            }
            ++i;
        }
        return null;
    }

    public void deleteElement(String elementId) {
        if (elementId == null) {
            return;
        }
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            Element aElement = catalog.getElement(elementId);
            if (aElement != null) {
                catalog.deleteElement(aElement);
                this.removeElementReference(elementId);
                return;
            }
            ++i;
        }
    }

    private void removeElementReference(String elementId) {
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            int k = 0;
            while (k < catalog.getElements().size()) {
                Element aElement = (Element)catalog.getElements().elementAt(k);
                if (aElement.getAllowedChilds() != null) {
                    int j = 0;
                    while (j < aElement.getAllowedChilds().objs.size()) {
                        ElementChild elementChild = (ElementChild)aElement.getAllowedChilds().objs.elementAt(j);
                        if (elementChild.childElementId.equals(elementId)) {
                            aElement.getAllowedChilds().objs.remove(j);
                            break;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public void updateElementReference(String elementId, String newElementId) {
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            int k = 0;
            while (k < catalog.getElements().size()) {
                Element aElement = (Element)catalog.getElements().elementAt(k);
                if (aElement.getAllowedChilds() != null) {
                    int j = 0;
                    while (j < aElement.getAllowedChilds().objs.size()) {
                        ElementChild elementChild = (ElementChild)aElement.getAllowedChilds().objs.elementAt(j);
                        if (elementChild.childElementId.equals(elementId)) {
                            elementChild.childElementId = newElementId;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    public IProject getProject() {
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.getLocation().toString().equals(this.projectRootPath)) {
                    return project;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setProjectRootPath(String path) {
        this.projectRootPath = path;
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            catalog.profile = this;
            Vector elements = catalog.getElements();
            int k = 0;
            while (k < elements.size()) {
                Element element = (Element)elements.elementAt(k);
                element.profile = this;
                ++k;
            }
            ++i;
        }
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public int getElementCount() {
        int count = 0;
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            count += catalog.getElements().size();
            ++i;
        }
        return count;
    }

    public Object clone() {
        EditorProfile profile = new EditorProfile();
        profile.projectRootPath = this.projectRootPath;
        profile.elementCatalogs = new Vector(10);
        profile.title = this.title;
        profile.rootElementName = this.rootElementName;
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            profile.elementCatalogs.addElement(catalog.clone());
            ++i;
        }
        return profile;
    }

    public Element getDefaultElement(String elementId) {
        try {
            Element element = this.getElement("defaultElement" + elementId);
            if (element != null) {
                return element;
            }
            element = this.getElement("defaultElement");
            if (element != null) {
                return element;
            }
        }
        catch (Exception e) {
            try {
                Element element = this.getElement("defaultElement");
                if (element != null) {
                    return element;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Vector getElements() {
        Vector<Element> result = new Vector<Element>();
        int i = 0;
        while (i < this.elementCatalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)this.elementCatalogs.elementAt(i);
            int j = 0;
            while (j < catalog.getElements().size()) {
                Element element = (Element)catalog.getElements().elementAt(j);
                result.add(element);
                ++j;
            }
            ++i;
        }
        return result;
    }
}

