/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.Document;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.ObjectCollection;
import com.ecc.ide.editorprofile.ProfileObject;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.util.xmlloader.Externalizable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.w3c.dom.Node;

public class Element
extends ProfileObject
implements Externalizable {
    EditorProfile profile;
    ObjectCollection childs;
    protected ObjectCollection attrs;
    String elementName;
    String label;
    String implClass;
    String classPattern;
    String wrapperClass;
    String editClass;
    String visualType;
    String iconName;
    String newWizardClass;
    Image image;
    int objCount = 1;
    Document document;
    boolean isBuildIn = false;
    boolean visable = true;
    public String destCatalog = "extendedElements";
    static /* synthetic */ Class class$0;

    public Element() {
    }

    public Element(XMLNode elementNode) {
        XMLNode childsNode;
        XMLNode attrsNode;
        this.elementName = elementNode.getAttrValue("id");
        this.label = elementNode.getAttrValue("name");
        this.implClass = elementNode.getAttrValue("implClass");
        this.classPattern = elementNode.getAttrValue("classPattern");
        this.wrapperClass = elementNode.getAttrValue("wrapperClass");
        this.iconName = elementNode.getAttrValue("iconName");
        this.setIconName(this.iconName);
        this.newWizardClass = elementNode.getAttrValue("wizardClass");
        this.visualType = elementNode.getAttrValue("visualType");
        this.isBuildIn = "true".equalsIgnoreCase(elementNode.getAttrValue("isBuildIn"));
        this.editClass = elementNode.getAttrValue("editClass");
        if (elementNode.getChild("document") != null) {
            this.document = new Document(elementNode.getChild("document").getNodeValue());
        }
        if ((attrsNode = elementNode.getChild("attributes")) != null) {
            int i = 0;
            while (i < attrsNode.getChilds().size()) {
                ElementAttribute attr = new ElementAttribute((XMLNode)attrsNode.getChilds().elementAt(i));
                this.addAttribute(attr);
                ++i;
            }
        }
        if ((childsNode = elementNode.getChild("childElements")) != null) {
            int i = 0;
            while (i < childsNode.getChilds().size()) {
                ElementChild attr = new ElementChild((XMLNode)childsNode.getChilds().elementAt(i));
                this.addChild(attr);
                ++i;
            }
        }
    }

    public Externalizable initializeFrom(Node node) {
        this.elementName = super.getAttributeValue("id", node);
        this.implClass = this.getAttributeValue("implClass", node);
        this.classPattern = this.getAttributeValue("classPattern", node);
        this.wrapperClass = this.getAttributeValue("wrapperClass", node);
        this.iconName = this.getAttributeValue("iconName", node);
        String description = this.getAttributeValue("desc", node);
        if (description != null && description.length() > 0) {
            this.setDocument(description);
        }
        this.newWizardClass = this.getAttributeValue("wizardClass", node);
        this.visualType = this.getAttributeValue("visualType", node);
        this.isBuildIn = "true".equals(this.getAttributeValue("isBuildIn", node));
        this.label = this.getAttributeValue("name", node);
        this.setIconName(this.iconName);
        if ("false".equals(this.getAttributeValue("visable", node))) {
            this.visable = false;
        }
        this.editClass = this.getAttributeValue("editClass", node);
        return this;
    }

    public void add(Externalizable obj) {
        if (obj instanceof Document) {
            this.document = (Document)obj;
            return;
        }
        ObjectCollection oc = (ObjectCollection)obj;
        if (oc.getID().equals("attributes")) {
            this.attrs = oc;
        } else {
            this.childs = oc;
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String name) {
        this.elementName = name;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.elementName;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getWizardClassType() {
        return this.newWizardClass;
    }

    public void setWizardClassType(String classType) {
        this.newWizardClass = classType;
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String setClassPattern(String classPattern) {
        this.classPattern = classPattern;
        return this.classPattern;
    }

    public void setImplClass(String classType) {
        this.implClass = classType;
    }

    public String getWrapperClassType() {
        return this.wrapperClass;
    }

    public String getVisualType() {
        return this.visualType;
    }

    public void setVisualType(String value) {
        this.visualType = value;
    }

    public void setWrapperClassType(String classType) {
        this.wrapperClass = classType;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        if (iconName == null || iconName.length() == 0) {
            this.image = null;
            return;
        }
        this.iconName = iconName;
        this.image = null;
        try {
            InputStream in;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ecc.ide.editorprofile.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((in = clazz.getResourceAsStream(iconName)) != null) {
                ImageData source = new ImageData(in);
                ImageData mask = source.getTransparencyMask();
                this.image = new Image(null, source, mask);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.image == null && this.profile != null) {
            try {
                String rootPath = this.profile.getProjectRootPath();
                if (rootPath != null) {
                    String fileName = String.valueOf(rootPath) + "/icons/" + iconName;
                    FileInputStream fi = new FileInputStream(fileName);
                    this.image = new Image(null, (InputStream)fi);
                    fi.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setDocument(String desc) {
        if (this.document == null) {
            this.document = new Document();
        }
        this.document.setDocument(desc);
    }

    public String getDocument() {
        if (this.document != null) {
            return this.document.getDocument();
        }
        return "";
    }

    public Image getImage() {
        if (this.image == null && this.iconName != null) {
            try {
                String rootPath = this.profile.getProjectRootPath();
                if (rootPath != null) {
                    String fileName = String.valueOf(rootPath) + "/icons/" + this.iconName;
                    FileInputStream fi = new FileInputStream(fileName);
                    this.image = new Image(null, (InputStream)fi);
                    fi.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.image;
    }

    public static Image getErrorImage() {
        return new Image(null, ECCIDEPlugin.getFile("/icons/error.gif"));
    }

    public Vector getChilds() {
        if (this.childs != null) {
            return this.childs.getObjects();
        }
        return null;
    }

    public Vector getAttributes() {
        if (this.attrs != null) {
            return this.attrs.getObjects();
        }
        return null;
    }

    public void setAttributes(Vector value) {
        this.attrs = new ObjectCollection();
        this.attrs.id = "attributes";
        this.attrs.objs = value;
    }

    public void toXMLString(StringBuffer strBuf) {
        strBuf.append("\t\t<Element id=\"");
        strBuf.append(this.elementName);
        strBuf.append("\"");
        if (this.label != null && this.label.length() > 0) {
            strBuf.append(" name=\"" + this.label + "\"");
        }
        if (this.implClass != null) {
            strBuf.append(" implClass=\"");
            strBuf.append(this.implClass);
            strBuf.append("\"");
        }
        if (this.classPattern != null) {
            strBuf.append(" classPattern=\"");
            strBuf.append(this.classPattern);
            strBuf.append("\"");
        }
        if (this.wrapperClass != null) {
            strBuf.append(" wrapperClass=\"");
            strBuf.append(this.wrapperClass);
            strBuf.append("\"");
        }
        if (this.visualType != null) {
            strBuf.append(" visualType=\"");
            strBuf.append(this.visualType);
            strBuf.append("\"");
        }
        if (this.iconName != null) {
            strBuf.append(" iconName=\"");
            strBuf.append(this.iconName);
            strBuf.append("\"");
        }
        if (this.newWizardClass != null) {
            strBuf.append(" wizardClass=\"");
            strBuf.append(this.newWizardClass);
            strBuf.append("\"");
        }
        if (this.editClass != null && this.editClass.length() > 0) {
            strBuf.append(" editClass=\"");
            strBuf.append(this.editClass);
            strBuf.append("\"");
        }
        if (this.isBuildIn) {
            strBuf.append(" isBuildIn=\"true\"");
        }
        if (!this.visable) {
            strBuf.append(" visable=\"false\"");
        }
        strBuf.append(">\r\n");
        if (this.attrs != null) {
            this.attrs.toXMLString(strBuf);
        }
        if (this.childs != null) {
            this.childs.toXMLString(strBuf);
        }
        if (this.document != null) {
            this.document.toXMLString(strBuf);
        }
        strBuf.append("\t\t</Element>\r\n");
    }

    public void addAttribute(ElementAttribute attr) {
        if (this.attrs == null) {
            this.attrs = new ObjectCollection();
            this.attrs.id = "attributes";
        }
        int i = 0;
        while (i < this.attrs.getObjects().size()) {
            ElementAttribute aAttr = (ElementAttribute)this.attrs.getObjects().elementAt(i);
            if (attr.getAttrID().equals(aAttr.getAttrID())) {
                return;
            }
            ++i;
        }
        this.attrs.add(attr);
    }

    public void addChild(ElementChild child) {
        if (this.childs == null) {
            this.childs = new ObjectCollection();
            this.childs.id = "childElements";
        }
        int i = 0;
        while (i < this.childs.getObjects().size()) {
            ElementChild aChild = (ElementChild)this.childs.getObjects().elementAt(i);
            if (aChild.getChildElementId().equals(child.getChildElementId())) {
                return;
            }
            ++i;
        }
        this.childs.add(child);
    }

    public synchronized String getObjectName() {
        String objName = String.valueOf(this.elementName) + this.objCount++;
        return objName;
    }

    public EditorProfile getEditorProfile() {
        return this.profile;
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public void setEditClass(String value) {
        this.editClass = value;
    }

    public String getEditClass() {
        return this.editClass;
    }

    public Object clone() {
        Element element = new Element();
        element.profile = this.profile;
        if (this.childs != null) {
            element.childs = (ObjectCollection)this.childs.clone();
        }
        if (this.attrs != null) {
            element.attrs = (ObjectCollection)this.attrs.clone();
        }
        element.elementName = this.elementName;
        element.label = this.label;
        element.implClass = this.implClass;
        element.classPattern = this.classPattern;
        element.wrapperClass = this.wrapperClass;
        element.editClass = this.editClass;
        element.visualType = this.visualType;
        element.iconName = this.iconName;
        element.newWizardClass = this.newWizardClass;
        element.image = this.image;
        element.visable = this.visable;
        if (this.document != null) {
            element.document = (Document)this.document.clone();
        }
        element.isBuildIn = this.isBuildIn;
        return element;
    }

    public void setAllowedChilds(ObjectCollection value) {
        this.childs = value;
    }

    public ObjectCollection getAllowedChilds() {
        return this.childs;
    }

    public boolean getVisable() {
        return this.visable;
    }

    public boolean getIsBuildIn() {
        return this.isBuildIn;
    }

    public void setVisable(boolean value) {
        this.visable = value;
    }

    public XMLNode toXMLNode() {
        int i;
        XMLNode elementNode = new XMLNode("Element");
        elementNode.setAttrValue("id", this.elementName);
        elementNode.setAttrValue("name", this.label);
        elementNode.setAttrValue("implClass", this.implClass);
        elementNode.setAttrValue("classPattern", this.classPattern);
        elementNode.setAttrValue("wrapperClass", this.wrapperClass);
        elementNode.setAttrValue("iconName", this.iconName);
        elementNode.setAttrValue("wizardClass", this.newWizardClass);
        elementNode.setAttrValue("visualType", this.visualType);
        elementNode.setAttrValue("isBuildIn", String.valueOf(this.isBuildIn));
        elementNode.setAttrValue("editClass", this.editClass);
        if (this.getAttributes() != null && this.getAttributes().size() > 0) {
            XMLNode attrsNode = new XMLNode("attributes");
            elementNode.add(attrsNode);
            i = 0;
            while (i < this.getAttributes().size()) {
                ElementAttribute attr = (ElementAttribute)this.getAttributes().elementAt(i);
                XMLNode attrNode = attr.toXMLNode();
                attrsNode.add(attrNode);
                ++i;
            }
        }
        if (this.getChilds() != null && this.getChilds().size() > 0) {
            XMLNode childsNode = new XMLNode("childElements");
            elementNode.add(childsNode);
            i = 0;
            while (i < this.getChilds().size()) {
                ElementChild child = (ElementChild)this.getChilds().elementAt(i);
                XMLNode childNode = child.toXMLNode();
                childsNode.add(childNode);
                ++i;
            }
        }
        if (this.getDocument() != null) {
            XMLNode docNode = new XMLNode("document");
            docNode.setTextValue(this.getDocument());
            elementNode.add(docNode);
        }
        return elementNode;
    }

    public void setProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public String toString() {
        String result = "";
        result = "<" + this.elementName + ">";
        try {
            int i = 0;
            while (i < this.attrs.getObjects().size()) {
                ElementAttribute aAttr = (ElementAttribute)this.attrs.getObjects().elementAt(i);
                result = String.valueOf(result) + "\r\n\t <attr " + "id=\"" + aAttr.getAttrID() + "\"/>";
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = String.valueOf(result) + "\r\n</" + this.elementName + "/>";
        return result;
    }

    public boolean hasClassAttr() {
        int i = 0;
        while (i < this.attrs.getObjects().size()) {
            ElementAttribute aAttr = (ElementAttribute)this.attrs.getObjects().elementAt(i);
            if ("class".equals(aAttr.attrId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void addClassSelect() {
        XMLNode attrNode = new XMLNode("attr");
        attrNode.setAttrValue("id", "class");
        attrNode.setAttrValue("name", "\u5b9e\u73b0\u7c7b");
        attrNode.setAttrValue("editorClass", "com.ecc.ide.emp.propertyeditor.ImplClassSelectEditor");
        ElementAttribute attr = new ElementAttribute(attrNode);
        ObjectCollection tempattrs = new ObjectCollection();
        tempattrs.add(attr);
        int i = 0;
        while (i < this.attrs.getObjects().size()) {
            ElementAttribute aAttr = (ElementAttribute)this.attrs.getObjects().elementAt(i);
            if (!attr.getAttrID().equals(aAttr.getAttrID())) {
                tempattrs.add(aAttr);
            }
            ++i;
        }
        this.attrs = tempattrs;
    }
}

