/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.AttrFormulaEditDialog;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementAttributeEditDialog;
import com.ecc.ide.editorprofile.Messages;
import com.ecc.ide.plugin.wizards.NewMCIActionComponentWizard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ElementAttributePanel
extends Composite {
    private Text descText;
    private Table attrListTable;
    private Combo attrTypeCombo;
    private Text editorClassText;
    private Text valueListText;
    private Text dftValueText;
    private Combo editableCombo;
    private Combo mustInputCombo;
    private Text attrNameText;
    private Text attrIDText;
    private Text enableFormulaText;
    private Text mustInputFormulaText;
    private boolean editable = false;
    private ArrayList attrList = new ArrayList();
    private Element element;
    private EditorProfile profile;
    Vector contentChangedListeners;
    XMLNode definedClassType;
    IProject project = null;
    private XMLNode functionNode;
    private EditorProfile functionProfile;

    public void setElement(Element element) {
        this.element = element;
        this.attrListTable.removeAll();
        this.setAttributes(element.getAttributes());
    }

    public void setAttributes(Vector attrs) {
        if (attrs == null || attrs.size() == 0) {
            this.clearAttribute();
            return;
        }
        int i = 0;
        while (i < attrs.size()) {
            ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
            TableItem item = new TableItem(this.attrListTable, 0);
            String[] itemTexts = new String[]{attr.getAttrID(), attr.getAttrName(), String.valueOf(attr.getMustSet()), String.valueOf(attr.getEditable()), attr.getAttrType(), attr.getAttrEditorClass(), attr.getDocument()};
            item.setText(itemTexts);
            item.setData((Object)attr);
            ++i;
        }
        this.attrListTable.setSelection(0);
        this.setActivateAttribute();
    }

    public ElementAttributePanel(Composite parent, int style, boolean editable) {
        super(parent, style);
        this.editable = editable;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        this.setLayout((Layout)gridLayout1);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ElementAttributePanel.Attributes_settings_1"));
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ElementAttributePanel.Attribute_ID__2"));
        this.attrIDText = new Text((Composite)this, 2048);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 200;
        this.attrIDText.setLayoutData((Object)gridData_1);
        this.attrIDText.setEditable(false);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("ElementAttributePanel.Attribute_Name__3"));
        this.attrNameText = new Text((Composite)this, 2048);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 250;
        this.attrNameText.setLayoutData((Object)gridData_7);
        this.attrNameText.setEditable(false);
        Label label_3 = new Label((Composite)this, 0);
        label_3.setText(Messages.getString("ElementAttributePanel.Must_Input__4"));
        this.mustInputCombo = new Combo((Composite)this, 0);
        this.mustInputCombo.add("true");
        this.mustInputCombo.add("false");
        this.mustInputCombo.setEnabled(false);
        Label label_4 = new Label((Composite)this, 0);
        label_4.setText(Messages.getString("ElementAttributePanel.Editable__7"));
        this.editableCombo = new Combo((Composite)this, 0);
        this.editableCombo.add("true");
        this.editableCombo.add("false");
        this.editableCombo.setEnabled(false);
        Label label_8 = new Label((Composite)this, 0);
        label_8.setText(Messages.getString("ElementAttributePanel.Attribute_Type__10"));
        this.attrTypeCombo = new Combo((Composite)this, 0);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 115;
        this.attrTypeCombo.setLayoutData((Object)gridData_8);
        this.attrTypeCombo.setEnabled(false);
        this.attrTypeCombo.add("");
        this.attrTypeCombo.add("boolean");
        this.attrTypeCombo.add("string");
        Label label_5 = new Label((Composite)this, 0);
        label_5.setText(Messages.getString("EditorProfileEditPanel.defaultValue"));
        this.dftValueText = new Text((Composite)this, 2048);
        GridData gridData_2 = new GridData(768);
        this.dftValueText.setLayoutData((Object)gridData_2);
        this.dftValueText.setEditable(false);
        Composite composite = new Composite((Composite)this, 0);
        GridData compositeGridData = new GridData(768);
        compositeGridData.horizontalSpan = 4;
        composite.setLayoutData((Object)compositeGridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 4;
        composite.setLayout((Layout)gridLayout2);
        Label label_6 = new Label(composite, 0);
        label_6.setText(Messages.getString("ElementAttributePanel.Value_List__15"));
        this.valueListText = new Text(composite, 2048);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 1;
        this.valueListText.setLayoutData((Object)gridData_3);
        this.valueListText.setEditable(false);
        Label label_7 = new Label(composite, 0);
        label_7.setText(Messages.getString("ElementAttributePanel.Edit_Class__17"));
        this.editorClassText = new Text(composite, 2048);
        GridData gridData_5 = new GridData(768);
        gridData_5.horizontalSpan = 1;
        this.editorClassText.setLayoutData((Object)gridData_5);
        this.editorClassText.setEditable(false);
        Label enableLabel = new Label(composite, 0);
        enableLabel.setText(Messages.getString("ElementAttrPanel.Enable_Formula"));
        this.enableFormulaText = new Text(composite, 2048);
        GridData enable_gridData = new GridData(768);
        enable_gridData.horizontalSpan = 1;
        this.enableFormulaText.setLayoutData((Object)enable_gridData);
        this.enableFormulaText.setEditable(false);
        Label mustInputLabel = new Label(composite, 0);
        mustInputLabel.setText(Messages.getString("ElementAttrPanel.MustInput_Formula"));
        this.mustInputFormulaText = new Text(composite, 2048);
        GridData mustInput_gridData = new GridData(768);
        mustInput_gridData.horizontalSpan = 1;
        this.mustInputFormulaText.setLayoutData((Object)mustInput_gridData);
        this.mustInputFormulaText.setEditable(false);
        Label label_9 = new Label((Composite)this, 0);
        GridData gridData_14 = new GridData();
        gridData_14.horizontalSpan = 4;
        label_9.setLayoutData((Object)gridData_14);
        label_9.setText(Messages.getString("ElementAttributePanel.Description__19"));
        this.descText = new Text((Composite)this, 2818);
        GridData gridData_15 = new GridData(768);
        gridData_15.heightHint = 25;
        gridData_15.horizontalSpan = 4;
        this.descText.setLayoutData((Object)gridData_15);
        this.descText.setEditable(false);
        if (editable) {
            Composite composite1 = new Composite((Composite)this, 0);
            GridData compositeGridData1 = new GridData(768);
            compositeGridData1.horizontalSpan = 4;
            composite1.setLayoutData((Object)compositeGridData1);
            GridLayout gridLayout3 = new GridLayout();
            gridLayout3.numColumns = 4;
            composite1.setLayout((Layout)gridLayout3);
            Button addButton = new Button(composite1, 0);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.createNewAttribute();
                }
            });
            GridData addButtonGridData = new GridData();
            addButtonGridData.widthHint = 63;
            addButton.setLayoutData((Object)addButtonGridData);
            addButton.setText(Messages.getString("EditorProfileEditPanel.createNew"));
            Button deleteButton = new Button(composite1, 0);
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.deleteCurrentAttribute();
                }
            });
            GridData deleteButtonGridData = new GridData();
            deleteButtonGridData.widthHint = 63;
            deleteButton.setLayoutData((Object)deleteButtonGridData);
            deleteButton.setText(Messages.getString("EditorProfileEditPanel.delete"));
            Button propertyButton = new Button(composite1, 0);
            propertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementAttributePanel.this.editCurrentAttribute();
                }
            });
            GridData propertyButtonGridData = new GridData();
            propertyButtonGridData.widthHint = 63;
            propertyButton.setLayoutData((Object)propertyButtonGridData);
            propertyButton.setText(Messages.getString("EditorProfileEditPanel.properties"));
        }
        this.attrListTable = new Table((Composite)this, 67584);
        this.attrListTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementAttributePanel.this.setActivateAttribute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ElementAttributePanel.this.editCurrentAttribute();
            }
        });
        GridData gridData_13 = new GridData(1808);
        gridData_13.horizontalSpan = 4;
        this.attrListTable.setLayoutData((Object)gridData_13);
        this.attrListTable.setLinesVisible(true);
        this.attrListTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.attrListTable, 0);
        tableColumn.setWidth(82);
        tableColumn.setText(Messages.getString("ElementAttributePanel.Attr_ID_23"));
        TableColumn tableColumn_1 = new TableColumn(this.attrListTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("ElementAttributePanel.Attr_Name_24"));
        TableColumn tableColumn_2 = new TableColumn(this.attrListTable, 0);
        tableColumn_2.setWidth(77);
        tableColumn_2.setText(Messages.getString("ElementAttributePanel.Must_Input_25"));
        TableColumn tableColumn_3 = new TableColumn(this.attrListTable, 0);
        tableColumn_3.setWidth(72);
        tableColumn_3.setText(Messages.getString("ElementAttributePanel.Editable_26"));
        TableColumn tableColumn_4 = new TableColumn(this.attrListTable, 0);
        tableColumn_4.setWidth(83);
        tableColumn_4.setText(Messages.getString("ElementAttributePanel.Attr_Type_27"));
        TableColumn tableColumn_5 = new TableColumn(this.attrListTable, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("ElementAttributePanel.editor_class_28"));
        TableColumn tableColumn_6 = new TableColumn(this.attrListTable, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(Messages.getString("ElementAttributePanel.Description_29"));
        if (!editable) {
            return;
        }
        Menu popupmenu = new Menu((Control)this.attrListTable);
        MenuItem menuItem = new MenuItem(popupmenu, 0);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementAttributePanel.this.createNewAttribute();
            }
        });
        menuItem.setText(Messages.getString("EditorProfileEditPanel.createNew"));
        MenuItem menuItem_1 = new MenuItem(popupmenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementAttributePanel.this.deleteCurrentAttribute();
            }
        });
        menuItem_1.setText(Messages.getString("EditorProfileEditPanel.delete"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_2 = new MenuItem(popupmenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementAttributePanel.this.editCurrentAttribute();
            }
        });
        menuItem_2.setText(Messages.getString("EditorProfileEditPanel.properties"));
        this.attrListTable.setMenu(popupmenu);
    }

    private void setItemAttribute(TableItem item, ElementAttribute attr) {
        String[] itemTexts = new String[]{attr.getAttrID(), attr.getAttrName(), String.valueOf(attr.getMustSet()), String.valueOf(attr.getEditable()), attr.getAttrType(), attr.getAttrEditorClass(), attr.getDocument()};
        item.setText(itemTexts);
    }

    private void createNewAttribute() {
        ElementAttribute attribute = new ElementAttribute();
        ElementAttributeEditDialog dlg = new ElementAttributeEditDialog(this.getShell(), 0);
        dlg.setEditorProfile(this.profile);
        dlg.setElement(this.element);
        dlg.setElementAttribute(attribute);
        dlg.setDefinedClassType(this.definedClassType);
        if (dlg.open() != null) {
            this.fireContentChangedEvent();
            this.element.addAttribute(attribute);
            TableItem item = new TableItem(this.attrListTable, 0);
            item.setData((Object)attribute);
            this.setItemAttribute(item, attribute);
            NewMCIActionComponentWizard.setAttrList(item);
        }
    }

    private void editCurrentAttribute() {
        if (!this.editable) {
            return;
        }
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        ElementAttribute attribute = (ElementAttribute)selects[0].getData();
        ElementAttributeEditDialog dlg = new ElementAttributeEditDialog(this.getShell(), 0);
        dlg.setEditorProfile(this.profile);
        dlg.setElement(this.element);
        dlg.setElementAttribute(attribute);
        dlg.setDefinedClassType(this.definedClassType);
        if (dlg.open() != null) {
            this.element.addAttribute(attribute);
            TableItem item = selects[0];
            this.setItemAttribute(item, attribute);
            this.setActivateAttribute();
            this.fireContentChangedEvent();
        }
    }

    private void deleteCurrentAttribute() {
        if (!this.editable) {
            return;
        }
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Be sure to delete...", (String)Messages.getString("EditorProfileEditPanel.sureToDeleteAttribute"))) {
            return;
        }
        ElementAttribute attr = (ElementAttribute)selects[0].getData();
        this.attrListTable.remove(this.attrListTable.indexOf(selects[0]));
        this.element.getAttributes().removeElement(attr);
        this.fireContentChangedEvent();
        if (this.attrListTable.getItemCount() != 0) {
            this.attrListTable.select(0);
            this.setActivateAttribute();
        } else {
            this.clearAttribute();
        }
    }

    private void setActivateAttribute() {
        TableItem[] selects = this.attrListTable.getSelection();
        if (selects.length != 1) {
            return;
        }
        ElementAttribute attr = (ElementAttribute)selects[0].getData();
        this.attrIDText.setText(attr.getAttrID());
        if (attr.getAttrName() != null) {
            this.attrNameText.setText(attr.getAttrName());
        } else {
            this.attrNameText.setText("");
        }
        if (attr.getMustSet()) {
            this.mustInputCombo.select(0);
        } else {
            this.mustInputCombo.select(1);
        }
        if (attr.getEditable()) {
            this.editableCombo.select(0);
        } else {
            this.editableCombo.select(1);
        }
        if (attr.getAttrType() != null) {
            this.attrTypeCombo.setText(attr.getAttrType());
        } else {
            this.attrTypeCombo.setText("");
        }
        if (attr.getDefaultValue() != null) {
            this.dftValueText.setText(attr.getDefaultValue());
        } else {
            this.dftValueText.setText("");
        }
        if (attr.getValueListStr() != null) {
            this.valueListText.setText(attr.getValueListStr());
        } else {
            this.valueListText.setText("");
        }
        if (attr.getMustInputFormula() != null) {
            this.mustInputFormulaText.setText(attr.getMustInputFormula());
        } else {
            this.mustInputFormulaText.setText("");
        }
        if (attr.getEnableFormula() != null) {
            this.enableFormulaText.setText(attr.getEnableFormula());
        } else {
            this.enableFormulaText.setText("");
        }
        if (attr.getAttrEditorClass() != null) {
            this.editorClassText.setText(attr.getAttrEditorClass());
        } else {
            this.editorClassText.setText("");
        }
        if (attr.getDocument() != null) {
            this.descText.setText(attr.getDocument());
        } else {
            this.descText.setText("");
        }
    }

    private void clearAttribute() {
        this.attrIDText.setText("");
        this.attrNameText.setText("");
        this.mustInputCombo.select(1);
        this.editableCombo.select(1);
        this.attrTypeCombo.select(0);
        this.dftValueText.setText("");
        this.valueListText.setText("");
        this.editorClassText.setText("");
        this.descText.setText("");
        this.mustInputFormulaText.setText("");
        this.enableFormulaText.setText("");
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void addContentChangedListener(ContentChangedListener listener) {
        if (this.contentChangedListeners == null) {
            this.contentChangedListeners = new Vector(10);
        }
        this.contentChangedListeners.addElement(listener);
    }

    public void fireContentChangedEvent() {
        if (this.contentChangedListeners == null) {
            return;
        }
        ContentChangedEvent event = new ContentChangedEvent(this.element.getEditorProfile(), null, 0);
        int i = 0;
        while (i < this.contentChangedListeners.size()) {
            ContentChangedListener listener = (ContentChangedListener)this.contentChangedListeners.elementAt(i);
            listener.contentChanged(event);
            ++i;
        }
    }

    private String editFormula(String formulaStr) {
        AttrFormulaEditDialog dialog = new AttrFormulaEditDialog(this.getShell());
        dialog.setAttributeDefine(this.element.getAttributes());
        dialog.setFormulaStr(formulaStr);
        dialog.setFunctionProfile(this.functionProfile);
        dialog.setFunctionXMLNode(this.functionNode);
        return (String)dialog.open();
    }

    public void setDefinedClassType(XMLNode node) {
        this.definedClassType = node;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.functionProfile = profile;
    }

    public void setFunctionXMLNode(XMLNode node) {
        this.functionNode = node;
    }

    public void setEditable(boolean value) {
        this.editable = value;
    }

    public void setAttrList(TableItem tableItem) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", tableItem.getText(0));
        map.put("name", tableItem.getText(1));
        map.put("mustSet", tableItem.getText(2));
        map.put("editable", tableItem.getText(3));
        map.put("attrType", tableItem.getText(4));
        map.put("editorClass", tableItem.getText(5));
        map.put("desc", tableItem.getText(6));
        this.attrList.add(map);
    }

    public ArrayList getAttrList() {
        return this.attrList;
    }
}

