/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ProfileObject;
import com.ecc.util.xmlloader.Externalizable;
import java.util.Vector;
import org.w3c.dom.Node;

public class ElementCatalog
extends ProfileObject
implements Externalizable {
    EditorProfile profile;
    private String catalogName;
    private String label;
    private Vector elements = new Vector(10);
    private boolean showInToolPanel = true;
    private boolean isBuildIn = false;

    public Externalizable initializeFrom(Node node) {
        String buildInStr;
        this.catalogName = this.getAttributeValue("id", node);
        this.label = this.getAttributeValue("name", node);
        String showStr = this.getAttributeValue("showInToolPanel", node);
        if (showStr != null && "false".equals(showStr)) {
            this.showInToolPanel = false;
        }
        if ("true".equals(buildInStr = this.getAttributeValue("isBuildIn", node))) {
            this.isBuildIn = true;
        }
        return this;
    }

    public void add(Externalizable obj) {
        this.elements.addElement(obj);
        ((Element)obj).profile = this.profile;
    }

    public Vector getElements() {
        return this.elements;
    }

    public Element getElement(String elementId) {
        if (elementId == null) {
            return null;
        }
        int i = 0;
        while (i < this.elements.size()) {
            Element aElement = (Element)this.elements.elementAt(i);
            if (aElement.getElementName().equals(elementId)) {
                return aElement;
            }
            ++i;
        }
        return null;
    }

    public Element getElement2(String elementId) {
        if (elementId == null) {
            return null;
        }
        int i = 0;
        if (i < this.elements.size()) {
            Element aElement = (Element)this.elements.elementAt(i);
            return aElement;
        }
        return null;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String name) {
        this.catalogName = name;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.catalogName;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public boolean getIsBuildIn() {
        return this.isBuildIn;
    }

    public void toXMLString(StringBuffer strBuf) {
        strBuf.append("\t<elementCatalog id=\"");
        strBuf.append(this.catalogName);
        if (this.label != null && this.label.length() > 0) {
            strBuf.append("\" name=\"" + this.label);
        }
        if (this.isBuildIn) {
            strBuf.append("\" isBuildIn=\"true");
        }
        if (!this.showInToolPanel) {
            strBuf.append("\" showInToolPanel=\"false\">\r\n");
        } else {
            strBuf.append("\">\r\n");
        }
        int i = 0;
        while (i < this.elements.size()) {
            ProfileObject po = (ProfileObject)this.elements.elementAt(i);
            po.toXMLString(strBuf);
            ++i;
        }
        strBuf.append("\t</elementCatalog>\r\n");
    }

    public void addElement(Element element) {
        this.elements.addElement(element);
    }

    public void deleteElement(Element element) {
        this.elements.removeElement(element);
    }

    public boolean getShowInToolPanel() {
        return this.showInToolPanel;
    }

    public void setShowInToolPanel(boolean value) {
        this.showInToolPanel = value;
    }

    public Object clone() {
        ElementCatalog catalog = new ElementCatalog();
        catalog.profile = this.profile;
        catalog.catalogName = this.catalogName;
        catalog.label = this.label;
        catalog.elements = new Vector(10);
        catalog.showInToolPanel = this.showInToolPanel;
        int i = 0;
        while (i < this.elements.size()) {
            Element element = (Element)this.elements.elementAt(i);
            catalog.elements.addElement(element.clone());
            ++i;
        }
        return catalog;
    }
}

