/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.EditorProfileEditPanel;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ElementCatalogPropertyPanel
extends Composite {
    private Text catalogIdText;
    private Text catalogNameText;
    final Button showInToopPanelButton;
    private ElementCatalog catalog;
    private EditorProfile profile;
    public EditorProfileEditPanel profileEditor;

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }

    public void setElementCatalog(ElementCatalog catalog) {
        this.catalog = catalog;
        if (catalog.getLabel() != null) {
            this.catalogNameText.setText(catalog.getLabel());
        }
        if (catalog.getCatalogName() != null) {
            this.catalogIdText.setText(catalog.getCatalogName());
        }
        this.showInToopPanelButton.setSelection(catalog.getShowInToolPanel());
    }

    public boolean updateCatalog() {
        if (this.catalogIdText.getText().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Error", (String)Messages.getString("EditorProfileEditPanel.properCatalogId"));
            return false;
        }
        String catalogId = this.catalogIdText.getText();
        ElementCatalog aCatalog = this.profile.getElementCatalog(catalogId);
        if (aCatalog != null && aCatalog != this.catalog) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Error", (String)Messages.getString("EditorProfileEditPanel.duplicatedCatalogId"));
            return false;
        }
        this.catalog.setCatalogName(this.catalogIdText.getText());
        if (this.catalogNameText.getText().length() > 0) {
            this.catalog.setLabel(this.catalogNameText.getText());
        } else {
            this.catalog.setLabel(null);
        }
        this.catalog.setShowInToolPanel(this.showInToopPanelButton.getSelection());
        return true;
    }

    public ElementCatalogPropertyPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        CLabel label = new CLabel((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ElementCatalogPropertyPanel.Element_Catalog_Properties_1"));
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("ElementCatalogPropertyPanel.CatalogId__2"));
        this.catalogIdText = new Text((Composite)this, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 201;
        gridData_2.horizontalSpan = 3;
        this.catalogIdText.setLayoutData((Object)gridData_2);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ElementCatalogPropertyPanel.CatalogName__3"));
        this.catalogNameText = new Text((Composite)this, 2048);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 282;
        gridData_1.horizontalSpan = 3;
        this.catalogNameText.setLayoutData((Object)gridData_1);
        Label label_3 = new Label((Composite)this, 0);
        this.showInToopPanelButton = new Button((Composite)this, 32);
        GridData gridData_3 = new GridData();
        gridData_3.horizontalSpan = 3;
        this.showInToopPanelButton.setLayoutData((Object)gridData_3);
        this.showInToopPanelButton.setSelection(true);
        this.showInToopPanelButton.setText(Messages.getString("ElementCatalogPropertyPanel.Show_on_tool_panel_4"));
    }

    public void setEditable(boolean value) {
        this.catalogIdText.setEditable(value);
        this.catalogNameText.setEditable(value);
        this.showInToopPanelButton.setEnabled(value);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }
}

