/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.Messages;
import com.zmc.base.algorithm.QSortAlgorithm;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ElementChildPanel
extends Composite {
    private Table childTable;
    private Text documentText;
    private Combo allowCountCombo;
    private Combo childIdCombo;
    private boolean editable = false;
    private Element element;
    private EditorProfile profile;
    Vector contentChangedListeners;

    public ElementChildPanel(Composite parent, int style, boolean editable) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("ElementChildPanel.ChildId__1"));
        this.childIdCombo = new Combo((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 217;
        this.childIdCombo.setLayoutData((Object)gridData);
        this.childIdCombo.setEnabled(editable);
        Label label_1 = new Label((Composite)this, 0);
        label_1.setText(Messages.getString("ElementChildPanel.AllowCount__2"));
        this.allowCountCombo = new Combo((Composite)this, 0);
        this.allowCountCombo.setItems(new String[]{"1", "*"});
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 48;
        this.allowCountCombo.setLayoutData((Object)gridData_7);
        this.allowCountCombo.setEnabled(editable);
        Label label_2 = new Label((Composite)this, 0);
        label_2.setText(Messages.getString("ElementChildPanel.Document__5"));
        this.documentText = new Text((Composite)this, 2818);
        GridData gridData_1 = new GridData(768);
        gridData_1.heightHint = 61;
        gridData_1.horizontalSpan = 4;
        this.documentText.setLayoutData((Object)gridData_1);
        this.documentText.setEditable(editable);
        Composite composite = new Composite((Composite)this, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 4;
        composite.setLayoutData((Object)gridData_2);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementChildPanel.this.addChild();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 80;
        button.setLayoutData((Object)gridData_3);
        button.setText(Messages.getString("ElementChildPanel.Add_6"));
        button.setEnabled(editable);
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementChildPanel.this.deleteChild();
            }
        });
        GridData gridData_4 = new GridData();
        gridData_4.widthHint = 80;
        button_1.setLayoutData((Object)gridData_4);
        button_1.setText(Messages.getString("ElementChildPanel.Delete_7"));
        button_1.setEnabled(editable);
        this.childTable = new Table((Composite)this, 67584);
        this.childTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementChildPanel.this.setActivateChildItem();
            }
        });
        GridData gridData_6 = new GridData(1808);
        gridData_6.horizontalSpan = 4;
        this.childTable.setLayoutData((Object)gridData_6);
        this.childTable.setLinesVisible(true);
        this.childTable.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.childTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("ElementChildPanel.ChildId_8"));
        TableColumn tableColumn_1 = new TableColumn(this.childTable, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("ElementChildPanel.allowCount_9"));
        TableColumn tableColumn_2 = new TableColumn(this.childTable, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("ElementChildPanel.Document_10"));
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
        this.loadProfileElements();
    }

    public void refresh() {
        this.loadProfileElements();
    }

    private void loadProfileElements() {
        this.childIdCombo.removeAll();
        int count = this.profile.getElementCount();
        String[] elementNames = new String[count];
        Vector catalogs = this.profile.getCagalogs();
        if (catalogs == null) {
            return;
        }
        int idx = 0;
        int i = 0;
        while (i < catalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
            if (catalog.getElements() != null) {
                int k = 0;
                while (k < catalog.getElements().size()) {
                    Element element = (Element)catalog.getElements().elementAt(k);
                    elementNames[idx++] = element.getElementName();
                    ++k;
                }
            }
            ++i;
        }
        QSortAlgorithm sorter = new QSortAlgorithm();
        try {
            sorter.sort(elementNames, true, true);
            this.childIdCombo.setItems(elementNames);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setElement(Element element) {
        this.element = element;
        this.childTable.removeAll();
        Vector childs = element.getChilds();
        if (childs != null) {
            int i = 0;
            while (i < childs.size()) {
                ElementChild child = (ElementChild)childs.elementAt(i);
                String[] childValues = new String[]{child.childElementId, child.allowCount, child.document};
                if (child.document == null) {
                    childValues[2] = "";
                }
                TableItem tableItem = new TableItem(this.childTable, 0);
                Element el = this.profile.getElement(child.childElementId);
                if (el != null) {
                    tableItem.setImage(el.getImage());
                }
                tableItem.setText(childValues);
                tableItem.setData((Object)child);
                ++i;
            }
        }
    }

    private void setActivateChildItem() {
        TableItem[] items = this.childTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ElementChild child = (ElementChild)items[0].getData();
        this.childIdCombo.setText(child.getChildElementId());
        this.allowCountCombo.setText(child.getAlowCount());
        if (child.document != null) {
            this.documentText.setText(child.document);
        } else {
            this.documentText.setText("");
        }
    }

    private void deleteChild() {
        TableItem[] items = this.childTable.getSelection();
        if (items.length != 1) {
            return;
        }
        ElementChild child = (ElementChild)items[0].getData();
        this.childTable.remove(this.childTable.indexOf(items[0]));
        this.element.getChilds().removeElement(child);
        this.fireContentChangedEvent();
    }

    private void addChild() {
        String childId = this.childIdCombo.getText();
        if (childId == null || childId.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ElementChildPanel.Warning_1"), (String)Messages.getString("ElementChildPanel.Please_Select_a_child_to_add_!_2"));
            return;
        }
        String allowCount = this.allowCountCombo.getText();
        if (allowCount == null || allowCount.length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ElementChildPanel.Warning_3"), (String)Messages.getString("ElementChildPanel.Please_specify_the_allow_count_!_4"));
            return;
        }
        if (this.element.getChilds() != null) {
            int i = 0;
            while (i < this.element.getChilds().size()) {
                ElementChild child = (ElementChild)this.element.getChilds().elementAt(i);
                if (childId.equals(child.getChildElementId())) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ElementChildPanel.Warning_5"), (String)Messages.getString("ElementChildPanel.This_child_still_exist_int_the_allowed_child_list_!_6"));
                    return;
                }
                ++i;
            }
        }
        TableItem item = new TableItem(this.childTable, 0);
        item.setText(childId);
        item.setText(1, allowCount);
        item.setText(2, this.documentText.getText());
        Element element = this.profile.getElement(childId);
        if (element != null) {
            item.setImage(element.getImage());
        }
        ElementChild newChild = new ElementChild();
        newChild.allowCount = allowCount;
        newChild.childElementId = childId;
        newChild.document = this.documentText.getText();
        this.element.addChild(newChild);
        item.setData((Object)newChild);
        this.fireContentChangedEvent();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void addContentChangedListener(ContentChangedListener listener) {
        if (this.contentChangedListeners == null) {
            this.contentChangedListeners = new Vector(10);
        }
        this.contentChangedListeners.addElement(listener);
    }

    public void fireContentChangedEvent() {
        if (this.contentChangedListeners == null) {
            return;
        }
        ContentChangedEvent event = new ContentChangedEvent(this.element.getEditorProfile(), null, 0);
        int i = 0;
        while (i < this.contentChangedListeners.size()) {
            ContentChangedListener listener = (ContentChangedListener)this.contentChangedListeners.elementAt(i);
            listener.contentChanged(event);
            ++i;
        }
    }
}

