/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.DefinedClassSelectDialog;
import com.ecc.ide.editor.SearchClass;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttributePanel;
import com.ecc.ide.editorprofile.ElementChildPanel;
import com.ecc.ide.editorprofile.Messages;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ElementPropertyPanel
extends Composite {
    private Text editClassText;
    private Text wizardClassText;
    private Combo visualTypeCombo;
    private Text elementIdText;
    private Text visualClassText;
    private Text descriptionText;
    private Text iconNameText;
    private Text classTypeText;
    private Text elementNameText;
    private ElementAttributePanel elementAttributePanel;
    final ElementChildPanel elementChildPanel;
    private Element element;
    private EditorProfile profile;
    private boolean editable = false;
    Vector contentChangedListeners;
    XMLNode definedClassType;
    IProject project = null;
    private XMLNode functionNode;
    private EditorProfile functionProfile;

    public ElementPropertyPanel(Composite parent, int style, boolean editable) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(Messages.getString("ElementPropertyPanel.properties_1"));
        Composite elementPropertyPanel = new Composite((Composite)tabFolder, 0);
        tabItem1.setControl((Control)elementPropertyPanel);
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 371;
        elementPropertyPanel.setLayoutData((Object)gridData_7);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        elementPropertyPanel.setLayout((Layout)gridLayout);
        elementPropertyPanel.setSize(500, 700);
        CLabel label = new CLabel(elementPropertyPanel, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ElementPropertyPanel.Element_Properties_2"));
        Label label_8 = new Label(elementPropertyPanel, 0);
        label_8.setText(Messages.getString("ElementPropertyPanel.ElementID__3"));
        this.elementIdText = new Text(elementPropertyPanel, 2048);
        this.elementIdText.setEditable(editable);
        GridData gridData_16 = new GridData();
        gridData_16.widthHint = 162;
        gridData_16.horizontalSpan = 2;
        this.elementIdText.setLayoutData((Object)gridData_16);
        Label label_1 = new Label(elementPropertyPanel, 0);
        label_1.setText(Messages.getString("ElementPropertyPanel.Element_Name__4"));
        this.elementNameText = new Text(elementPropertyPanel, 2048);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 2;
        this.elementNameText.setLayoutData((Object)gridData_1);
        this.elementNameText.setEditable(editable);
        Label label_2 = new Label(elementPropertyPanel, 0);
        label_2.setText(Messages.getString("ElementPropertyPanel.implement_Class__5"));
        this.classTypeText = new Text(elementPropertyPanel, 2048);
        this.classTypeText.setLayoutData((Object)new GridData(768));
        this.classTypeText.setEditable(editable);
        Button classBrButton = new Button(elementPropertyPanel, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 37;
        classBrButton.setLayoutData((Object)gridData_2);
        classBrButton.setText(Messages.getString("ElementPropertyPanel.>>_6"));
        classBrButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = SearchClass.selectClass(ElementPropertyPanel.this.getShell());
                if (result != null) {
                    ElementPropertyPanel.this.classTypeText.setText(result);
                }
            }
        });
        classBrButton.setEnabled(editable);
        Label label_3 = new Label(elementPropertyPanel, 0);
        label_3.setText(Messages.getString("ElementPropertyPanel.Icon_Name__7"));
        this.iconNameText = new Text(elementPropertyPanel, 2048);
        this.iconNameText.setLayoutData((Object)new GridData(768));
        this.iconNameText.setEditable(editable);
        Button iconBrButton = new Button(elementPropertyPanel, 0);
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 35;
        iconBrButton.setLayoutData((Object)gridData_3);
        iconBrButton.setText(Messages.getString("ElementPropertyPanel.>>_8"));
        iconBrButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementPropertyPanel.this.setIconName();
            }
        });
        iconBrButton.setEnabled(editable);
        Label label_9 = new Label(elementPropertyPanel, 0);
        label_9.setText(Messages.getString("ElementPropertyPanel.VisualType__9"));
        this.visualTypeCombo = new Combo(elementPropertyPanel, 0);
        this.visualTypeCombo.setItems(new String[]{"Label", "TextField", "PasswordField", "Icon", "decision", "optional", "end"});
        GridData gridData_19 = new GridData();
        gridData_19.widthHint = 134;
        gridData_19.horizontalSpan = 2;
        this.visualTypeCombo.setLayoutData((Object)gridData_19);
        this.visualTypeCombo.setEnabled(editable);
        Label label_7 = new Label(elementPropertyPanel, 0);
        label_7.setText(Messages.getString("ElementPropertyPanel.Visual_Class__14"));
        this.visualClassText = new Text(elementPropertyPanel, 2048);
        this.visualClassText.setLayoutData((Object)new GridData(768));
        this.visualClassText.setEditable(editable);
        Button button = new Button(elementPropertyPanel, 0);
        GridData gridData_15 = new GridData();
        gridData_15.widthHint = 37;
        button.setLayoutData((Object)gridData_15);
        button.setText(Messages.getString("ElementPropertyPanel.>>_15"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefinedClassSelectDialog dlg = new DefinedClassSelectDialog(ElementPropertyPanel.this.getShell());
                dlg.setDefinedClassType(ElementPropertyPanel.this.definedClassType);
                String result = dlg.open("visualize");
                if (result != null) {
                    ElementPropertyPanel.this.visualClassText.setText(result);
                }
            }
        });
        button.setEnabled(editable);
        Label label_4 = new Label(elementPropertyPanel, 0);
        label_4.setText(Messages.getString("ElementPropertyPanel.New_Wizard_Class__16"));
        this.wizardClassText = new Text(elementPropertyPanel, 2048);
        this.wizardClassText.setLayoutData((Object)new GridData(768));
        this.wizardClassText.setEditable(editable);
        Button button_2 = new Button(elementPropertyPanel, 0);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 36;
        button_2.setLayoutData((Object)gridData_8);
        button_2.setText(Messages.getString("ElementPropertyPanel.>>_17"));
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = SearchClass.selectClass(ElementPropertyPanel.this.getShell());
                if (result != null) {
                    ElementPropertyPanel.this.wizardClassText.setText(result);
                }
            }
        });
        button_2.setEnabled(editable);
        Label label_6 = new Label(elementPropertyPanel, 0);
        label_6.setText(Messages.getString("ElementPropertyPanel.EditClass__1"));
        this.editClassText = new Text(elementPropertyPanel, 2048);
        this.editClassText.setLayoutData((Object)new GridData(768));
        this.editClassText.setEditable(editable);
        Button button_1 = new Button(elementPropertyPanel, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = SearchClass.selectClass(ElementPropertyPanel.this.getShell());
                if (result != null) {
                    ElementPropertyPanel.this.editClassText.setText(result);
                }
            }
        });
        GridData gridData_9 = new GridData();
        gridData_9.widthHint = 36;
        button_1.setLayoutData((Object)gridData_9);
        button_1.setText(">>");
        button_1.setEnabled(editable);
        Label label_5 = new Label(elementPropertyPanel, 0);
        label_5.setText(Messages.getString("ElementPropertyPanel.Document__18"));
        this.descriptionText = new Text(elementPropertyPanel, 2818);
        GridData gridData_4 = new GridData(1808);
        gridData_4.horizontalSpan = 3;
        this.descriptionText.setLayoutData((Object)gridData_4);
        this.descriptionText.setEditable(editable);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.getString("ElementPropertyPanel.Attributes_21"));
        this.elementAttributePanel = new ElementAttributePanel((Composite)tabFolder, 0, editable);
        tabItem2.setControl((Control)this.elementAttributePanel);
        this.elementAttributePanel.setDefinedClassType(this.definedClassType);
        this.elementAttributePanel.setFunctionProfile(this.functionProfile);
        this.elementAttributePanel.setFunctionXMLNode(this.functionNode);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.getString("ElementPropertyPanel.Child_Elements_22"));
        this.elementChildPanel = new ElementChildPanel((Composite)tabFolder, 0, editable);
        tabItem3.setControl((Control)this.elementChildPanel);
    }

    public void setElement(Element element) {
        this.element = element;
        String root = this.profile.getRootElementName();
        int type = 0;
        if ("flow".equals(root)) {
            type = 1;
        }
        if ("Services".equals(root)) {
            type = 2;
        }
        String actionDefaultIcon = "/images/newElement.gif";
        String serviceDefaultIcon = "/images/tabOrder.gif";
        String defaultWrapperClass = "com.ecc.ide.editor.visualflow.ActionElementWrapper";
        if (element.getElementName() != null) {
            this.elementIdText.setText(element.getElementName());
        }
        if (element.getLabel() != null) {
            this.elementNameText.setText(element.getLabel());
        } else {
            this.elementNameText.setText("");
        }
        if (element.getImplClass() != null) {
            this.classTypeText.setText(element.getImplClass());
        } else {
            this.classTypeText.setText("");
        }
        if (element.getIconName() != null) {
            this.iconNameText.setText(element.getIconName());
        } else if (type == 1) {
            this.iconNameText.setText(actionDefaultIcon);
        } else if (type == 2) {
            this.iconNameText.setText(serviceDefaultIcon);
        } else {
            this.iconNameText.setText("");
        }
        if (element.getWrapperClassType() != null) {
            this.visualClassText.setText(element.getWrapperClassType());
        } else if (type == 1) {
            this.visualClassText.setText(defaultWrapperClass);
        } else {
            this.visualClassText.setText("");
        }
        if (element.getVisualType() != null) {
            this.visualTypeCombo.setText(element.getVisualType());
        } else {
            this.visualTypeCombo.setText("");
        }
        if (element.getWizardClassType() != null) {
            this.wizardClassText.setText(element.getWizardClassType());
        } else {
            this.wizardClassText.setText("");
        }
        if (element.getDocument() != null) {
            this.descriptionText.setText(element.getDocument());
        } else {
            this.descriptionText.setText("");
        }
        if (element.getEditClass() != null) {
            this.editClassText.setText(element.getEditClass());
        } else {
            this.editClassText.setText("");
        }
        this.elementAttributePanel.setElement(element);
        this.elementChildPanel.setEditorProfile(this.profile);
        this.elementChildPanel.setElement(element);
    }

    public boolean updateElement() {
        if (this.elementIdText.getText().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ElementPropertyPanel.Warning_1"), (String)Messages.getString("ElementPropertyPanel.Please_Input_proper_element_ID_!_2"));
            return false;
        }
        Element anElement = this.profile.getElement(this.elementIdText.getText());
        if (anElement != null && anElement != this.element) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.getString("ElementPropertyPanel.Warning_3"), (String)Messages.getString("ElementPropertyPanel.Duplicated_element_ID_!_4"));
            return false;
        }
        this.element.setElementName(this.elementIdText.getText());
        if (this.elementNameText.getText().length() != 0) {
            this.element.setLabel(this.elementNameText.getText());
        } else {
            this.element.setLabel(null);
        }
        if (this.classTypeText.getText().length() != 0) {
            this.element.setImplClass(this.classTypeText.getText());
        } else {
            this.element.setImplClass(null);
        }
        if (this.iconNameText.getText().length() != 0) {
            this.element.setIconName(this.iconNameText.getText());
        } else {
            this.element.setIconName(null);
        }
        if (this.visualClassText.getText().length() != 0) {
            this.element.setWrapperClassType(this.visualClassText.getText());
        } else {
            this.element.setWrapperClassType(null);
        }
        if (this.visualTypeCombo.getText().length() != 0) {
            this.element.setVisualType(this.visualTypeCombo.getText());
        } else {
            this.element.setVisualType(null);
        }
        if (this.wizardClassText.getText().length() != 0) {
            this.element.setWizardClassType(this.wizardClassText.getText());
        } else {
            this.element.setWizardClassType(null);
        }
        if (this.descriptionText.getText().length() != 0) {
            this.element.setDocument(this.descriptionText.getText());
        } else {
            this.element.setDocument(null);
        }
        this.element.setEditClass(this.editClassText.getText());
        return true;
    }

    private void deleteCurrentElement() {
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void setIconName() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.gif;*.jpg;"});
        String rootPath = this.profile.getProjectRootPath();
        if (rootPath != null) {
            dialog.setFilterPath(String.valueOf(rootPath) + "/icons");
        }
        if ((result = dialog.open()) != null) {
            String fileName = dialog.getFileName().replace('\\', '/');
            int idx = fileName.lastIndexOf(47);
            this.iconNameText.setText(fileName.substring(idx + 1));
        }
    }

    public void addContentChangedListener(ContentChangedListener listener) {
        this.elementAttributePanel.addContentChangedListener(listener);
        this.elementChildPanel.addContentChangedListener(listener);
        if (this.contentChangedListeners == null) {
            this.contentChangedListeners = new Vector(10);
        }
        this.contentChangedListeners.addElement(listener);
    }

    public void fireContentChangedEvent() {
        if (this.contentChangedListeners == null) {
            return;
        }
        ContentChangedEvent event = new ContentChangedEvent(this.element.getEditorProfile(), null, 0);
        int i = 0;
        while (i < this.contentChangedListeners.size()) {
            ContentChangedListener listener = (ContentChangedListener)this.contentChangedListeners.elementAt(i);
            listener.contentChanged(event);
            ++i;
        }
    }

    public void setDefinedClassType(XMLNode node) {
        this.definedClassType = node;
        this.elementAttributePanel.setDefinedClassType(node);
    }

    public void setProject(IProject project) {
        this.project = project;
        this.elementAttributePanel.setProject(project);
    }

    public void setFunctionProfile(EditorProfile profile) {
        this.functionProfile = profile;
    }

    public void setFunctionXMLNode(XMLNode node) {
        this.functionNode = node;
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
    }
}

