/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editorprofile.EditorProfileEditPanel;
import com.ecc.ide.editorprofile.Messages;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ProfileEditor {
    String fileName = null;
    Shell shell;
    EditorProfileEditPanel editor = null;
    String newFileSrc = "<?xml version = \"1.0\" encoding = \"UTF-8\" ?>\r\n<EditorProfile >\r\n</EditorProfile>";

    public ProfileEditor(String fileName) {
        this.fileName = fileName;
        Display display = new Display();
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new FillLayout());
        Menu menubar = new Menu((Decorations)this.shell, 2);
        MenuItem menuItem = new MenuItem(menubar, 64);
        menuItem.setText(Messages.getString("ProfileEditor.File_1"));
        Menu popupmenu = new Menu(menuItem);
        menuItem.setMenu(popupmenu);
        MenuItem menuItem_1 = new MenuItem(popupmenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileEditor.this.newFile();
            }
        });
        menuItem_1.setText(Messages.getString("ProfileEditor.New_2"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_2 = new MenuItem(popupmenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileEditor.this.openFile();
            }
        });
        menuItem_2.setText(Messages.getString("ProfileEditor.Open_3"));
        MenuItem menuItem_3 = new MenuItem(popupmenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileEditor.this.saveFile();
            }
        });
        menuItem_3.setText(Messages.getString("ProfileEditor.Save_4"));
        MenuItem menuItem_4 = new MenuItem(popupmenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileEditor.this.saveAs();
            }
        });
        menuItem_4.setText(Messages.getString("ProfileEditor.Save_As_5"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_5 = new MenuItem(popupmenu, 0);
        menuItem_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileEditor.this.shell.dispose();
            }
        });
        menuItem_5.setText(Messages.getString("ProfileEditor.Exit_6"));
        MenuItem menuItem_6 = new MenuItem(menubar, 64);
        menuItem_6.setText(Messages.getString("ProfileEditor.Help_7"));
        Menu popupmenu_1 = new Menu(menuItem_6);
        menuItem_6.setMenu(popupmenu_1);
        MenuItem menuItem_7 = new MenuItem(popupmenu_1, 0);
        menuItem_7.setText(Messages.getString("ProfileEditor.Content_8"));
        new MenuItem(popupmenu_1, 2);
        MenuItem menuItem_8 = new MenuItem(popupmenu_1, 0);
        menuItem_8.setText(Messages.getString("ProfileEditor.About_9"));
        this.shell.setMenuBar(menubar);
        this.editor = new EditorProfileEditPanel((Composite)this.shell, 2048);
        if (fileName != null) {
            this.editor.openProfileFile(fileName);
        } else {
            this.newFile();
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void main(String[] argv) {
        String profileName = null;
        Object fileName = null;
        boolean showRuller = false;
        if (argv.length == 1) {
            profileName = argv[0];
            ProfileEditor editor = new ProfileEditor(argv[0]);
        } else {
            ProfileEditor profileEditor = new ProfileEditor(null);
        }
    }

    private void openFile() {
        try {
            FileDialog fileDlg = new FileDialog(this.shell);
            String afileName = fileDlg.open();
            if (afileName == null) {
                return;
            }
            this.fileName = afileName;
            this.shell.setText(this.fileName);
            this.shell.setText(this.fileName);
            this.editor.openProfileFile(afileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveFile() {
        if (this.fileName != null) {
            try {
                FileWriter fw = new FileWriter(this.fileName);
                fw.write(this.editor.getXMLStringContent());
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.saveAs();
        }
    }

    private void saveAs() {
        FileDialog fileDlg = new FileDialog(this.shell);
        String afileName = fileDlg.open();
        if (afileName == null) {
            return;
        }
        this.fileName = afileName;
        this.shell.setText(this.fileName);
        if (this.fileName != null) {
            this.saveFile();
        }
    }

    private void newFile() {
        this.fileName = null;
        this.shell.setText(Messages.getString("ProfileEditor.ProfileEditor.9_10"));
        try {
            this.editor.loadXMLContent(new ByteArrayInputStream(this.newFileSrc.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

