/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.editorprofile;

import com.ecc.ide.editorprofile.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ValueListEditorDialog
extends Dialog {
    private Shell shell;
    private Text valueText;
    private Label textLabel;
    private Text textText;
    private Table itemList;
    private String result = null;
    private TableColumn column2;
    private boolean withValueDesc;

    public ValueListEditorDialog(Shell parent, int style) {
        super(parent, style);
    }

    public String open(String valueListStr) {
        if (valueListStr == null) {
            valueListStr = "";
        }
        if (valueListStr.indexOf(61) != -1) {
            this.withValueDesc = true;
        }
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setText(Messages.getString("ValueListEditorDialog.Value_list_editor_2"));
        Composite composite = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText(Messages.getString("ValueListEditorDialog.Value__3"));
        this.valueText = new Text(composite, 2048);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 100;
        this.valueText.setLayoutData((Object)gridData_8);
        final Button button_2 = new Button(composite, 32);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditorDialog.this.withValueDesc = button_2.getSelection();
                if (ValueListEditorDialog.this.withValueDesc) {
                    ValueListEditorDialog.this.column2 = new TableColumn(ValueListEditorDialog.this.itemList, 18432);
                    ValueListEditorDialog.this.column2.setText(Messages.getString("ValueListEditorDialog.text_9"));
                    ValueListEditorDialog.this.column2.setWidth(262);
                    ValueListEditorDialog.this.textLabel.setVisible(true);
                    ValueListEditorDialog.this.textText.setVisible(true);
                } else {
                    ValueListEditorDialog.this.column2.dispose();
                    ValueListEditorDialog.this.textLabel.setVisible(false);
                    ValueListEditorDialog.this.textText.setVisible(false);
                }
            }
        });
        GridData gridData_9 = new GridData();
        gridData_9.horizontalSpan = 2;
        button_2.setLayoutData((Object)gridData_9);
        button_2.setText(Messages.getString("ValueListEditorDialog.With_Value_Description_2"));
        if (this.withValueDesc) {
            button_2.setSelection(true);
        } else {
            button_2.setSelection(false);
        }
        this.textLabel = new Label(composite, 0);
        this.textLabel.setText(Messages.getString("ValueListEditorDialog.Text__4"));
        this.textText = new Text(composite, 2048);
        this.textText.setLayoutData((Object)new GridData(768));
        if (this.withValueDesc) {
            this.textLabel.setVisible(true);
            this.textText.setVisible(true);
        } else {
            this.textLabel.setVisible(false);
            this.textText.setVisible(false);
        }
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_4 = new GridData(640);
        gridData_4.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData_4);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button addButton = new Button(composite_2, 0);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 90;
        addButton.setLayoutData((Object)gridData_5);
        addButton.setText(Messages.getString("ValueListEditorDialog.add_5"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditorDialog.this.addNewValue();
            }
        });
        Button delButton = new Button(composite_2, 0);
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 90;
        delButton.setLayoutData((Object)gridData_6);
        delButton.setText(Messages.getString("ValueListEditorDialog.delete_6"));
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TableItem item = ValueListEditorDialog.this.itemList.getSelection()[0];
                    item.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditorDialog.this.updateItemValue();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 90;
        button.setLayoutData((Object)gridData_7);
        button.setText(Messages.getString("ValueListEditorDialog.Update_7"));
        this.itemList = new Table(composite, 67584);
        this.itemList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditorDialog.this.setActiveItem();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.itemList.setLayoutData((Object)gridData);
        this.itemList.setHeaderVisible(true);
        this.itemList.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.itemList, 18432);
        column1.setText(Messages.getString("ValueListEditorDialog.value_8"));
        column1.setWidth(134);
        if (this.withValueDesc) {
            this.column2 = new TableColumn(this.itemList, 18432);
            this.column2.setText(Messages.getString("ValueListEditorDialog.text_9"));
            this.column2.setWidth(262);
        }
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_1 = new GridData(640);
        gridData_1.horizontalSpan = 2;
        composite_1.setLayoutData((Object)gridData_1);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 4;
        composite_1.setLayout((Layout)gridLayout_1);
        Button okBtn = new Button(composite_1, 0);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 90;
        okBtn.setLayoutData((Object)gridData_2);
        okBtn.setText(Messages.getString("ValueListEditorDialog.OK_10"));
        okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ValueListEditorDialog.this.itemList.getItems();
                ValueListEditorDialog.this.result = "";
                int i = 0;
                while (i < items.length) {
                    if (ValueListEditorDialog.this.withValueDesc) {
                        ValueListEditorDialog.this.result = String.valueOf(ValueListEditorDialog.this.result) + items[i].getText() + "=" + items[i].getText(1) + ";";
                    } else {
                        ValueListEditorDialog.this.result = String.valueOf(ValueListEditorDialog.this.result) + items[i].getText() + ";";
                    }
                    ++i;
                }
                ValueListEditorDialog.this.dispose();
            }
        });
        Button button_1 = new Button(composite_1, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValueListEditorDialog.this.result = null;
                ValueListEditorDialog.this.dispose();
            }
        });
        GridData gridData_3 = new GridData();
        gridData_3.widthHint = 90;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("ValueListEditorDialog.Cancel_14"));
        try {
            int idx;
            int offset = 0;
            while ((idx = valueListStr.indexOf(59, offset)) != -1) {
                String key;
                String aStr = valueListStr.substring(offset, idx);
                int idx1 = aStr.indexOf(61);
                if (idx1 != -1) {
                    key = aStr.substring(0, idx1);
                    String value = aStr.substring(idx1 + 1);
                    TableItem aitem = new TableItem(this.itemList, 0);
                    aitem.setText(key);
                    aitem.setText(1, value);
                } else {
                    key = aStr;
                    TableItem aitem = new TableItem(this.itemList, 0);
                    aitem.setText(key);
                }
                if ((offset = idx + 1) != valueListStr.length()) continue;
                break;
            }
        }
        catch (Exception offset) {
            // empty catch block
        }
        Rectangle rect = this.shell.getDisplay().getBounds();
        rect.x = (rect.width - 450) / 2;
        rect.y = (rect.height - 380) / 3;
        rect.width = 450;
        rect.height = 380;
        this.shell.setBounds(rect);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void addNewValue() {
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.getParent(), (String)Messages.getString("ValueListEditorDialog.Warning_17"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_value_String,_________;___are_not_allowed_!_18"));
            return;
        }
        if (this.withValueDesc && (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1)) {
            MessageDialog.openWarning((Shell)this.getParent(), (String)Messages.getString("ValueListEditorDialog.Warning_21"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_Text_String,_________;___are_not_allowed_!_22"));
            return;
        }
        TableItem item = new TableItem(this.itemList, 0);
        item.setText(0, valueStr);
        if (this.withValueDesc) {
            item.setText(1, textStr);
        }
    }

    private void updateItemValue() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            return;
        }
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.getParent(), (String)Messages.getString("ValueListEditorDialog.Warning_25"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_value_String,_________;___are_not_allowed_!_26"));
            return;
        }
        if (this.withValueDesc && (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1)) {
            MessageDialog.openWarning((Shell)this.getParent(), (String)Messages.getString("ValueListEditorDialog.Warning_29"), (String)Messages.getString("ValueListEditorDialog.Please_input_correct_Text_String,_________;___are_not_allowed_!_30"));
            return;
        }
        items[0].setText(0, valueStr);
        if (this.withValueDesc) {
            items[0].setText(1, textStr);
        }
    }

    private void setActiveItem() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            this.textText.setText("");
            this.valueText.setText("");
            return;
        }
        this.valueText.setText(items[0].getText());
        if (this.withValueDesc) {
            this.textText.setText(items[0].getText(1));
        }
    }

    public void dispose() {
        this.shell.dispose();
        this.textText.dispose();
        this.valueText.dispose();
    }
}

