/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.module;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.DefaultGrpPage;
import com.ecc.ide.module.ModuleWizardPage;
import com.ecc.ide.module.SettingWizardPage;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EMPRefWizard
extends Wizard {
    private SettingWizardPage settingsPage;
    private ModuleWizardPage modulePage;
    private DefaultGrpPage grpIdPage;
    private IDEProjectSettings settings;
    private XMLNode selectedModules;
    private IProject project;
    public String defaultBizGrpId;
    public String defaultMvcGrpId;

    public EMPRefWizard(IProject project, IDEProjectSettings settings) {
        this.settings = settings;
        this.project = project;
    }

    public void addPages() {
        this.settingsPage = new SettingWizardPage("\u4e3a\u9879\u76ee\u6dfb\u52a0EMP\u652f\u6301", "\u4e3a\u9879\u76ee\u6dfb\u52a0EMP\u652f\u6301:\n\t\u8bbe\u5b9a\u9879\u76ee\u57fa\u672c\u5c5e\u6027", this.settings.getSettingsNode());
        this.addPage((IWizardPage)this.settingsPage);
        this.modulePage = new ModuleWizardPage("Project settings", "\u4e3a\u9879\u76ee\u6dfb\u52a0EMP\u652f\u6301:\n\t\u9009\u5b9a\u9879\u76ee\u5173\u8054\u7ec4\u4ef6\u5305", this.settings);
        this.addPage((IWizardPage)this.modulePage);
        this.grpIdPage = new DefaultGrpPage(this.project);
        this.addPage((IWizardPage)this.grpIdPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            this.settingsPage.performNext();
            return this.modulePage;
        }
        if (page == this.modulePage) {
            if (!this.project.getFolder("designFiles").exists()) {
                return this.grpIdPage;
            }
            return null;
        }
        if (page == this.grpIdPage) {
            return null;
        }
        return null;
    }

    public boolean performFinish() {
        this.selectedModules = this.getModuleNode();
        try {
            this.defaultBizGrpId = this.grpIdPage.getBizGrpId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.defaultMvcGrpId = this.grpIdPage.getMvcGrpId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public XMLNode getSelectedModules() {
        try {
            XMLNode coreNode = this.selectedModules.findChildNode("core");
            if (coreNode != null) {
                coreNode.setAttrValue("bizGrpId", this.defaultBizGrpId);
                coreNode.setAttrValue("mvcGrpId", this.defaultMvcGrpId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.selectedModules;
    }

    public boolean canFinish() {
        if (this.modulePage.getSelectNode() == null) {
            return false;
        }
        if (!this.project.getFolder("designFiles").exists()) {
            return this.grpIdPage.canFinish();
        }
        return true;
    }

    private XMLNode getModuleNode() {
        return this.modulePage.getSelectNode();
    }
}

