/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.module;

import com.ecc.ide.editor.XMLNode;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ModuleTreePanel
extends Composite {
    private CheckboxTreeViewer checkboxTreeViewer;
    private XMLNode modules;
    private XMLNode installedModules;

    public ModuleTreePanel(Composite parent, XMLNode modules, XMLNode installedModules) {
        super(parent, 0);
        this.modules = modules;
        this.installedModules = installedModules;
        this.setLayout((Layout)new FillLayout());
        this.checkboxTreeViewer = new CheckboxTreeViewer((Composite)this, 67584);
        this.checkboxTreeViewer.setContentProvider((IContentProvider)new ModuleTreeCP());
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new ModuleTreeLP());
        this.checkboxTreeViewer.setInput((Object)modules);
        try {
            this.checkGray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                XMLNode node = (XMLNode)event.getElement();
                boolean grayed = ModuleTreePanel.this.checkboxTreeViewer.getGrayed((Object)node);
                if (grayed) {
                    ModuleTreePanel.this.checkboxTreeViewer.setChecked((Object)node, true);
                }
                boolean flag = event.getChecked();
                Vector childs = node.getChilds();
                if (childs == null) {
                    return;
                }
                int i = 0;
                while (i < childs.size()) {
                    grayed = ModuleTreePanel.this.checkboxTreeViewer.getGrayed(childs.elementAt(i));
                    if (!grayed) {
                        ModuleTreePanel.this.checkboxTreeViewer.setChecked(childs.elementAt(i), flag);
                    }
                    ++i;
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void checkGray() {
        this.checkboxTreeViewer.expandToLevel(2);
        if (this.installedModules == null) {
            return;
        }
        Vector childs = this.installedModules.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode node = (XMLNode)childs.elementAt(i);
            if ("module".equals(node.getNodeName())) {
                String id = node.getAttrValue("id");
                XMLNode module = this.modules.findIgnoreCaseThrowChildNode("module", id);
                module.setAttrValue("installed", "true");
                this.checkboxTreeViewer.setGrayChecked((Object)module, true);
            }
            ++i;
        }
    }

    public XMLNode getSelectNode() {
        XMLNode result = new XMLNode("SelectedNode");
        Object[] selects = this.checkboxTreeViewer.getCheckedElements();
        int i = 0;
        while (i < selects.length) {
            XMLNode node = (XMLNode)selects[i];
            String installed = node.getAttrValue("installed");
            if (!"true".equals(installed) && "module".equals(node.getNodeName())) {
                result.add((XMLNode)node.clone());
            }
            ++i;
        }
        return result;
    }

    class ModuleTreeCP
    implements ITreeContentProvider {
        ModuleTreeCP() {
        }

        public Object[] getChildren(Object obj) {
            return this.getElements(obj);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object obj) {
            if (obj instanceof XMLNode) {
                XMLNode node = (XMLNode)obj;
                Vector childs = node.getChilds();
                if (childs == null || childs.size() == 0) {
                    return false;
                }
                if (node.findChild("module") == null) {
                    return false;
                }
            }
            return true;
        }

        public Object[] getElements(Object obj) {
            if (obj instanceof XMLNode) {
                XMLNode node = (XMLNode)obj;
                return node.getChilds().toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ModuleTreeLP
    extends LabelProvider {
        ModuleTreeLP() {
        }

        public String getText(Object element) {
            String desc;
            if (!(element instanceof XMLNode)) {
                return "";
            }
            XMLNode curNode = (XMLNode)element;
            String text = curNode.getAttrValue("id");
            String version = curNode.getAttrValue("version");
            String defaultInstall = curNode.getAttrValue("default");
            if ("true".equals(defaultInstall)) {
                ModuleTreePanel.this.checkboxTreeViewer.setGrayChecked((Object)curNode, true);
            }
            boolean installed = false;
            if (version != null && version.length() > 0) {
                text = String.valueOf(text) + " " + version + " ";
            }
            if ((desc = curNode.getAttrValue("desc")) != null && desc.length() > 0) {
                text = String.valueOf(text) + "\u2014\u2014" + desc;
            }
            return text;
        }
    }
}

