/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.module;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.wizard.jdbc.DBConnectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SettingPanel
extends Composite {
    private Combo combo;
    private XMLNode prjSettingNode;
    private Text javaSrcPathText;
    private Text webcontentPathText;
    private Text jspEncodeText;
    private Text xmlEncodeText;
    private Button manualSetXMLEncodeButton;
    private Button manualSetJSPEncodeButton;
    private Button autoDeployButton;
    private Button ConsoleUnableButton;

    public SettingPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Group encodeGroup = new Group((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        encodeGroup.setLayout((Layout)gridLayout);
        encodeGroup.setText("Encode");
        encodeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.manualSetXMLEncodeButton = new Button((Composite)encodeGroup, 32);
        this.manualSetXMLEncodeButton.setText("Use");
        Label xmlEncodingLabel = new Label((Composite)encodeGroup, 0);
        xmlEncodingLabel.setText("XML Encoding");
        this.xmlEncodeText = new Text((Composite)encodeGroup, 2048);
        this.xmlEncodeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.manualSetJSPEncodeButton = new Button((Composite)encodeGroup, 32);
        this.manualSetJSPEncodeButton.setText("Use");
        Label jspEncodingLabel = new Label((Composite)encodeGroup, 0);
        jspEncodingLabel.setText("JSP Encoding");
        this.jspEncodeText = new Text((Composite)encodeGroup, 2048);
        this.jspEncodeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group pathGroup = new Group((Composite)this, 0);
        pathGroup.setText("Path");
        pathGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        pathGroup.setLayout((Layout)gridLayout_1);
        Label webcontentPathLabel = new Label((Composite)pathGroup, 0);
        webcontentPathLabel.setText("WebContent Path:");
        this.webcontentPathText = new Text((Composite)pathGroup, 2048);
        this.webcontentPathText.setEnabled(false);
        this.webcontentPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label javaSrcPathLabel = new Label((Composite)pathGroup, 0);
        javaSrcPathLabel.setText("Java Src Path:");
        this.javaSrcPathText = new Text((Composite)pathGroup, 2048);
        this.javaSrcPathText.setEnabled(false);
        this.javaSrcPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group dbAccessGroup = new Group((Composite)this, 0);
        dbAccessGroup.setText("DB Access");
        dbAccessGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        dbAccessGroup.setLayout((Layout)new GridLayout());
        Button setDbAccessButton = new Button((Composite)dbAccessGroup, 0);
        setDbAccessButton.setText("Set DB Access");
        setDbAccessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBConnectionDialog dbConnectionDialog = new DBConnectionDialog(SettingPanel.this.getShell(), 0);
                XMLNode dbAccessNode = SettingPanel.this.prjSettingNode.findChild("dbAccess");
                if (dbAccessNode == null) {
                    dbAccessNode = new XMLNode("dbAccess");
                    SettingPanel.this.prjSettingNode.add(dbAccessNode);
                }
                dbConnectionDialog.setDBAccessNode(dbAccessNode);
                dbConnectionDialog.open();
            }
        });
        Group settingGroup = new Group((Composite)this, 0);
        settingGroup.setText("Setting");
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 48;
        settingGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout_2 = new GridLayout();
        settingGroup.setLayout((Layout)gridLayout_2);
        this.autoDeployButton = new Button((Composite)settingGroup, 32);
        this.autoDeployButton.setLayoutData((Object)new GridData());
        this.autoDeployButton.setText("Auto deploy");
        this.ConsoleUnableButton = new Button((Composite)settingGroup, 32);
        this.ConsoleUnableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.ConsoleUnableButton.setText("Console Enable");
        Group compileGroup = new Group((Composite)this, 0);
        compileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        compileGroup.setText("Compile");
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        compileGroup.setLayout((Layout)gridLayout1);
        Label label = new Label((Composite)compileGroup, 0);
        label.setText("\u7f16\u8bd1\u7248\u672c");
        this.combo = new Combo((Composite)compileGroup, 0);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.combo.setItems(new String[]{"1.1", "2.1"});
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setPrjSettingNode(XMLNode node) {
        this.prjSettingNode = node;
        this.setButton("manualSetXMLEncode", this.manualSetXMLEncodeButton);
        this.setButton("manualSetJSPEncode", this.manualSetJSPEncodeButton);
        this.setButton("autoCompile", this.autoDeployButton);
        this.setButton("ConsoleUnable", this.ConsoleUnableButton);
        this.setText("XMLEncode", this.xmlEncodeText);
        this.setText("JSPEncode", this.jspEncodeText);
        this.setText("WebRootPath", this.webcontentPathText);
        this.setText("JavaSourcePath", this.javaSrcPathText);
        try {
            String prjVersion = this.prjSettingNode.getChild("properties").findChildNode("property", "PRJVersion").getAttrValue("value");
            if (prjVersion == null || prjVersion.length() == 0) {
                prjVersion = "1.1";
            }
            this.combo.setText(prjVersion);
        }
        catch (Exception e) {
            this.combo.setText("1.1");
        }
    }

    private void setButton(String propertyId, Button button) {
        XMLNode propertyNode = this.prjSettingNode.findChildNode(propertyId);
        if (propertyNode != null) {
            String propertyValue = propertyNode.getAttrValue("value");
            if (propertyValue != null && propertyValue.equals("true")) {
                button.setSelection(true);
            } else {
                button.setSelection(false);
            }
        }
    }

    private void setText(String propertyId, Text text) {
        String propertyValue;
        XMLNode propertyNode = this.prjSettingNode.findChildNode(propertyId);
        if (propertyNode != null && (propertyValue = propertyNode.getAttrValue("value")) != null && propertyValue.trim().length() != 0) {
            text.setText(propertyValue);
        }
    }

    public void performOk() {
        this.setPropertyNode("manualSetXMLEncode", this.manualSetXMLEncodeButton);
        this.setPropertyNode("manualSetJSPEncode", this.manualSetJSPEncodeButton);
        this.setPropertyNode("autoCompile", this.autoDeployButton);
        this.setPropertyNode("ConsoleUnable", this.ConsoleUnableButton);
        this.setPropertyNode("XMLEncode", this.xmlEncodeText);
        this.setPropertyNode("JSPEncode", this.jspEncodeText);
        this.setPropertyNode("WebRootPath", this.webcontentPathText);
        this.setPropertyNode("JavaSourcePath", this.javaSrcPathText);
        try {
            XMLNode propertyNode = this.prjSettingNode.findChildNode("PRJVersion");
            if (propertyNode == null) {
                propertyNode = new XMLNode("property");
                propertyNode.setAttrValue("id", "PRJVersion");
                this.prjSettingNode.getChild("properties").add(propertyNode);
            }
            String propertyValue = this.combo.getText();
            propertyNode.setAttrValue("value", propertyValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPropertyNode(String propertyId, Button button) {
        XMLNode propertyNode = this.prjSettingNode.findChildNode(propertyId);
        if (propertyNode == null) {
            propertyNode = new XMLNode("property");
            propertyNode.setAttrValue("id", propertyId);
            this.prjSettingNode.getChild("properties").add(propertyNode);
        }
        if (button.getSelection()) {
            propertyNode.setAttrValue("value", "true");
        } else {
            propertyNode.setAttrValue("value", "false");
        }
    }

    private void setPropertyNode(String propertyId, Text text) {
        XMLNode propertyNode = this.prjSettingNode.findChildNode(propertyId);
        if (propertyNode == null) {
            propertyNode = new XMLNode("property");
            propertyNode.setAttrValue("id", propertyId);
            this.prjSettingNode.getChild("properties").add(propertyNode);
        }
        String propertyValue = text.getText();
        propertyNode.setAttrValue("value", propertyValue);
    }

    public void performDefaults() {
        this.setPrjSettingNode(this.prjSettingNode);
    }
}

