/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin;

import com.ecc.ide.ant.AntObject;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.plugin.BuilderProblemContentProvider;
import com.ecc.ide.plugin.BuilderProblemTableLabelProvider;
import com.ecc.ide.plugin.FlashWindow;
import com.ecc.ide.plugin.editors.EMPFileChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ECCIDEPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ecc.ide";
    private static ECCIDEPlugin plugin;
    private ResourceBundle resourceBundle;
    private BuilderProblemContentProvider contentProvidor;
    private BuilderProblemTableLabelProvider labelProvidor;
    private String versionId = "";
    private String coreVersionId = "";

    public ECCIDEPlugin() {
        plugin = this;
        new EMPFileChangeListener();
    }

    private void initialize() {
        try {
            this.resourceBundle = ResourceBundle.getBundle("plugin");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        try {
            this.versionId = ((BundleHost)this.getBundle()).getBundleData().getVersion().toString();
            this.coreVersionId = ((BundleHost)Platform.getBundle((String)"com.ecc.ide.module.core")).getBundleData().getVersion().toString();
        }
        catch (Exception x) {
            // empty catch block
        }
        Preferences preferenceStore = null;
        try {
            preferenceStore = this.getPluginPreferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IDEConstance.tagPrefix = preferenceStore.getString("tagPrefix");
        if (IDEConstance.tagPrefix == null || IDEConstance.tagPrefix.length() == 0) {
            String msg = "Preference value of tag lib prefix lost, please reset the preference!";
            IDEConstance.tagPrefix = "ctp:";
            BuildProblemObject obj = new BuildProblemObject(BuildProblemObject.ERROR, msg, msg, "e-Channels MCI IDE", "", "");
            this.addProblemElement(obj);
        }
        this.startTempletServer();
        this.showFlashWindow();
    }

    private void startTempletServer() {
        AntObject antObj = new AntObject("Init_EMP_IDE", "", null, null);
        antObj.setProperty("str", "EMP IDE :" + this.versionId + "\nEMP Core:" + this.coreVersionId);
        RunAntInIDE.run(antObj);
    }

    public void showFlashWindow() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final Display dis = display;
        display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = new Shell(dis, 0);
                shell.setLayout((Layout)new FillLayout());
                FlashWindow window = new FlashWindow((Composite)shell, 0, ECCIDEPlugin.this.versionId, ECCIDEPlugin.this.coreVersionId);
                window.showWindow();
            }
        });
    }

    public static ECCIDEPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ECCIDEPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static InputStream getFile(String s) {
        try {
            URL url = plugin.find((IPath)new Path(s));
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void saveFile(String fileName, String content) {
        try {
            String fullPathName = String.valueOf(ECCIDEPlugin.getDir("/")) + fileName;
            FileWriter fw = new FileWriter(fullPathName);
            fw.write(content);
            fw.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshSettings(IProject project) {
        IDEContent.refreshSettings(project);
        IDEProfile.refreshSettings(project);
    }

    public void reportProblem(int type, String msg, String location, Exception e, IProject project, String fileName) {
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, project.getName(), location, fileName);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public ITableLabelProvider getLabelProvider() {
        if (this.labelProvidor == null) {
            this.labelProvidor = new BuilderProblemTableLabelProvider();
        }
        return this.labelProvidor;
    }

    public IStructuredContentProvider getContentProvider() {
        if (this.contentProvidor == null) {
            this.contentProvidor = new BuilderProblemContentProvider();
        }
        return this.contentProvidor;
    }

    public void initializeDefaultPluginPreferences() {
        Preferences store = this.getPluginPreferences();
        store.setDefault("autoBuild", true);
        store.setDefault("buildStateMachineAsOperation", false);
        store.setDefault("setXMLEncodingNamually", true);
        String encoding = "GB2312";
        store.setDefault("xmlEncoding", encoding);
        store.setDefault("usingIDELayout", false);
        store.setDefault("contentDIVID", "content");
        store.setDefault("buildJspWithTaglib", false);
        store.setDefault("tagPrefix", "ctp:");
        store.setDefault("unused", "unused!");
    }

    public String getPreferenceString() {
        StringBuffer buffer = new StringBuffer();
        Preferences store = this.getPluginPreferences();
        String tagPrefix = store.getString("tagPrefix");
        String xmlEncoding = store.getString("xmlEncoding");
        boolean haveError = false;
        if (store.getBoolean("buildJspWithTaglib") && (tagPrefix == null || tagPrefix.length() == 0)) {
            buffer.append("Error, preference store not set or lost please reset it!\n");
            haveError = true;
        }
        if (store.getBoolean("setXMLEncodingNamually") && !haveError && (xmlEncoding == null || xmlEncoding.length() == 0)) {
            buffer.append("Error, preference store not set or lost please reset it!\n");
        }
        buffer.append("\nIDESettings:");
        buffer.append("\n Auto Build: ");
        buffer.append(store.getBoolean("autoBuild"));
        buffer.append("\n Manual set encoding: ");
        buffer.append(store.getBoolean("setXMLEncodingNamually"));
        buffer.append("\n XML encoding: ");
        buffer.append(xmlEncoding);
        buffer.append("\n Use IDE layout: ");
        buffer.append(store.getBoolean("usingIDELayout"));
        buffer.append("\n Content ID: ");
        buffer.append(store.getString("contentDIVID"));
        buffer.append("\n Build JSP with tagLib: ");
        buffer.append(store.getBoolean("buildJspWithTaglib"));
        buffer.append("\n Tag prefix: ");
        buffer.append(tagPrefix);
        return buffer.toString();
    }

    public void addProblemElement(Object obj) {
        if (this.contentProvidor != null) {
            this.contentProvidor.addElement(obj);
        }
        if (this.labelProvidor != null) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this.labelProvidor);
            this.labelProvidor.fireLabelProviderChanged(event);
        }
    }

    public void clearProblemElement() {
        if (this.contentProvidor != null) {
            this.contentProvidor.clearElement();
        }
        if (this.labelProvidor != null) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this.labelProvidor);
            this.labelProvidor.fireLabelProviderChanged(event);
        }
    }

    public static String getDir(String s) {
        try {
            Path path = new Path(s);
            URL resolvedURL = Platform.find((Bundle)ECCIDEPlugin.getDefault().getBundle(), (IPath)path);
            if (resolvedURL != null) {
                URL realURL = Platform.asLocalURL((URL)resolvedURL);
                File file = new File(realURL.getPath());
                return file.getAbsolutePath();
            }
            String installPath = ECCIDEPlugin.getDefault().getBundle().getLocation();
            int idx = installPath.indexOf(58);
            if (idx != -1) {
                installPath = installPath.substring(idx - 1);
                return String.valueOf(installPath) + s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void createFolders(String container, String rootFolder, String folderName) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(container));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            return;
        }
        if (rootFolder == null) {
            rootFolder = "/";
        }
        IFolder pFolder = resource.getProject().getFolder(rootFolder);
        folderName = folderName.replace('\\', '/');
        int offset = 0;
        if (folderName.startsWith("/")) {
            offset = 1;
        }
        while (true) {
            IFolder aFolder;
            String aFolderName;
            int idx;
            if ((idx = folderName.indexOf(47, offset)) == -1) {
                aFolderName = folderName.substring(offset);
                aFolder = pFolder.getFolder(aFolderName);
                if (aFolder.exists()) break;
                aFolder.create(true, true, null);
                break;
            }
            aFolderName = folderName.substring(offset, idx);
            aFolder = pFolder.getFolder(aFolderName);
            if (!aFolder.exists()) {
                aFolder.create(true, true, null);
            }
            offset = idx + 1;
            pFolder = aFolder;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initialize();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }
}

