/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.actions;

import com.ecc.ide.plugin.actions.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public abstract class AbstractNewAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection curSelection;
    private Class[] fActivatedOnTypes = null;
    private boolean fAcceptEmptySelection = false;
    private boolean fNoChecking = false;

    public AbstractNewAction(String s, boolean flag) {
        this(s, null, flag);
    }

    public AbstractNewAction(String s, Class[] aclass, boolean flag) {
        super(s);
        this.fActivatedOnTypes = aclass;
        this.fAcceptEmptySelection = flag;
        this.fNoChecking = false;
    }

    protected AbstractNewAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
        this.fNoChecking = true;
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench iworkbench = this.getWorkbench();
        IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        if (iworkbenchwindow == null) {
            IWorkbenchWindow[] aiworkbenchwindow = iworkbench.getWorkbenchWindows();
            int i = 0;
            while (i < aiworkbenchwindow.length) {
                if (!aiworkbenchwindow[i].getShell().isDisposed()) {
                    iworkbenchwindow = aiworkbenchwindow[i];
                    break;
                }
                ++i;
            }
        }
        return iworkbenchwindow;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private boolean isOfAcceptedType(Object obj) {
        if (this.fActivatedOnTypes != null) {
            int i = 0;
            while (i < this.fActivatedOnTypes.length) {
                if (this.fActivatedOnTypes[i].isInstance(obj)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection istructuredselection) {
        return true;
    }

    protected boolean shouldAcceptElement(Object obj) {
        return true;
    }

    protected abstract Wizard createWizard();

    protected IStructuredSelection getCurrentSelection() {
        return this.curSelection;
    }

    public void run() {
        if (!this.fNoChecking && !this.canActionBeAdded()) {
            return;
        }
        if (!this.checkWorkspaceNotEmpty()) {
            return;
        }
        Wizard wizard = this.createWizard();
        if (wizard instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
        }
        WizardDialog wizarddialog = new WizardDialog(this.getWorkbenchWindow().getShell(), (IWizard)wizard);
        wizarddialog.create();
        String s = wizard.getWindowTitle();
        if (s != null) {
            wizarddialog.getShell().setText(s);
        }
        wizarddialog.open();
    }

    public boolean canActionBeAdded() {
        IStructuredSelection istructuredselection = this.getCurrentSelection();
        if (istructuredselection == null || istructuredselection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(istructuredselection);
    }

    public void run(IAction iaction) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iworkbenchwindow) {
        System.out.println(iworkbenchwindow);
    }

    public void selectionChanged(IAction iaction, ISelection iselection) {
        if (iselection instanceof IStructuredSelection) {
            this.curSelection = (IStructuredSelection)iselection;
        }
    }

    protected boolean checkWorkspaceNotEmpty() {
        IWorkspace iworkspace = ResourcesPlugin.getWorkspace();
        if (iworkspace.getRoot().getProjects().length == 0) {
            String s1;
            String s;
            Shell shell = this.getWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(s = Messages.getString("AbstractNewAction.No_Projects_1")), (String)(s1 = Messages.getString("AbstractNewAction.A_project_must_be_created_first_2")))) {
                new NewProjectAction().run();
                return iworkspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }

    public void setCurrentSelection(IStructuredSelection selection) {
        this.curSelection = selection;
    }
}

