/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.ant.AntObject;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.module.ModuleUtility;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;

public class EMPFileChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private IFile lastfile = null;
    private long lasttime = 0L;
    private String[] bizgrpfiles = new String[]{"formats.xml", "nodeSettings.xml", "serverFlow.xml", "services.xml", "settings.xml"};

    public EMPFileChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        if (res instanceof IFile) {
            IFile file = (IFile)res;
            if ((file = this.isIDEFile(file)) != null) {
                String fileName = file.getProjectRelativePath().toOSString();
                IProject project = file.getProject();
                if (delta.getMarkerDeltas().length != 0) {
                    // empty if block
                }
                ModuleUtility.addingmodule = true;
                try {
                    AntObject antObject2 = new AntObject("buildfile", "\u90e8\u7f72" + file.getName(), project, new BuildListener(){

                        public void buildFinished(BuildEvent arg0) {
                            try {
                                ModuleUtility.addingmodule = false;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }

                        public void buildStarted(BuildEvent arg0) {
                        }

                        public void messageLogged(BuildEvent arg0) {
                        }

                        public void targetFinished(BuildEvent arg0) {
                        }

                        public void targetStarted(BuildEvent arg0) {
                        }

                        public void taskFinished(BuildEvent arg0) {
                        }

                        public void taskStarted(BuildEvent arg0) {
                        }
                    });
                    antObject2.setProperty("groupId", IDEContent.getGroupId(fileName));
                    antObject2.setProperty("srcFile", fileName);
                    this.lastfile = file;
                    this.lasttime = System.currentTimeMillis();
                    RunAntInIDE.run(antObject2);
                }
                catch (Exception e) {
                    ModuleUtility.addingmodule = false;
                }
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    private IFile isIDEFile(IFile file) {
        if (ModuleUtility.addingmodule) {
            return null;
        }
        IProject project = file.getProject();
        String fileName = file.getProjectRelativePath().toOSString();
        if (fileName.indexOf("designFiles") == -1) {
            return null;
        }
        String autoCompile = IDEContent.getPRJSettings(project).getAutoCompile();
        if (!"true".equalsIgnoreCase(autoCompile)) {
            return null;
        }
        if (System.currentTimeMillis() - file.getLocalTimeStamp() > 100000L) {
            return null;
        }
        if (this.lastfile != null && file.equals((Object)this.lastfile) && System.currentTimeMillis() - this.lasttime < 1000L) {
            return null;
        }
        String name = file.getName();
        int i = 0;
        while (i < this.bizgrpfiles.length) {
            String temp = this.bizgrpfiles[i];
            if (temp.equals(name) && file.getParent().findMember("nodeSettings.xml").exists()) {
                return (IFile)file.getParent().findMember("nodeSettings.xml");
            }
            ++i;
        }
        if (!this.isDesignFile(file)) {
            return null;
        }
        return file;
    }

    private boolean isDesignFile(IFile file) {
        String[] designFiles = new String[]{".debug", ".doc"};
        int i = 0;
        while (i < designFiles.length) {
            if (file.getLocation().toOSString().indexOf(designFiles[i]) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

