/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.externResource.ExternResourceEditPanel;
import com.ecc.ide.editor.javascript.JavaScriptFunctionEditPanel;
import com.ecc.ide.editor.project.ProjectMainPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.popup.actions.Messages;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class HTMLClientSettingsEditor
extends MultiPageEditorPart
implements ContentChangedListener,
BuildProblemReporter {
    private IProject project;
    ProjectMainPanel projectMainPanel;
    JavaScriptFunctionEditPanel javaScriptPanel;
    ExternResourceEditPanel resourceEditPanel;
    private boolean isChanged = false;
    private EditorProfile htmlEditProfile;
    private int changeLen = 30;
    private int[] changedProfileFiles = new int[this.changeLen];
    private int[] changedSettingsFiles = new int[this.changeLen];
    int curProLen = 0;
    int curSetLen = 0;

    void createPrjMainSettingsPage() {
        try {
            this.projectMainPanel = new ProjectMainPanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.projectMainPanel);
            this.setPageText(index, Messages.getString("ECCMCIPrjSettingsEditor.project_Expands_1"));
            XMLNode definedClassTypeNode = IDEContent.getSettingNode(this.project, 27);
            this.projectMainPanel.setDefinedClassType(definedClassTypeNode);
            this.projectMainPanel.setProject(this.project);
            this.htmlEditProfile = IDEProfile.getEditorProfile(this.project, 20);
            this.projectMainPanel.addEditorProfile("JSP elements", this.htmlEditProfile);
            this.projectMainPanel.setFunctionProfile(IDEProfile.getEditorProfile(this.project, 16));
            this.projectMainPanel.setFunctionXMLNode(IDEContent.getSettingNode(this.project, 16));
            this.projectMainPanel.addContentChangedListener(this, this.project);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createExternResourcePage() {
        try {
            this.resourceEditPanel = new ExternResourceEditPanel(this.getContainer(), 0);
            XMLNode resourceNode = IDEContent.getSettingNode(this.project, 30);
            this.resourceEditPanel.setXMLContent(resourceNode);
            int index = this.addPage((Control)this.resourceEditPanel);
            this.setPageText(index, "StringResource");
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    protected void createPages() {
        this.createPrjMainSettingsPage();
        this.createJavaScriptPage();
        this.createExternResourcePage();
        this.initializeContentChangedListener();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.curProLen) {
            IDEProfile.saveEditorProfile(this.project, this.changedProfileFiles[i]);
            ++i;
        }
        i = 0;
        while (i < this.curSetLen) {
            IDEContent.saveSettingNode(this.project, this.changedSettingsFiles[i]);
            ++i;
        }
        this.curProLen = 0;
        this.curSetLen = 0;
        if (ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("autoBuild")) {
            this.buildMCISettings();
        }
        this.isChanged = false;
        this.firePropertyChange(257);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.project = ((FileEditorInput)editorInput).getFile().getProject();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
        if (event == null) {
            return;
        }
        if (event.getSource() != null && event.getSource() instanceof EditorProfile) {
            int settingsType = -1;
            if (event.getSource() == this.htmlEditProfile) {
                settingsType = 20;
            }
            if (settingsType == -1) {
                return;
            }
            int i = 0;
            while (i < this.curProLen) {
                if (this.changedProfileFiles[i] == settingsType) break;
                ++i;
            }
            if (i == this.curProLen) {
                this.changedProfileFiles[this.curProLen++] = settingsType;
            }
        } else {
            int settingsType = event.getSourceType();
            int i = 0;
            while (i < this.curSetLen) {
                if (this.changedSettingsFiles[i] == settingsType) break;
                ++i;
            }
            if (i == this.curSetLen) {
                this.changedSettingsFiles[this.curSetLen++] = settingsType;
            }
        }
    }

    private void saveXMLNodeToFile(String fileName, XMLNode node) {
        try {
            StringBuffer strBuf = new StringBuffer();
            node.toXMLContent(0, strBuf);
            FileWriter fw = new FileWriter(fileName);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, fileName);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void reportProblem(int type, String msg, String detail) {
        String detailMsg = msg;
        if (detail != null) {
            detailMsg = detail;
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), "", "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void initializeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 20);
            if (node != null) {
                node.addContentChangedListener(this, this.project, 20);
            }
            if ((node = IDEContent.getSettingNode(this.project, 30)) != null) {
                node.addContentChangedListener(this, this.project, 30);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    public void removeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 20);
            if (node != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 29)) != null) {
                node.removeContentChangedListener(this);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    private void buildMCISettings() {
    }

    public void dispose() {
        super.dispose();
        this.removeContentChangedListener();
    }

    private void setServiceSettings(XMLNode settingsNode, EditorProfile serviceProfile) {
        XMLNode node = settingsNode.findChildNode("kColl", "settings");
        XMLNode tagsNode = node.findChildNode("kColl", "tags");
        XMLNode svcNode = tagsNode.findChildNode("kColl", "services");
        Vector catalogs = serviceProfile.getCagalogs();
        if (catalogs == null) {
            return;
        }
        tagsNode.remove(svcNode);
        try {
            int i = 0;
            while (i < catalogs.size()) {
                ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
                int k = 0;
                while (k < catalog.getElements().size()) {
                    Element element = (Element)catalog.getElements().elementAt(k);
                    if (element.getImplClass() != null) {
                        String elementName = element.getElementName();
                        XMLNode elementSettingNode = svcNode.findChildNode(elementName);
                        if (elementSettingNode == null) {
                            elementSettingNode = new XMLNode();
                            elementSettingNode.setNodeName("field");
                            elementSettingNode.setAttrValue("id", elementName);
                            svcNode.add(elementSettingNode);
                        }
                        elementSettingNode.setAttrValue("value", element.getImplClass());
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.MESSAGE, "Failed to set serviceSettings: " + e, null, "", e);
        }
        tagsNode.add(svcNode);
    }

    void createJavaScriptPage() {
        try {
            JavaScriptFunctionEditPanel javaScriptPanel = new JavaScriptFunctionEditPanel(this.getContainer(), 0);
            javaScriptPanel.setEditorProfile(IDEProfile.getEditorProfile(this.project, 16));
            XMLNode resourceNode = IDEContent.getSettingNode(this.project, 30);
            javaScriptPanel.setExternResource(resourceNode);
            XMLNode content = IDEContent.getSettingNode(this.project, 20);
            javaScriptPanel.setXMLContent(content);
            int index = this.addPage((Control)javaScriptPanel);
            this.setPageText(index, "JavaScript");
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }
}

