/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.part.EditorPart;

public class IDEEditorListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public boolean saving = false;
    private EditorPart editor = null;
    private IProject project = null;
    private Vector relaFiles = new Vector();
    private Vector workingFiles = new Vector();
    private Vector changedFiles = new Vector();
    private Hashtable savedContents = new Hashtable();
    private Hashtable savedLength = new Hashtable();

    public IDEEditorListener(EditorPart editor, IProject project) {
        this.editor = editor;
        this.project = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addRelaFile(IFile file, XMLNode node) {
        if (!file.exists()) {
            return;
        }
        this.relaFiles.add(file);
        this.savedContents.put(file, node);
        long length = this.getLength(file);
        this.savedLength.put(file, new Long(length));
    }

    public void addWorkingFile(IFile file, XMLNode node) {
        if (!file.exists()) {
            return;
        }
        this.addRelaFile(file, node);
        this.workingFiles.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean fileModified(IFile file) {
        long oldLength = (Long)this.savedLength.get(file);
        long length = this.getLength(file);
        if (length != oldLength) {
            return true;
        }
        XMLNode savedNode = (XMLNode)this.savedContents.get(file);
        XMLNode newNode = this.getNode(file);
        if (newNode == null) {
            return true;
        }
        StringBuffer savedBuf = new StringBuffer();
        savedNode.toXMLContent(0, savedBuf);
        StringBuffer newBuf = new StringBuffer();
        newNode.toXMLContent(0, newBuf);
        String oldstr = new String(savedBuf);
        String newstr = new String(newBuf);
        return !oldstr.equals(newstr);
    }

    protected boolean isRelaFile(IFile file) {
        return this.relaFiles.contains(file);
    }

    protected boolean isWorkingFile(IFile file) {
        return this.workingFiles.contains(file);
    }

    public boolean visit(IResourceDelta delta) {
        IResource res = delta.getResource();
        if (res instanceof IFile && this.isRelaFile((IFile)res)) {
            if (this.isWorkingFile((IFile)res) && this.saving) {
                return false;
            }
            if (!this.changedFiles.contains(res)) {
                this.changedFiles.add(res);
            }
            return false;
        }
        return true;
    }

    public boolean isChanged() {
        if (this.changedFiles.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.changedFiles.size()) {
            IFile file = (IFile)this.changedFiles.elementAt(i);
            if (this.fileModified(file)) {
                this.reload();
                return true;
            }
            ++i;
        }
        return false;
    }

    private void reload() {
        int i = 0;
        while (i < this.changedFiles.size()) {
            IFile file = (IFile)this.changedFiles.elementAt(i);
            this.savedLength.put(file, new Long(this.getLength(file)));
            XMLNode node = this.getNode(file);
            if (node != null) {
                this.savedContents.put(file, node);
            }
            ++i;
        }
    }

    private long getLength(IFile file) {
        File tempFile = new File(file.getLocation().toOSString());
        long length = tempFile.length();
        return length;
    }

    private XMLNode getNode(IFile file) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode newNode = (XMLNode)xmlLoader.loadXMLContent(file.getContents());
            return newNode;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

