/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.html.JSPEditPanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.editors.TransactionEditor;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class JSPTempletEditor
extends TransactionEditor {
    private JSPEditPanel trxPanel;

    public JSPTempletEditor() {
        this.editorType = JSP_TEMPLET;
        this.targetPath = "/WebContent";
        this.settingPath = "/WebContent/WEB-INF/server/htmlTrans";
    }

    public void createPartControl(Composite parent) {
        this.trxPanel = new JSPEditPanel(parent, 0);
        try {
            this.trxPanel.setRootPath(this.project.getLocation().toString());
            EditorProfile aDataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.trxPanel.setDataDictionaryEditorProfile(aDataProfile);
            XMLNode node = IDEContent.getSettingNode(this.project, 0);
            this.trxPanel.setDataDictionary(node);
            EditorProfile jspProfile = IDEProfile.getEditorProfile(this.project, 20);
            this.trxPanel.setJSPFileEditorProfile(jspProfile);
            EditorProfile htmlFlowProfile = IDEProfile.getEditorProfile(this.project, 19);
            XMLNode functionNode = IDEContent.getSettingNode(this.project, 16);
            XMLNode jsFunctionNode = IDEContent.getSettingNode(this.project, 20);
            this.trxPanel.setJSFunctionNode(jsFunctionNode);
            XMLNode patternnode = IDEContent.getSettingNode(this.project, 15);
            this.trxPanel.setPatternNode(patternnode);
            this.trxPanel.setPatternProfile(IDEProfile.getEditorProfile(this.project, 15));
            XMLNode externResource = IDEContent.getSettingNode(this.project, 30);
            this.trxPanel.setExternResource(externResource);
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            FileEditorInput input = (FileEditorInput)this.getEditorInput();
            InputStream content = input.getFile().getContents();
            this.trxNode = (XMLNode)xmlLoader2.loadXMLContent(content);
            this.trxPanel.setXMLContent(this.trxNode);
            this.trxNode.addContentChangedListener(this, this.project, 0);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        if (this.trxNode != null) {
            String fileName = this.getSaveAsFileName();
            if (fileName == null) {
                return;
            }
            IFile file = this.project.getFile(fileName);
            FileEditorInput input = new FileEditorInput(file);
            StringBuffer strBuf = new StringBuffer();
            this.trxNode.toXMLContent(0, strBuf);
            try {
                if (file.exists()) {
                    input.getFile().setContents((InputStream)new ByteArrayInputStream(strBuf.toString().getBytes()), 1, null);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(strBuf.toString().getBytes()), 1, null);
                }
                this.setInput((IEditorInput)input);
                this.setPartName(fileName);
                this.setTitleToolTip(String.valueOf(this.project.getLocation().toString()) + "/" + fileName);
            }
            catch (Exception e) {
                this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
            }
        }
        this.isChanged = false;
        this.firePropertyChange(257);
    }

    private String getSaveAsFileName() {
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterExtensions(new String[]{"*.tmp;"});
        String rootPath = this.project.getLocation().toOSString();
        if (rootPath != null) {
            dialog.setFilterPath(rootPath);
        }
        rootPath = rootPath.replace('\\', '/');
        String fileName = null;
        String result = dialog.open();
        if (result != null) {
            fileName = result;
            if (!this.checkPath(rootPath, fileName = fileName.replace('\\', '/'))) {
                fileName = null;
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Please select file from project's workspace path!");
            } else {
                fileName = fileName.substring(rootPath.length());
            }
        }
        return fileName;
    }

    private boolean checkPath(String rootPath, String fileName) {
        int idx = 0;
        int idx1 = rootPath.indexOf(":");
        if (idx1 != -1) {
            char ch1 = rootPath.charAt(0);
            ch1 = Character.toLowerCase(ch1);
            char ch2 = fileName.charAt(0);
            if (ch1 != (ch2 = Character.toLowerCase(ch2))) {
                return false;
            }
            String str1 = rootPath.substring(1);
            String str2 = fileName.substring(1);
            idx = str2.indexOf(str1);
        } else {
            idx = fileName.indexOf(rootPath);
        }
        return idx != -1;
    }
}

