/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.visualmvc.MVCSettingsNodePanel;
import com.ecc.ide.editor.xml.XMLEditorFramePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.editors.IDEEditorListener;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MVCSettingsEditor
extends MultiPageEditorPart
implements ContentChangedListener,
BuildProblemReporter {
    public boolean resourceIsChanged = false;
    public IProject project;
    private XMLEditorFramePanel trxPanel;
    private MVCSettingsNodePanel settingPanel;
    private XMLNode mvcDefineNode = null;
    private IFile mvcDefinFile = null;
    private boolean isChanged = false;
    private IDEProjectSettings prjSettings;

    private void createMVCSettingPage() {
        this.settingPanel = new MVCSettingsNodePanel(this.getContainer(), 0);
        int index = this.addPage((Control)this.settingPanel);
        this.setPageText(index, "Servlet");
        try {
            this.mvcDefineNode = IDEContent.getSettingNode(this.project, this.getGroupId(), 38);
            this.mvcDefineNode.addContentChangedListener(this, this.project, 38);
            this.settingPanel.setMVCDefineNode(this.mvcDefineNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createPages() {
        this.createMVCSettingPage();
        IDEEditorListener listener = new IDEEditorListener((EditorPart)this, this.project);
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
    }

    public void doSave(IProgressMonitor monitor) {
        IDEContent.saveSettingNode(this.project, this.getGroupId(), 38, this.mvcDefineNode);
        this.isChanged = false;
        this.firePropertyChange(257);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.project = ((FileEditorInput)editorInput).getFile().getProject();
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
            this.prjSettings = new IDEProjectSettings(prjSettingsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileEditorInput input = (FileEditorInput)this.getEditorInput();
        IFolder folder = (IFolder)input.getFile().getParent();
        this.mvcDefinFile = folder.getFile("mvcdefine.xml");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, fileName);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void reportProblem(int type, String msg, String detail) {
        String detailMsg = msg;
        if (detail != null) {
            detailMsg = detail;
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), "", "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void initializeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 1);
            if (node != null) {
                node.addContentChangedListener(this, this.project, 1);
            }
            if ((node = IDEContent.getSettingNode(this.project, 0)) != null) {
                node.addContentChangedListener(this, this.project, 0);
            }
            if ((node = IDEContent.getSettingNode(this.project, 5)) != null) {
                node.addContentChangedListener(this, this.project, 5);
            }
            if ((node = IDEContent.getSettingNode(this.project, 12)) != null) {
                node.addContentChangedListener(this, this.project, 12);
            }
            if ((node = IDEContent.getSettingNode(this.project, 11)) != null) {
                node.addContentChangedListener(this, this.project, 11);
            }
            if ((node = IDEContent.getSettingNode(this.project, 14)) != null) {
                node.addContentChangedListener(this, this.project, 14);
            }
            if ((node = IDEContent.getSettingNode(this.project, 19)) != null) {
                node.addContentChangedListener(this, this.project, 19);
            }
            if ((node = IDEContent.getSettingNode(this.project, 21)) != null) {
                node.addContentChangedListener(this, this.project, 21);
            }
            if ((node = IDEContent.getSettingNode(this.project, 23)) != null) {
                node.addContentChangedListener(this, this.project, 23);
            }
            if ((node = IDEContent.getSettingNode(this.project, 25)) != null) {
                node.addContentChangedListener(this, this.project, 25);
            }
            if ((node = IDEContent.getSettingNode(this.project, 29)) != null) {
                node.addContentChangedListener(this, this.project, 29);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    public void removeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 1);
            if (node != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 0)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 5)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 12)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 11)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 14)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 19)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 21)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 23)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 25)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 29)) != null) {
                node.removeContentChangedListener(this);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void setServiceSettings(XMLNode settingsNode, EditorProfile serviceProfile) {
        XMLNode node = settingsNode.findChildNode("kColl", "settings");
        XMLNode tagsNode = node.findChildNode("kColl", "tags");
        XMLNode svcNode = tagsNode.findChildNode("kColl", "services");
        Vector catalogs = serviceProfile.getCagalogs();
        if (catalogs == null) {
            return;
        }
        tagsNode.remove(svcNode);
        try {
            int i = 0;
            while (i < catalogs.size()) {
                ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
                int k = 0;
                while (k < catalog.getElements().size()) {
                    Element element = (Element)catalog.getElements().elementAt(k);
                    if (element.getImplClass() != null) {
                        String elementName = element.getElementName();
                        XMLNode elementSettingNode = svcNode.findChildNode(elementName);
                        if (elementSettingNode == null) {
                            elementSettingNode = new XMLNode();
                            elementSettingNode.setNodeName("field");
                            elementSettingNode.setAttrValue("id", elementName);
                            svcNode.add(elementSettingNode);
                        }
                        elementSettingNode.setAttrValue("value", element.getImplClass());
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.MESSAGE, "Failed to set serviceSettings: " + e, null, "", e);
        }
        tagsNode.add(svcNode);
    }

    private String getGroupId() {
        String groupId = IDEContent.getGroupId(((FileEditorInput)this.getEditorInput()).getPath().toString());
        return groupId;
    }
}

