/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.editors.EMPPrjEditor;
import com.ecc.ide.plugin.editors.IDEEditorListener;
import com.ecc.ide.plugin.editors.TableColumnDefineDiaglog;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class TableDefinePanel
extends Composite {
    private XMLNode tableNode;
    private TableViewer tableViewer;
    private IEditorInput input;
    private IDEEditorListener listener;
    private IProject project;
    private Text iCollNameText;
    private Text tableNameText;
    private Table table;
    private Button addToDictBtn;

    public TableDefinePanel(Composite parent, int style, IProject project, IDEEditorListener listener, IEditorInput input) {
        super(parent, style);
        this.project = project;
        this.listener = listener;
        this.input = input;
        this.setLayout((Layout)new GridLayout());
        Group group = new Group((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("\u57fa\u672c\u4fe1\u606f");
        Label label = new Label((Composite)group, 0);
        label.setText("\u8868\u540d");
        this.tableNameText = new Text((Composite)group, 2048);
        this.tableNameText.setEditable(false);
        this.tableNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label_1 = new Label((Composite)group, 0);
        label_1.setText("\u5bf9\u5e94\u96c6\u5408\u540d\u79f0");
        this.iCollNameText = new Text((Composite)group, 2048);
        this.iCollNameText.setEnabled(false);
        this.iCollNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 7;
        composite.setLayout((Layout)gridLayout_1);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 7, 1));
        composite_1.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer(composite_1, 67584);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableDefinePanel.this.modifyColumn();
            }
        });
        this.table = this.tableViewer.getTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn newColumnTableColumn = new TableColumn(this.table, 0);
        newColumnTableColumn.setWidth(100);
        newColumnTableColumn.setText("ColumnName");
        TableColumn newColumnTableColumn_1 = new TableColumn(this.table, 0);
        newColumnTableColumn_1.setWidth(100);
        newColumnTableColumn_1.setText("fieldName");
        TableColumn newColumnTableColumn_2 = new TableColumn(this.table, 0);
        newColumnTableColumn_2.setWidth(100);
        newColumnTableColumn_2.setText("ColumnType");
        TableColumn newColumnTableColumn_3 = new TableColumn(this.table, 0);
        newColumnTableColumn_3.setWidth(100);
        newColumnTableColumn_3.setText("isSequence");
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.addColumn();
            }
        });
        button.setText("\u6dfb\u52a0");
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.deleteColumn();
            }
        });
        button_1.setText("\u5220\u9664");
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.modifyColumn();
            }
        });
        button_2.setText("\u4fee\u6539");
        Button button_4 = new Button(composite, 0);
        button_4.setVisible(false);
        button_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.upColumn();
            }
        });
        button_4.setText("\u4e0a\u79fb");
        Button button_5 = new Button(composite, 0);
        button_5.setVisible(false);
        button_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.downColumn();
            }
        });
        button_5.setText("\u4e0b\u79fb");
        this.addToDictBtn = new Button(composite, 0);
        this.addToDictBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefinePanel.this.addToDataDict();
            }
        });
        this.addToDictBtn.setText("\u81ea\u52a8\u6ce8\u5165\u6570\u636e\u5b57\u5178");
        this.init();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void init() {
        this.getTableNode();
        try {
            String tableName = this.tableNode.getAttrValue("tableName");
            this.tableNameText.setText(tableName);
            String iCollName = this.tableNode.getAttrValue("iCollName");
            this.iCollNameText.setText(iCollName);
        }
        catch (Exception tableName) {
            // empty catch block
        }
        try {
            this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.getTableNode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateTable();
    }

    private void updateTable() {
        try {
            int w = 0;
            boolean flag = false;
            this.tableViewer.setInput(null);
            this.tableViewer.setInput((Object)this.getTableNode());
            XMLNode dataDict = IDEContent.getSettingNode(this.project, 0);
            int i = 0;
            while (i < this.tableNode.getChilds().size()) {
                XMLNode columnNode = (XMLNode)this.tableNode.getChilds().elementAt(i);
                if ("column".equals(columnNode.getNodeName())) {
                    String refId = columnNode.getAttrValue("dataName");
                    XMLNode dataElement = dataDict.findChildNodeWithAttrValue("dataElement", "id", refId);
                    XMLNode dataCollection = dataDict.findChildNodeWithAttrValue("dataCollection", "id", refId);
                    if (dataElement == null && dataCollection == null) {
                        TableItem item = this.table.getItem(w);
                        item.setForeground(1, this.getDisplay().getSystemColor(3));
                        flag = true;
                    }
                    ++w;
                }
                ++i;
            }
            String icollName = this.tableNode.getAttrValue("iCollName");
            XMLNode dataCollection = dataDict.findChildNodeWithAttrValue("dataCollection", "id", icollName);
            if (dataCollection == null) {
                flag = true;
            }
            this.addToDictBtn.setEnabled(flag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addColumn() {
        TableColumnDefineDiaglog dialog = new TableColumnDefineDiaglog(this.getShell(), 32768, null);
        dialog.open();
        XMLNode columnNode = dialog.columnNode;
        this.tableNode.add(columnNode);
        this.updateTable();
    }

    public void deleteColumn() {
        XMLNode node = (XMLNode)this.table.getSelection()[0].getData();
        if (node == null) {
            return;
        }
        boolean result = MessageDialog.openConfirm(null, (String)"\u786e\u8ba4", (String)("\u786e\u8ba4\u5220\u9664\u8be5\u5217" + node.getAttrValue("columnName") + "?"));
        if (!result) {
            return;
        }
        this.tableNode.remove(node);
        this.updateTable();
    }

    public void modifyColumn() {
        XMLNode node = (XMLNode)this.table.getSelection()[0].getData();
        if (node == null) {
            return;
        }
        TableColumnDefineDiaglog dialog = new TableColumnDefineDiaglog(this.getShell(), 32768, (XMLNode)node.clone());
        dialog.open();
        XMLNode columnNode = dialog.columnNode;
        if (columnNode == null) {
            return;
        }
        node.setAttrValue("columnType", columnNode.getAttrValue("columnType"));
        node.setAttrValue("dataName", columnNode.getAttrValue("dataName"));
        node.setAttrValue("columnName", columnNode.getAttrValue("columnName"));
        String isSequence = columnNode.getAttrValue("isSequence");
        if (isSequence == null) {
            isSequence = "false";
        }
        node.setAttrValue("isSequence", isSequence);
        this.updateTable();
    }

    public void upColumn() {
    }

    public void downColumn() {
    }

    public void addToDataDict() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            if ("com.ecc.ide.plugin.editors.EMPPrjEditor".equals(editors[i].getId()) && this.project.equals((Object)((EMPPrjEditor)editors[i].getPart((boolean)false)).project)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)"\u6570\u636e\u5b57\u5178\u6587\u4ef6\u6b63\u5728\u7f16\u8f91");
                return;
            }
            ++i;
        }
        boolean result = MessageDialog.openConfirm((Shell)this.getShell(), (String)"\u786e\u8ba4", (String)"\u786e\u8ba4\u5c06\u8fd9\u4e9b\u6570\u636e\u5bfc\u5165\u6570\u636e\u5b57\u5178?");
        if (!result) {
            return;
        }
        try {
            XMLNode dataDict = IDEContent.getSettingNode(this.project, 0);
            XMLNode groupNode = dataDict.findChildNodeNamed("dataGroup", this.tableNameText.getText());
            if (groupNode == null) {
                groupNode = new XMLNode("dataGroup");
                groupNode.setAttrValue("name", this.tableNameText.getText());
                dataDict.add(groupNode);
            }
            int i2 = 0;
            while (i2 < this.tableNode.getChilds().size()) {
                XMLNode columnNode = (XMLNode)this.tableNode.getChilds().elementAt(i2);
                if ("column".equals(columnNode.getNodeName())) {
                    String refId = columnNode.getAttrValue("dataName");
                    XMLNode dataElement = dataDict.findChildNodeWithAttrValue("dataElement", "id", refId);
                    XMLNode dataCollection = dataDict.findChildNodeWithAttrValue("dataCollection", "id", refId);
                    if (dataElement == null && dataCollection == null) {
                        XMLNode node = new XMLNode("dataElement");
                        node.setAttrValue("id", refId);
                        node.setAttrValue("label", refId);
                        groupNode.add(node);
                    }
                }
                ++i2;
            }
            String icollName = this.tableNode.getAttrValue("iCollName");
            XMLNode dataCollection = dataDict.findChildNodeWithAttrValue("dataCollection", "id", icollName);
            if (dataCollection != null) {
                boolean result_1 = MessageDialog.openQuestion((Shell)this.getShell(), (String)"\u6570\u636e\u96c6\u5408\u6ce8\u5165", (String)("\u6570\u636e\u96c6\u5408" + icollName + "\u5df2\u5b58\u5728\uff0c\u662f\u5426\u66f4\u65b0\uff1f"));
                if (!result_1) {
                    return;
                }
                dataCollection.removeAllChilds();
            } else {
                dataCollection = new XMLNode("dataCollection");
                dataCollection.setAttrValue("id", icollName);
                dataCollection.setAttrValue("label", icollName);
                groupNode.add(dataCollection);
            }
            int i3 = 0;
            while (i3 < this.tableNode.getChilds().size()) {
                XMLNode columnNode = (XMLNode)this.tableNode.getChilds().elementAt(i3);
                if ("column".equals(columnNode.getNodeName())) {
                    String refId = columnNode.getAttrValue("dataName");
                    XMLNode refNode = new XMLNode("refData");
                    refNode.setAttrValue("refId", refId);
                    dataCollection.add(refNode);
                }
                ++i3;
            }
            IDEContent.saveSettingNode(this.project, 0);
            this.updateTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLNode getTableNode() {
        if (this.tableNode == null) {
            try {
                XMLLoader xmlLoader2 = new XMLLoader();
                xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
                FileEditorInput fi = (FileEditorInput)this.input;
                fi.getFile().getContents();
                this.tableNode = (XMLNode)xmlLoader2.loadXMLContent(fi.getFile().getContents());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tableNode;
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLNode) {
                XMLNode node = (XMLNode)inputElement;
                ArrayList<XMLNode> result = new ArrayList<XMLNode>();
                int i = 0;
                while (i < node.getChilds().size()) {
                    XMLNode child = (XMLNode)node.getChilds().elementAt(i);
                    if ("column".equals(child.getNodeName())) {
                        result.add(child);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            XMLNode node = (XMLNode)element;
            if (columnIndex == 0) {
                return node.getAttrValue("columnName");
            }
            if (columnIndex == 1) {
                return node.getAttrValue("dataName");
            }
            if (columnIndex == 2) {
                return node.getAttrValue("columnType");
            }
            if (columnIndex == 3) {
                String str = node.getAttrValue("isSequence");
                if (str == null) {
                    str = "false";
                }
                return str;
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

