/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.TellerProjectBuilder;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.client.teller.TellerCSHeadPanel;
import com.ecc.ide.editor.flow.OpFlowFramePanel;
import com.ecc.ide.editor.format.FormatsEditPanel;
import com.ecc.ide.editor.function.FunctionEditPanel;
import com.ecc.ide.editor.pattern.PatternMainPanel;
import com.ecc.ide.editor.project.ProjectMainPanel;
import com.ecc.ide.editor.project.ProjectSettingsPanel;
import com.ecc.ide.editor.service.ServiceMainPanel;
import com.ecc.ide.editor.statemachine.StateMachineFramePanel;
import com.ecc.ide.editor.teller.msr.TellerMSRDefinePanel;
import com.ecc.ide.editor.teller.passbook.TellerPassbookDefinePanel;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.popup.actions.Messages;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class TellerClientSettingsEditor
extends MultiPageEditorPart
implements ContentChangedListener,
BuildProblemReporter {
    private IProject project;
    ProjectMainPanel projectMainPanel;
    ProjectSettingsPanel cltSettingsPanel;
    OpFlowFramePanel cltFlowPanel;
    StateMachineFramePanel stateMachinePanel;
    PatternMainPanel tellerPatternPanel;
    FunctionEditPanel functionPanel;
    TellerCSHeadPanel csHeadpanel;
    private TellerPassbookDefinePanel tellerPassbookDefinePanel;
    private TellerMSRDefinePanel tellerMSRDefinePanel;
    private boolean isChanged = false;
    private IDEProjectSettings prjSettings;
    private EditorProfile cltActionProfile;
    private EditorProfile cltServiceProfile;
    private EditorProfile cltTaskProfile;
    private int changeLen = 30;
    private int[] changedProfileFiles = new int[this.changeLen];
    private int[] changedSettingsFiles = new int[this.changeLen];
    int curProLen = 0;
    int curSetLen = 0;
    private Hashtable settingNodes = new Hashtable();

    void createPrjMainSettingsPage() {
        try {
            this.projectMainPanel = new ProjectMainPanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.projectMainPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.project_Expands_1"));
            this.cltActionProfile = IDEProfile.getEditorProfile(this.project, 9);
            this.cltServiceProfile = IDEProfile.getEditorProfile(this.project, 14);
            this.cltTaskProfile = IDEProfile.getEditorProfile(this.project, 18);
            this.cltActionProfile = (EditorProfile)this.cltActionProfile.clone();
            this.cltServiceProfile = (EditorProfile)this.cltServiceProfile.clone();
            this.cltTaskProfile = (EditorProfile)this.cltTaskProfile.clone();
            this.projectMainPanel.addEditorProfile(Messages.getString("TellerClientSettingsEditor.Teller_Client_Flow_1"), this.cltActionProfile);
            this.projectMainPanel.addEditorProfile(Messages.getString("TellerClientSettingsEditor.Client_Service_2"), this.cltServiceProfile);
            this.projectMainPanel.addEditorProfile(Messages.getString("TellerClientSettingsEditor.Task_property_3"), this.cltTaskProfile);
            this.projectMainPanel.setFunctionProfile(IDEProfile.getEditorProfile(this.project, 16));
            this.projectMainPanel.setFunctionXMLNode(IDEContent.getSettingNode(this.project, 16));
            this.projectMainPanel.addContentChangedListener(this, this.project);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createPrjClientServiceSettingsPage() {
        try {
            ServiceMainPanel cltServicePanel = new ServiceMainPanel(this.getContainer(), 0, null);
            cltServicePanel.setRootPath(this.project.getLocation().toString());
            int index = this.addPage((Control)cltServicePanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Client_Service_Defines_6"));
            cltServicePanel.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 14));
            XMLNode svcNode = IDEContent.getSettingNode(this.project, 13);
            svcNode = (XMLNode)svcNode.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(13), svcNode);
            svcNode.addContentChangedListener(this, this.project, 13);
            cltServicePanel.setServiceXMLNode(svcNode);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createClientFlowPage() {
        try {
            this.cltFlowPanel = new OpFlowFramePanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.cltFlowPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Teller_Client_Flow_8"));
            EditorProfile profile = IDEProfile.getEditorProfile(this.project, 9);
            this.cltFlowPanel.setEditorProfile(profile);
            XMLNode flow = IDEContent.getSettingNode(this.project, 10);
            flow = (XMLNode)flow.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(10), flow);
            flow.addContentChangedListener(this, this.project, 10);
            this.cltFlowPanel.setXMLNode(flow);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    private void createClientStateMachinePage() {
        try {
            this.stateMachinePanel = new StateMachineFramePanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.stateMachinePanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.StateMachine_Define_1"));
            EditorProfile dataProfile = IDEProfile.getEditorProfile(this.project, 1);
            XMLNode dataDictionary = IDEContent.getSettingNode(this.project, 0);
            this.stateMachinePanel.setDataEditorProfile(dataProfile);
            this.stateMachinePanel.setDataDictionary(dataDictionary);
            this.stateMachinePanel.setCommonServiceNode(IDEContent.getSettingNode(this.project, 12));
            this.stateMachinePanel.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            this.stateMachinePanel.setStateEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            this.stateMachinePanel.setCommonStates(IDEContent.getSettingNode(this.project, 24));
            XMLNode state = IDEContent.getSettingNode(this.project, 22);
            state = (XMLNode)state.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(22), state);
            state.addContentChangedListener(this, this.project, 22);
            this.stateMachinePanel.setCommonStateMachine(state);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createClientPrjSettingsPage() {
        try {
            this.cltSettingsPanel = new ProjectSettingsPanel(this.getContainer(), 0);
            this.cltSettingsPanel.setEditorProfile(IDEProfile.getEditorProfile(this.project, 0));
            XMLNode content = IDEContent.getSettingNode(this.project, 6);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(6), content);
            content.addContentChangedListener(this, this.project, 6);
            this.cltSettingsPanel.setXMLContent(content);
            int index = this.addPage((Control)this.cltSettingsPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Client_Server_Settings_10"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createClientPatternPage() {
        try {
            this.tellerPatternPanel = new PatternMainPanel(this.getContainer(), 0);
            this.tellerPatternPanel.setPatternEditorProfile(IDEProfile.getEditorProfile(this.project, 15));
            this.tellerPatternPanel.setDataEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            this.tellerPatternPanel.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            XMLNode content = IDEContent.getSettingNode(this.project, 15);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(15), content);
            content.addContentChangedListener(this, this.project, 15);
            this.tellerPatternPanel.setPatternXMLNode(content);
            int index = this.addPage((Control)this.tellerPatternPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Pattern_Define_12"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    void createClientFunctionPage() {
        try {
            this.functionPanel = new FunctionEditPanel(this.getContainer(), 0);
            this.functionPanel.setEditorProfile(IDEProfile.getEditorProfile(this.project, 16));
            XMLNode content = IDEContent.getSettingNode(this.project, 16);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(16), content);
            content.addContentChangedListener(this, this.project, 16);
            this.functionPanel.setXMLContent(content);
            int index = this.addPage((Control)this.functionPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Function_Define_14"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    protected void createPages() {
        this.createPrjMainSettingsPage();
        this.createTaskManagePage();
        this.createClientFlowPage();
        this.createClientStateMachinePage();
        this.createClientPatternPage();
        this.createClientFunctionPage();
        this.createClientPrjSettingsPage();
        this.createPrjClientServiceSettingsPage();
        this.createClientCSHeadPage();
        this.createGenFormatsPage();
        this.createPassbookPage();
        this.createMSRPage();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
    }

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.curProLen) {
            IDEProfile.saveEditorProfile(this.project, this.changedProfileFiles[i]);
            if (this.changedProfileFiles[i] == 9) {
                IDEProfile.saveEditorProfile(this.project, this.changedProfileFiles[i], this.cltActionProfile);
            } else if (this.changedProfileFiles[i] == 14) {
                IDEProfile.saveEditorProfile(this.project, this.changedProfileFiles[i], this.cltServiceProfile);
            } else if (this.changedProfileFiles[i] == 18) {
                IDEProfile.saveEditorProfile(this.project, this.changedProfileFiles[i], this.cltTaskProfile);
            }
            ++i;
        }
        i = 0;
        while (i < this.curSetLen) {
            IDEContent.saveSettingNode(this.project, this.changedSettingsFiles[i], (XMLNode)this.settingNodes.get(IDEConstance.getSettingFileName(this.changedSettingsFiles[i])));
            ++i;
        }
        this.curProLen = 0;
        this.curSetLen = 0;
        if (ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("autoBuild")) {
            this.buildTellerClientSettings();
        }
        this.isChanged = false;
        this.firePropertyChange(257);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
        this.project = ((FileEditorInput)editorInput).getFile().getProject();
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
            this.prjSettings = new IDEProjectSettings(prjSettingsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
        if (event == null) {
            return;
        }
        if (event.getSource() != null && event.getSource() instanceof EditorProfile) {
            int settingsType = -1;
            if (event.getSource() == this.cltActionProfile) {
                settingsType = 9;
            } else if (event.getSource() == this.cltServiceProfile) {
                settingsType = 14;
            } else if (event.getSource() == this.cltTaskProfile) {
                settingsType = 18;
            }
            if (settingsType == -1) {
                return;
            }
            int i = 0;
            while (i < this.curProLen) {
                if (this.changedProfileFiles[i] == settingsType) break;
                ++i;
            }
            if (i == this.curProLen) {
                this.changedProfileFiles[this.curProLen++] = settingsType;
            }
        } else {
            int settingsType = event.getSourceType();
            int i = 0;
            while (i < this.curSetLen) {
                if (this.changedSettingsFiles[i] == settingsType) break;
                ++i;
            }
            if (i == this.curSetLen) {
                this.changedSettingsFiles[this.curSetLen++] = settingsType;
            }
        }
    }

    public void reportProblem(int type, String msg, String detail) {
        String detailMsg = msg;
        if (detail != null) {
            detailMsg = detail;
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), "", "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, fileName);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    void createClientCSHeadPage() {
        try {
            this.csHeadpanel = new TellerCSHeadPanel(this.getContainer(), 0);
            this.csHeadpanel.setEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            XMLNode node = IDEContent.getSettingNode(this.project, 0);
            this.csHeadpanel.setDataDictionary(node);
            XMLNode content = IDEContent.getSettingNode(this.project, 17);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(17), content);
            content.addContentChangedListener(this, this.project, 17);
            this.csHeadpanel.setXMLContent(content);
            int index = this.addPage((Control)this.csHeadpanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Client_Server_Format_Head_18"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    private void createGenFormatsPage() {
        try {
            FormatsEditPanel fmtsPanel = new FormatsEditPanel(this.getContainer(), 0);
            int index = this.addPage((Control)fmtsPanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.Formats_1"));
            fmtsPanel.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            fmtsPanel.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            fmtsPanel.setPkgTypeXMLNode(IDEContent.getSettingNode(this.project, 14));
            XMLNode content = IDEContent.getSettingNode(this.project, 26);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(26), content);
            content.addContentChangedListener(this, this.project, 26);
            fmtsPanel.setFormatSettings(content);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    private void createPassbookPage() {
        try {
            this.tellerPassbookDefinePanel = new TellerPassbookDefinePanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.tellerPassbookDefinePanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.passbook"));
            this.tellerPassbookDefinePanel.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            EditorProfile dataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.tellerPassbookDefinePanel.setDataEditorProfile(dataProfile);
            XMLNode functionNode = IDEContent.getSettingNode(this.project, 16);
            this.tellerPassbookDefinePanel.setFunctionNode(functionNode);
            this.tellerPassbookDefinePanel.setFunctionProfile(IDEProfile.getEditorProfile(this.project, 16));
            XMLNode patternnode = IDEContent.getSettingNode(this.project, 15);
            this.tellerPassbookDefinePanel.setPatternNode(patternnode);
            this.tellerPassbookDefinePanel.setPatternProfile(IDEProfile.getEditorProfile(this.project, 15));
            this.tellerPassbookDefinePanel.setViewEditorProfile(IDEProfile.getEditorProfile(this.project, 12));
            this.tellerPassbookDefinePanel.setRootPath(this.project.getLocation().toString());
            XMLNode content = IDEContent.getSettingNode(this.project, 31);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(31), content);
            content.addContentChangedListener(this, this.project, 31);
            this.tellerPassbookDefinePanel.setXMLContent(content);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    private void createMSRPage() {
        try {
            this.tellerMSRDefinePanel = new TellerMSRDefinePanel(this.getContainer(), 0);
            int index = this.addPage((Control)this.tellerMSRDefinePanel);
            this.setPageText(index, Messages.getString("TellerClientSettingsEditor.MSR"));
            this.tellerMSRDefinePanel.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            EditorProfile dataProfile = IDEProfile.getEditorProfile(this.project, 1);
            this.tellerMSRDefinePanel.setDataEditorProfile(dataProfile);
            this.tellerMSRDefinePanel.setViewEditorProfile(IDEProfile.getEditorProfile(this.project, 28));
            this.tellerMSRDefinePanel.setRootPath(this.project.getLocation().toString());
            XMLNode content = IDEContent.getSettingNode(this.project, 32);
            content = (XMLNode)content.clone();
            this.settingNodes.put(IDEConstance.getSettingFileName(32), content);
            content.addContentChangedListener(this, this.project, 32);
            this.tellerMSRDefinePanel.setXMLContent(content);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
    }

    public void initializeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 6);
            if (node != null) {
                node.addContentChangedListener(this, this.project, 6);
            }
            if ((node = IDEContent.getSettingNode(this.project, 10)) != null) {
                node.addContentChangedListener(this, this.project, 10);
            }
            if ((node = IDEContent.getSettingNode(this.project, 13)) != null) {
                node.addContentChangedListener(this, this.project, 13);
            }
            if ((node = IDEContent.getSettingNode(this.project, 17)) != null) {
                node.addContentChangedListener(this, this.project, 17);
            }
            if ((node = IDEContent.getSettingNode(this.project, 22)) != null) {
                node.addContentChangedListener(this, this.project, 22);
            }
            if ((node = IDEContent.getSettingNode(this.project, 24)) != null) {
                node.addContentChangedListener(this, this.project, 24);
            }
            if ((node = IDEContent.getSettingNode(this.project, 26)) != null) {
                node.addContentChangedListener(this, this.project, 26);
            }
            if ((node = IDEContent.getSettingNode(this.project, 16)) != null) {
                node.addContentChangedListener(this, this.project, 26);
            }
            if ((node = IDEContent.getSettingNode(this.project, 31)) != null) {
                node.addContentChangedListener(this, this.project, 31);
            }
            if ((node = IDEContent.getSettingNode(this.project, 32)) != null) {
                node.addContentChangedListener(this, this.project, 32);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    public void removeContentChangedListener() {
        try {
            XMLNode node = IDEContent.getSettingNode(this.project, 6);
            if (node != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 10)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 13)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 17)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 22)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 24)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 26)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 16)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 31)) != null) {
                node.removeContentChangedListener(this);
            }
            if ((node = IDEContent.getSettingNode(this.project, 32)) != null) {
                node.removeContentChangedListener(this);
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
    }

    private void buildTellerClientSettings() {
        this.reportProblem(0, Messages.getString("BuildTellerProjectAction.build_Teller_Project......_1"), "", "", null);
        TellerProjectBuilder builder = new TellerProjectBuilder();
        builder.setOutputPath(this.project.getLocation() + "/" + this.prjSettings.getWebContentPath() + "/tellerClient");
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setProblemReporter(this);
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            builder.setFlowEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 14));
            builder.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            builder.setFlow(IDEContent.getSettingNode(this.project, 10));
            builder.setMsgHeader(IDEContent.getSettingNode(this.project, 17));
            builder.setPackageType(IDEContent.getSettingNode(this.project, 14));
            builder.setService(IDEContent.getSettingNode(this.project, 13));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            builder.setStateEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setCommonStates(IDEContent.getSettingNode(this.project, 24));
            builder.setCommonStateMachine(IDEContent.getSettingNode(this.project, 22));
            builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
            builder.setFmtsNode(IDEContent.getSettingNode(this.project, 26));
            builder.buildProject();
            XMLNode settingsNode = IDEContent.getSettingNode(this.project, 1);
            EditorProfile serviceProfile = IDEProfile.getEditorProfile(this.project, 13);
            this.setServiceSettings(settingsNode, serviceProfile);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
        try {
            this.project.getFolder(String.valueOf(this.prjSettings.getWebContentPath()) + "/tellerClient").refreshLocal(1, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.reportProblem(0, Messages.getString("BuildTellerProjectAction.build_Teller_Project_finished._4"), "", "", null);
    }

    void createTaskManagePage() {
    }

    private void setServiceSettings(XMLNode settingsNode, EditorProfile serviceProfile) {
        XMLNode node = settingsNode.findChildNode("kColl", "settings");
        XMLNode tagsNode = node.findChildNode("kColl", "tags");
        XMLNode svcNode = tagsNode.findChildNode("kColl", "services");
        Vector catalogs = serviceProfile.getCagalogs();
        if (catalogs == null) {
            return;
        }
        tagsNode.remove(svcNode);
        int i = 0;
        while (i < catalogs.size()) {
            ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
            int k = 0;
            while (k < catalog.getElements().size()) {
                Element element = (Element)catalog.getElements().elementAt(k);
                if (element.getImplClass() != null) {
                    String elementName = element.getElementName();
                    XMLNode elementSettingNode = svcNode.findChildNode(elementName);
                    if (elementSettingNode == null) {
                        elementSettingNode = new XMLNode();
                        elementSettingNode.setNodeName("field");
                        elementSettingNode.setAttrValue("id", elementName);
                        svcNode.add(elementSettingNode);
                    }
                    elementSettingNode.setAttrValue("value", element.getImplClass());
                }
                ++k;
            }
            ++i;
        }
        tagsNode.add(svcNode);
    }

    public void dispose() {
        super.dispose();
    }
}

