/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BIZBuilder;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.HTMLTransactionBuilder;
import com.ecc.ide.builder.MCITransactionBuilder;
import com.ecc.ide.builder.MVCBuilder;
import com.ecc.ide.builder.TellerTransactionBuilder;
import com.ecc.ide.builder.WFBuilder;
import com.ecc.ide.builder.WSDLBuilder;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.editors.IDEEditorListener;
import com.ecc.ide.plugin.editors.IDEPartListener;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.dataDict.DataDictionaryView;
import com.ecc.ide.popup.actions.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public abstract class TransactionEditor
extends EditorPart
implements ContentChangedListener,
BuildProblemReporter {
    public IDEEditorListener listener = null;
    protected boolean isChanged = false;
    public IProject project;
    protected String relativeFilePath;
    protected String projectRootPath;
    protected String targetPath;
    protected IDEProjectSettings prjSettings;
    protected String settingPath;
    protected String editingFileName;
    protected XMLNode trxNode;
    protected int editorType = 0;
    public static int MCI_TRX = 0;
    public static int TELLER_TRX = 1;
    public static int HTML_TRX = 2;
    public static int JSP_TEMPLET = 3;
    public static int HTML_LAYOUT = 4;
    public static int HTML_TASK = 5;
    public static int KJAVA_TRX = 6;
    public static int WML_TRX = 7;
    public static int MVC = 8;
    public static int EMP_BUSINESS = 9;
    public static int WF = 10;

    public void doSave(IProgressMonitor monitor) {
        this.listener.saving = true;
        if (this.trxNode != null) {
            FileEditorInput input2;
            StringBuffer strBuf = new StringBuffer();
            String encoding = IDEConstance.encoding;
            if (this.prjSettings.getSetXMLEncodeManually()) {
                this.trxNode.setEncoding(this.prjSettings.getXMLEncoding());
                encoding = this.prjSettings.getXMLEncoding();
            }
            this.trxNode.toXMLContent(0, strBuf);
            try {
                input2 = (FileEditorInput)this.getEditorInput();
                input2.getFile().setContents((InputStream)new ByteArrayInputStream(strBuf.toString().getBytes(encoding)), 1, null);
            }
            catch (Exception input2) {
                // empty catch block
            }
            try {
                input2 = (FileEditorInput)this.getEditorInput();
                IFile file = input2.getFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DataDictionaryView.refreshCtxDataView((IEditorPart)this);
        }
        this.isChanged = false;
        this.firePropertyChange(257);
        this.listener.saving = false;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.project = ((FileEditorInput)input).getFile().getProject();
        this.relativeFilePath = ((FileEditorInput)input).getFile().getProjectRelativePath().toString();
        FileEditorInput finput = (FileEditorInput)this.getEditorInput();
        this.editingFileName = finput.getFile().getName();
        this.setPartName(this.editingFileName);
        this.setTitleToolTip(String.valueOf(this.project.getLocation().toString()) + "/" + finput.getFile().getName());
        this.editingFileName = String.valueOf(this.project.getLocation().toString()) + "/" + this.relativeFilePath;
        this.projectRootPath = this.project.getLocation().toString();
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
            this.prjSettings = new IDEProjectSettings(prjSettingsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IDEPartListener.init(site.getPage());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
    }

    public void setFocus() {
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        IDEContent.getConsole().println(msg);
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, this.relativeFilePath);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    public void reportProblem(int type, String msg, String detail) {
        String detailMsg = msg;
        if (detail != null) {
            detailMsg = detail;
        }
        BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), "", this.relativeFilePath);
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    private void buildTrasaction() {
        if (this.editorType == MCI_TRX) {
            this.buildMCITransaction();
        } else if (this.editorType == TELLER_TRX) {
            this.buildTellerTransaction();
        } else if (this.editorType == HTML_TRX || this.editorType == KJAVA_TRX || this.editorType == WML_TRX) {
            this.buildHTMLTransaction();
        } else if (this.editorType == MVC) {
            this.buildMVCModel();
        } else if (this.editorType == WF) {
            this.buildWFModel();
        } else if (this.editorType == EMP_BUSINESS) {
            this.buildEMPBusiness();
        }
    }

    private void buildEMPBusiness() {
        BIZBuilder builder = new BIZBuilder();
        WSDLBuilder wsdlBuilder = new WSDLBuilder();
        String classify = this.trxNode.getAttrValue("classify");
        this.targetPath = String.valueOf(this.prjSettings.getWebContentPath()) + "/" + this.prjSettings.getSettingsRootPath() + "/" + this.prjSettings.getBusinessLogicPath();
        String outPutPath = String.valueOf(this.projectRootPath) + "/" + this.targetPath;
        builder.setOutputPath(outPutPath);
        wsdlBuilder.setOutputPath(outPutPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
            wsdlBuilder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setProblemReporter(this);
        wsdlBuilder.setProblemReporter(this);
        builder.buildMCITransaction(this.editingFileName);
        this.reportProblem(0, Messages.getString("BuildMCITrxAction.Build_ECC_MCI_Trx_finished_!_3"), this.relativeFilePath, "", null);
        wsdlBuilder.buildMCITransaction(this.editingFileName);
        String trxCode = this.trxNode.getAttrValue("trxCode");
        try {
            this.project.getFolder(this.targetPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void buildMCITransaction() {
        MCITransactionBuilder builder = new MCITransactionBuilder();
        String classify = this.trxNode.getAttrValue("classify");
        this.targetPath = String.valueOf(this.prjSettings.getWebContentPath()) + "/" + this.prjSettings.getSettingsRootPath() + "/" + this.prjSettings.getBusinessLogicPath();
        String outPutPath = String.valueOf(this.projectRootPath) + "/" + this.targetPath;
        builder.setOutputPath(outPutPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setProblemReporter(this);
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            builder.setFlowEditorProfile(ModuleUtility.getActionFlowProfile(this.project));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 13));
            builder.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            builder.setFlow(IDEContent.getSettingNode(this.project, 5));
            builder.setHostSettings(IDEContent.getSettingNode(this.project, 11));
            builder.setPackageType(IDEContent.getSettingNode(this.project, 14));
            builder.setChannelSettingsNode(IDEContent.getSettingNode(this.project, 19));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            builder.setStateEditorProfile(ModuleUtility.getActionFlowProfile(this.project));
            builder.setCommonStates(IDEContent.getSettingNode(this.project, 23));
            builder.setCommonStateMachine(IDEContent.getSettingNode(this.project, 21));
            builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", null);
        }
        builder.buildMCITransaction(this.editingFileName);
        this.reportProblem(0, Messages.getString("BuildMCITrxAction.Build_ECC_MCI_Trx_finished_!_3"), this.relativeFilePath, "", null);
        String trxCode = this.trxNode.getAttrValue("trxCode");
        try {
            this.project.getFolder(this.targetPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void buildTellerTransaction() {
        TellerTransactionBuilder builder = new TellerTransactionBuilder();
        builder.setProblemReporter(this);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            builder.setFlowEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 14));
            builder.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            builder.setFlow(IDEContent.getSettingNode(this.project, 10));
            builder.setFmtHeader(IDEContent.getSettingNode(this.project, 17));
            builder.setPackageType(IDEContent.getSettingNode(this.project, 14));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            builder.setStateEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setCommonStates(IDEContent.getSettingNode(this.project, 24));
            builder.setCommonStateMachine(IDEContent.getSettingNode(this.project, 22));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
        this.projectRootPath = this.project.getLocation().toString();
        String webContentPath = this.prjSettings.getWebContentPath();
        String rootPath = String.valueOf(this.projectRootPath) + "/" + webContentPath + "/tellerClient/";
        String savingPath = String.valueOf(this.projectRootPath) + "/" + webContentPath + "/tellerClient/operations";
        builder.setOutputPath(savingPath);
        builder.buildTellerTransaction(this.editingFileName);
        this.reportProblem(0, Messages.getString("BuildTellerTrxAction.Build_ECC_Teller_Transaction_finished_!_3"), this.relativeFilePath, "", null);
        builder.setOutputPath(String.valueOf(rootPath) + "views");
        builder.buildTellerView(this.editingFileName);
        this.reportProblem(0, Messages.getString("BuildTellerTrxAction.Build_ECC_Teller_View_finished_!_6"), this.relativeFilePath, "", null);
        builder.setOutputPath(String.valueOf(rootPath) + "receipts");
        builder.buildTellerReceipt(this.editingFileName);
        this.reportProblem(0, Messages.getString("BuildTellerTrxAction.Build_ECC_Teller_Receipt_finished_!_9"), this.relativeFilePath, "", null);
        this.addToTaskInfo(this.trxNode);
        this.reportProblem(0, Messages.getString("BuildTellerTrxAction.Add_Teller_Transaction_to_TaskInfo_finished_!_11"), this.relativeFilePath, "", null);
        try {
            this.project.getFolder(rootPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void buildMVCModel() {
        MVCBuilder builder = new MVCBuilder();
        String settingsPath = String.valueOf(this.prjSettings.getWebContentPath()) + "/WEB-INF";
        String savingPath = String.valueOf(this.projectRootPath) + "/" + settingsPath;
        builder.setOutputPath(savingPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        try {
            builder.setProblemReporter(this);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
        builder.buildMVCModel(this.editingFileName);
        this.reportProblem(BuildProblemObject.MESSAGE, "Build the MVC model finished!", this.relativeFilePath, "", null);
        try {
            this.project.getFolder(settingsPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void buildWFModel() {
        WFBuilder builder = new WFBuilder();
        String settingsPath = String.valueOf(this.prjSettings.getWebContentPath()) + "/WEB-INF";
        String savingPath = String.valueOf(this.projectRootPath) + "/" + settingsPath;
        builder.setOutputPath(savingPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        try {
            builder.setProblemReporter(this);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
        builder.buildWFModel(this.editingFileName);
        this.reportProblem(BuildProblemObject.MESSAGE, "Build the MVC model finished!", this.relativeFilePath, "", null);
        try {
            this.project.getFolder(settingsPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void buildHTMLTransaction() {
        HTMLTransactionBuilder builder = new HTMLTransactionBuilder();
        String settingsPath = String.valueOf(this.prjSettings.getWebContentPath()) + "/" + this.prjSettings.getSettingsRootPath();
        String appendPath = null;
        if (this.editorType == HTML_TRX) {
            appendPath = this.prjSettings.getHtmlLogicPath();
            builder.setJspPath(this.prjSettings.getHtmlJspPath());
        } else if (this.editorType == WML_TRX) {
            appendPath = this.prjSettings.getWmlLogicPath();
            builder.setJspPath(this.prjSettings.getWmlJspPath());
        } else if (this.editorType == KJAVA_TRX) {
            appendPath = this.prjSettings.getKjavaLogicPath();
            builder.setJspPath(this.prjSettings.getKJavaJspPath());
        }
        if (appendPath != null && appendPath.length() > 0) {
            settingsPath = String.valueOf(settingsPath) + "/" + appendPath;
        }
        String savingPath = String.valueOf(this.projectRootPath) + "/" + settingsPath;
        builder.setTargetPath(savingPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        try {
            XMLNode jsFunctionNode = IDEContent.getSettingNode(this.project, 20);
            builder.setJSFunctionNode(jsFunctionNode);
            builder.setProblemReporter(this);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e, "", "", e);
        }
        builder.buildHtmlTransaction(this.editingFileName);
        this.reportProblem(BuildProblemObject.MESSAGE, Messages.getString("BuildHtmlTrxAction.Build_ECC_Html_Trx_finished_!_3"), this.relativeFilePath, "", null);
        try {
            this.project.getFolder(settingsPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void addToTaskInfo(XMLNode TellerTrxNode) {
        try {
            String classify = null;
            classify = TellerTrxNode.getAttrValue("classify");
            String trxCode = TellerTrxNode.getAttrValue("trxCode");
            if (TellerTrxNode == null) {
                return;
            }
            XMLNode taskInfo = new XMLNode();
            taskInfo.setNodeName("TaskInfo");
            taskInfo.setAttrValue("transactionCode", trxCode);
            taskInfo.setAttrValue("name", TellerTrxNode.getAttrValue("trxName"));
            taskInfo.setAttrValue("longDescription", TellerTrxNode.getAttrValue("trxName"));
            taskInfo.setAttrValue("isXMLView", "true");
            taskInfo.setAttrValue("financialFlag", "false");
            taskInfo.setAttrValue("operationName", String.valueOf(trxCode) + "CltOp");
            XMLNode viewsNode = TellerTrxNode.getChild("views");
            int i = 0;
            while (viewsNode != null && i < viewsNode.getChilds().size()) {
                XMLNode viewNode = (XMLNode)viewsNode.getChilds().elementAt(i);
                String viewType = viewNode.getAttrValue("viewType");
                if (viewType != null) {
                    int inIdx = viewType.indexOf("Input");
                    int inOutIdx = viewType.indexOf("In/Out");
                    int outIdx = viewType.indexOf("Output");
                    if (inIdx != -1 || inOutIdx != -1) {
                        if (classify != null) {
                            taskInfo.setAttrValue("inputViewName", String.valueOf(classify) + "/" + trxCode + viewNode.getAttrValue("id"));
                        } else {
                            taskInfo.setAttrValue("inputViewName", String.valueOf(trxCode) + viewNode.getAttrValue("id"));
                        }
                    }
                    if (outIdx != -1) {
                        if (classify != null) {
                            taskInfo.setAttrValue("outputViewName", String.valueOf(classify) + "/" + trxCode + viewNode.getAttrValue("id"));
                        } else {
                            taskInfo.setAttrValue("outputViewName", String.valueOf(trxCode) + viewNode.getAttrValue("id"));
                        }
                    }
                }
                ++i;
            }
            XMLNode linkTasks = TellerTrxNode.getChild("trxLinks");
            if (linkTasks != null && linkTasks.getChilds() != null) {
                int i2 = 0;
                while (i2 < linkTasks.getChilds().size()) {
                    XMLNode linkTask = (XMLNode)linkTasks.getChilds().elementAt(i2);
                    XMLNode taskLink = new XMLNode();
                    taskInfo.add(taskLink);
                    taskLink.setNodeName("LinkTask");
                    Enumeration keys = linkTask.getAttrs().keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (key.equals("id")) continue;
                        taskLink.setAttrValue(key, linkTask.getAttrValue(key));
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            this.reportProblem(2, String.valueOf(Messages.getString("BuildTellerTrxAction.Failed_to_add_this_teller_trx_to_taskInfo_!_Exception___39")) + e, "", "", e);
        }
    }

    public String getGroupId() {
        return IDEContent.getGroupId(this.editingFileName);
    }
}

