/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.editors.jsp;

import com.ecc.ide.plugin.editors.jsp.ColorManager;
import com.ecc.ide.plugin.editors.jsp.IJSPColorConstants;
import com.ecc.ide.plugin.editors.jsp.JSPDoubleClickStrategy;
import com.ecc.ide.plugin.editors.jsp.JSPScanner;
import com.ecc.ide.plugin.editors.jsp.JSPTagScanner;
import com.ecc.ide.plugin.editors.jsp.NonRuleBasedDamagerRepairer;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JSPConfiguration
extends SourceViewerConfiguration {
    private JSPDoubleClickStrategy doubleClickStrategy;
    private JSPTagScanner tagScanner;
    private JSPScanner scanner;
    private ColorManager colorManager;

    public JSPConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new JSPDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected JSPScanner getXMLScanner() {
        if (this.scanner == null) {
            this.scanner = new JSPScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IJSPColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected JSPTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new JSPTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IJSPColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IJSPColorConstants.XML_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }
}

