/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.properties;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.ModuleDef;
import org.eclipse.core.resources.IProject;

public class IDEProjectSettings {
    public static final String DB_ORACLE = "ORACLE";
    public static final String DB_DB2 = "DB2";
    IProject project;
    XMLNode settingsNode;
    XMLNode propertiesNode;
    XMLNode modulesNode;

    public IDEProjectSettings(IProject project) {
        this.project = project;
        try {
            this.settingsNode = IDEContent.getSettingNode(project, 35);
            this.propertiesNode = this.settingsNode.getChild("properties");
            this.modulesNode = this.settingsNode.getChild("modules");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IDEProjectSettings(XMLNode settingsNode) {
        this.settingsNode = settingsNode;
        this.propertiesNode = settingsNode.getChild("properties");
        if (this.propertiesNode == null) {
            this.propertiesNode = new XMLNode("properties");
            settingsNode.add(this.propertiesNode);
        }
        this.modulesNode = settingsNode.getChild("modules");
    }

    public String getSettingValue(String key) {
        if (this.propertiesNode == null) {
            return null;
        }
        XMLNode propertyNode = this.propertiesNode.findChildNode(key);
        if (propertyNode == null) {
            return null;
        }
        return propertyNode.getAttrValue("value");
    }

    public String getSettingValueWithDefault(String key, String dftValue) {
        String value = this.getSettingValue(key);
        if (value == null) {
            return dftValue;
        }
        return value;
    }

    public void setPropertyValue(String key, String value) {
        if (this.propertiesNode == null) {
            return;
        }
        XMLNode propertyNode = this.propertiesNode.findChildNode(key);
        if (propertyNode == null) {
            propertyNode = new XMLNode("property");
            propertyNode.setAttrValue("id", key);
            this.propertiesNode.add(propertyNode);
        }
        propertyNode.setAttrValue("value", value);
    }

    public String getWebContentPath() {
        return this.getSettingValueWithDefault("WebRootPath", "WebContent");
    }

    public void setWebContentPath(String value) {
        this.setPropertyValue("WebRootPath", value);
    }

    public String getJspRootPath() {
        return this.getSettingValueWithDefault("JSPRootPath", "");
    }

    public void setJspRootPath(String value) {
        this.setPropertyValue("JSPRootPath", value);
    }

    public String getSettingsRootPath() {
        return this.getSettingValueWithDefault("rootPath", "WEB-INF/server");
    }

    public void setSettingsRootPath(String value) {
        this.setPropertyValue("rootPath", value);
    }

    public String getBusinessLogicPath() {
        return this.getSettingValueWithDefault("businessLogicPath", "operations");
    }

    public void setBusinessLogicPath(String value) {
        this.setPropertyValue("businessLogicPath", value);
    }

    public String getHtmlLogicPath() {
        return this.getSettingValueWithDefault("htmlBusinessLogicPath", "htmlTrans");
    }

    public void setHtmlLogicPath(String value) {
        this.setPropertyValue("htmlBusinessLogicPath", value);
    }

    public String getWmlLogicPath() {
        return this.getSettingValueWithDefault("wmlBusinessLogicPath", "wmlTrans");
    }

    public void setWmlLogicPath(String value) {
        this.setPropertyValue("wmlBusinessLogicPath", value);
    }

    public String getKjavaLogicPath() {
        return this.getSettingValueWithDefault("kjavaBusinessLogicPath", "kjavaTrans");
    }

    public String getAutoValidate() {
        return this.getSettingValueWithDefault("autoValidate", "false");
    }

    public String getConsoleUnable() {
        return this.getSettingValueWithDefault("ConsoleUnable", "false");
    }

    public String getAutoCompile() {
        return this.getSettingValueWithDefault("autoCompile", "true");
    }

    public void setKjavaLogicPath(String value) {
        this.setPropertyValue("kjavaBusinessLogicPath", value);
    }

    public String getHtmlJspPath() {
        return this.getSettingValueWithDefault("htmlJspRootPath", "");
    }

    public void setHtmlJspPath(String value) {
        this.setPropertyValue("htmlJspRootPath", value);
    }

    public String getWmlJspPath() {
        return this.getSettingValueWithDefault("wmlJspRootPath", "");
    }

    public void setWmlJspPath(String value) {
        this.setPropertyValue("wmlJspRootPath", value);
    }

    public String getKJavaJspPath() {
        return this.getSettingValueWithDefault("kjavaJspRootPath", "");
    }

    public void setKJavaJspPath(String value) {
        this.setPropertyValue("kjavaJspRootPath", value);
    }

    public boolean getSetXMLEncodeManually() {
        String value = this.getSettingValueWithDefault("manualSetXMLEncode", "false");
        return value.equalsIgnoreCase("true");
    }

    public void setSetXMLEncodeManually(String value) {
        this.setPropertyValue("manualSetXMLEncode", value);
    }

    public String getXMLEncoding() {
        String encoding = System.getProperty("file.encoding");
        return this.getSettingValueWithDefault("XMLEncode", encoding);
    }

    public void setXMLEncoding(String value) {
        this.setPropertyValue("XMLEncode", value);
    }

    public boolean getSetJSPEncodeManually() {
        String value = this.getSettingValueWithDefault("manualSetJSPEncode", "false");
        return value.equalsIgnoreCase("true");
    }

    public void setSetJSPEncodeManually(String value) {
        this.setPropertyValue("manualSetJSPEncode", value);
    }

    public String getJSPEncoding() {
        String encoding = System.getProperty("file.encoding");
        return this.getSettingValueWithDefault("JSPEncode", encoding);
    }

    public void setJSPEncoding(String value) {
        this.setPropertyValue("JSPEncode", value);
    }

    public boolean getUseIDELayout() {
        String value = this.getSettingValueWithDefault("useIDELayout", "false");
        return value.equalsIgnoreCase("true");
    }

    public void setUseIDELayout(String value) {
        this.setPropertyValue("useIDELayout", value);
    }

    public String getContentDivID() {
        return this.getSettingValueWithDefault("contentDivId", "");
    }

    public void setContentDivID(String value) {
        this.setPropertyValue("contentDivId", value);
    }

    public XMLNode getModules() {
        return this.modulesNode;
    }

    public void addModule(ModuleDef aModule) {
        if (this.modulesNode == null) {
            this.modulesNode = new XMLNode("modules");
        }
        XMLNode module = new XMLNode("module");
        module.setAttrValue("id", aModule.id);
        module.setAttrValue("srcFolder", aModule.srcFolder);
        this.modulesNode.add(module);
    }

    public void removeModule(ModuleDef aModule) {
    }

    public XMLNode getSettingsNode() {
        return this.settingsNode;
    }

    public String getSrcPath() {
        return this.getSettingValueWithDefault("JavaSourcePath", "src");
    }

    public void setSrcPath(String srcPath) {
        this.setPropertyValue("JavaSourcePath", srcPath);
    }

    public String getPrjVersion() {
        return this.getSettingValueWithDefault("PRJVersion", "1.1");
    }
}

