/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.views.Messages;
import com.ecc.ide.plugin.views.ProblemViewDialog;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class BuilderProblemView
extends ViewPart {
    private TableViewer viewer;
    private Action action1;
    private Action doubleClickAction;
    public static Display display;

    public void createPartControl(Composite parent) {
        display = parent.getShell().getDisplay();
        this.viewer = new TableViewer(parent, 66306);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(44);
        TableColumn tableColumn_1 = new TableColumn(table, 0);
        tableColumn_1.setWidth(221);
        tableColumn_1.setText(Messages.getString("BuilderProblemView.Description_1"));
        TableColumn tableColumn_3 = new TableColumn(table, 0);
        tableColumn_3.setWidth(120);
        tableColumn_3.setText(Messages.getString("BuilderProblemView.Project_2"));
        TableColumn tableColumn_4 = new TableColumn(table, 0);
        tableColumn_4.setWidth(100);
        tableColumn_4.setText(Messages.getString("BuilderProblemView.In_Folder_3"));
        TableColumn tableColumn_2 = new TableColumn(table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("BuilderProblemView.Location_4"));
        this.viewer.setContentProvider((IContentProvider)ECCIDEPlugin.getDefault().getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)ECCIDEPlugin.getDefault().getLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        String msg = ECCIDEPlugin.getDefault().getPreferenceString();
        BuildProblemObject obj = msg.startsWith("Error") ? new BuildProblemObject(BuildProblemObject.ERROR, "IDE preference Settings error", msg, "e-Channels MCI IDE", "", "") : new BuildProblemObject(BuildProblemObject.MESSAGE, "IDE preference settings message", msg, "e-Channels MCI IDE", "", "");
        ECCIDEPlugin.getDefault().addProblemElement(obj);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuilderProblemView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                ECCIDEPlugin.getDefault().clearProblemElement();
            }
        };
        this.action1.setText(Messages.getString("BuilderProblemView.Action_1_6"));
        this.action1.setToolTipText(Messages.getString("BuilderProblemView.remove_all_Items_7"));
        try {
            URL url = ECCIDEPlugin.getDefault().find((IPath)new Path("icons/clear_co.gif"));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.action1.setImageDescriptor(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = BuilderProblemView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                BuilderProblemView.this.showMessage((BuildProblemObject)obj);
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuilderProblemView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(BuildProblemObject obj) {
        String msg = obj.getMessageStr();
        ProblemViewDialog dlg = new ProblemViewDialog(this.viewer.getControl().getShell(), obj.getMessageType(), msg, obj.getDetailInfo());
        dlg.open();
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("BuilderProblemView.Sample_View_9"), (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

