/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.views.PrjViewTreePanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class PrjNodeSelectDialog
extends Dialog {
    public static final String TYPE_BIZGRP = "bizgrp";
    public static final String TYPE_BIZ = "biz";
    public static final String TYPE_MTX = "mtx";
    public static final String TYPE_JSP = "jsp";
    public static final String TYPE_GRD = "grd";
    public static final String TYPE_HTM = "htm";
    public static final String TYPE_HTML = "html";
    private Object rootObject = null;
    private String[] selectTypes = null;
    private PrjViewTreePanel treePanel = null;
    private List operationList = null;
    private PrjViewXMLNode result = null;
    private String title = "";
    private boolean singleFlag = true;

    public PrjNodeSelectDialog(Shell parentShell, Object root) {
        super(parentShell);
        this.rootObject = root;
    }

    public PrjNodeSelectDialog(Shell parentShell, Object root, String title) {
        super(parentShell);
        this.rootObject = root;
        this.title = title;
    }

    public PrjNodeSelectDialog(Shell parentShell, Object root, String title, boolean singleFlag) {
        super(parentShell);
        this.rootObject = root;
        this.title = title;
        this.singleFlag = singleFlag;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setLayoutData((Object)new GridData(1808));
        sashForm.setLayout((Layout)new GridLayout(2, true));
        this.treePanel = new PrjViewTreePanel((Composite)sashForm, 0, this.singleFlag);
        if (this.rootObject == null) {
            this.rootObject = ResourcesPlugin.getWorkspace();
        }
        if (this.selectTypes != null) {
            this.treePanel.addNodeFilter(this.selectTypes);
        }
        this.treePanel.setInput(this.rootObject);
        this.treePanel.setLayoutData(new GridData(1808));
        this.operationList = new List((Composite)sashForm, 2564);
        this.operationList.setLayoutData((Object)new GridData(1808));
        this.treePanel.getTreeViewer().getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PrjNodeSelectDialog.this.treePanel.getTreeViewer().getSelection();
                PrjViewXMLNode selectNode = (PrjViewXMLNode)selection.getFirstElement();
                IResource resource = (IResource)selectNode.obj;
                PrjNodeSelectDialog.this.operationList.removeAll();
                PrjNodeSelectDialog.this.operationList.setItems(PrjNodeSelectDialog.this.getOperationList(resource));
                PrjNodeSelectDialog.this.operationList.setSelection(0);
            }
        });
        if (TYPE_BIZ.equalsIgnoreCase(this.selectTypes[0])) {
            sashForm.setWeights(new int[]{1, 1});
        } else {
            int[] nArray = new int[2];
            nArray[0] = 1;
            sashForm.setWeights(nArray);
        }
        this.getShell().setText(this.title);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 375);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.treePanel.getTreeViewer().getSelection();
            if (this.singleFlag) {
                String[] selectOp;
                this.result = (PrjViewXMLNode)selection.getFirstElement();
                if (TYPE_BIZ.equals(this.result.getNodeName()) && (selectOp = this.operationList.getSelection()) != null && selectOp.length != 0) {
                    this.result.selectBizOp = selectOp[0];
                }
                if (TYPE_BIZGRP.equals(this.selectTypes[0])) {
                    XMLNode descNode = this.result.descNode;
                    if (descNode == null || !descNode.getNodeName().equals(this.selectTypes[0])) {
                        return;
                    }
                } else {
                    boolean flag = false;
                    int i = 0;
                    while (i < this.selectTypes.length) {
                        if (this.result.getNodeName().equals(this.selectTypes[i])) {
                            flag = true;
                        }
                        ++i;
                    }
                    if (!flag) {
                        return;
                    }
                }
            } else {
                Object[] nodes = selection.toArray();
                this.result = new PrjViewXMLNode("", "", null);
                int i = 0;
                while (i < nodes.length) {
                    this.result.add((PrjViewXMLNode)nodes[i]);
                    ++i;
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    public PrjViewXMLNode getResult() {
        return this.result;
    }

    public String[] getOperationList(IResource resource) {
        ArrayList<String> opList = new ArrayList<String>();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (!TYPE_BIZ.endsWith(file.getFileExtension())) {
                return null;
            }
            try {
                XMLLoader xmlLoader = new XMLLoader();
                xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
                XMLNode bizNode = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
                int i = 0;
                while (i < bizNode.getChilds().size()) {
                    XMLNode opNode = (XMLNode)bizNode.getChilds().elementAt(i);
                    if ("operation".equals(opNode.getNodeName())) {
                        opList.add(opNode.getAttrValue("id"));
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return opList.toArray(new String[0]);
    }

    public void setSelectTypes(String[] selectTypes) {
        this.selectTypes = selectTypes;
    }
}

