/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.plugin.views.PrjViewXMLNode;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PrjViewDragListener
implements DragSourceListener {
    private TreeViewer tv;

    public PrjViewDragListener(TreeViewer tv) {
        this.tv = tv;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.tv.getSelection();
        List selectionList = selection.toList();
        if (selectionList.size() < 0) {
            event.doit = false;
            return;
        }
        int i = 0;
        while (i < selectionList.size()) {
            PrjViewXMLNode node = (PrjViewXMLNode)selectionList.get(i);
            if (!this.canDrag(node)) {
                event.doit = false;
                break;
            }
            int j = i + 1;
            while (j < selectionList.size()) {
                PrjViewXMLNode otherNode = (PrjViewXMLNode)selectionList.get(j);
                if (node.getParent() != otherNode.getParent()) {
                    event.doit = false;
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean canDrag(PrjViewXMLNode node) {
        if (node.descNode == null) {
            return true;
        }
        String id = node.descNode.getNodeName();
        return !id.equals("project") && !id.equals(PrjViewXMLNode.BUSINESSNODE) && !id.equals(PrjViewXMLNode.DOCUMENTNODE) && !id.equals(PrjViewXMLNode.MVCNODE) && !id.equals(PrjViewXMLNode.COMMONNODE);
    }

    public void dragSetData(DragSourceEvent event) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        if (transfer.isSupportedType(event.dataType)) {
            transfer.setSelection(this.tv.getSelection());
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

