/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.views.actions.table.NewSingleTableAction;
import com.ecc.ide.plugin.views.actions.table.SingleTableData;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PrjViewDropListener
implements DropTargetListener {
    private TreeViewer tv;
    private List selectionList;

    public PrjViewDropListener(TreeViewer tv) {
        this.tv = tv;
    }

    public void dragLeave(DropTargetEvent event) {
        this.selectionList = null;
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        TextTransfer transfer2;
        IStructuredSelection selection = (IStructuredSelection)this.tv.getSelection();
        this.selectionList = selection.toList();
        event.feedback = 25;
        TreeItem item = (TreeItem)event.item;
        if (event.item == null || item.getData() == null) {
            event.detail = 1;
            return;
        }
        PrjViewXMLNode targetNode = (PrjViewXMLNode)item.getData();
        if (targetNode.obj == null || !(targetNode.obj instanceof IFolder)) {
            event.detail = 0;
            return;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        if (transfer.isSupportedType(event.currentDataType)) {
            int i = 0;
            while (i < this.selectionList.size()) {
                PrjViewXMLNode sourceNode = (PrjViewXMLNode)this.selectionList.get(i);
                if (!this.canDrop(sourceNode, targetNode)) {
                    event.detail = 0;
                    return;
                }
                ++i;
            }
            event.detail = 1;
        }
        if ((transfer2 = TextTransfer.getInstance()).isSupportedType(event.currentDataType)) {
            event.detail = 1;
            return;
        }
    }

    private boolean canDrop(PrjViewXMLNode sourceNode, PrjViewXMLNode targetNode) {
        if (targetNode.obj.equals(sourceNode.obj)) {
            return false;
        }
        PrjViewXMLNode parentNode = (PrjViewXMLNode)sourceNode.getParent();
        if (targetNode.obj.equals(parentNode.obj)) {
            return false;
        }
        IFolder folder = (IFolder)targetNode.obj;
        IFolder resource = null;
        if (sourceNode.obj instanceof IFolder) {
            resource = folder.getFolder(((IFolder)sourceNode.obj).getFullPath());
        } else if (sourceNode.obj instanceof IFile) {
            resource = folder.getFile(((IFile)sourceNode.obj).getFullPath());
        }
        return resource == null || !resource.exists();
    }

    public void drop(DropTargetEvent event) {
        TextTransfer transfer2;
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        if (transfer.isSupportedType(event.currentDataType)) {
            TreeItem item = (TreeItem)event.item;
            final PrjViewXMLNode targetNode = (PrjViewXMLNode)item.getData();
            IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
            final List selectionList = selection.toList();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.tv.getControl().getShell());
            IRunnableWithProgress op = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            PrjViewDropListener.this.moveFile(selectionList, targetNode, monitor);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            };
            try {
                pmd.run(false, false, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if ((transfer2 = TextTransfer.getInstance()).isSupportedType(event.currentDataType)) {
            String source = (String)event.data;
            TreeItem item = (TreeItem)event.item;
            PrjViewXMLNode targetNode = (PrjViewXMLNode)item.getData();
            if (!(targetNode.obj instanceof IFolder)) {
                return;
            }
            if (((IFolder)targetNode.obj).getLocation().toOSString().indexOf("designFiles\\tables") == -1) {
                return;
            }
            if (source.startsWith("tableName=")) {
                boolean result = MessageDialog.openConfirm(null, (String)"\u786e\u8ba4", (String)"\u786e\u8ba4\u6dfb\u52a0\u65b0\u7684\u8868\u6a21\u578b?");
                if (!result) {
                    return;
                }
                this.newTableFile(source, targetNode);
            }
        }
    }

    private void newTableFile(String content, PrjViewXMLNode targetNode) {
        try {
            SingleTableData tableData = new SingleTableData();
            String tableName = content.substring(10, content.indexOf("<"));
            String[] s = tableName.split(":");
            tableData.tableName = s[0];
            tableData.cnname = s.length > 1 ? s[1] : s[0];
            tableData.content = content = content.substring(content.indexOf("<"));
            tableData.project = targetNode.getProject();
            NewSingleTableAction action = new NewSingleTableAction(PrjViewPanel.getPrjViewPanel(), targetNode, tableData);
            action.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveFile(List selectionList, PrjViewXMLNode targetNode, IProgressMonitor monitor) throws CoreException {
        String[] dialogButtonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        MessageDialog msg = new MessageDialog(this.tv.getControl().getShell(), "title", null, "message", 2, dialogButtonLabels, 0);
        boolean toggle = false;
        int retValue = -1;
        int i = 0;
        while (i < selectionList.size()) {
            block15: {
                PrjViewXMLNode sourceNode;
                block18: {
                    IFolder targetFolder;
                    IFolder sourceFolder;
                    block19: {
                        IFolder folder;
                        block16: {
                            IFile targetFile;
                            IFile sourceFile;
                            block17: {
                                sourceNode = (PrjViewXMLNode)selectionList.get(i);
                                if (!(targetNode.obj instanceof IFolder)) break block15;
                                folder = (IFolder)targetNode.obj;
                                if (!(sourceNode.obj instanceof IFile)) break block16;
                                sourceFile = (IFile)sourceNode.obj;
                                targetFile = folder.getFile(sourceFile.getName());
                                if (targetFile.exists()) break block17;
                                sourceFile.move(targetFile.getFullPath(), false, false, monitor);
                                break block16;
                            }
                            if (!toggle) {
                                retValue = msg.open();
                            }
                            switch (retValue) {
                                case 0: {
                                    targetFile.delete(true, false, monitor);
                                    sourceFile.move(targetFile.getFullPath(), false, false, monitor);
                                    break;
                                }
                                case 1: {
                                    targetFile.delete(true, false, monitor);
                                    sourceFile.move(targetFile.getFullPath(), false, false, monitor);
                                    toggle = true;
                                    break;
                                }
                                case 2: {
                                    break block15;
                                }
                                case 3: {
                                    toggle = true;
                                }
                            }
                        }
                        if (!(sourceNode.obj instanceof IFolder)) break block18;
                        sourceFolder = (IFolder)sourceNode.obj;
                        targetFolder = folder.getFolder(sourceFolder.getName());
                        if (targetFolder.exists()) break block19;
                        sourceFolder.move(targetFolder.getFullPath(), false, false, monitor);
                        break block18;
                    }
                    if (!toggle) {
                        retValue = msg.open();
                    }
                    switch (retValue) {
                        case 0: {
                            targetFolder.delete(true, false, monitor);
                            sourceFolder.move(targetFolder.getFullPath(), false, false, monitor);
                            break;
                        }
                        case 1: {
                            targetFolder.delete(true, false, monitor);
                            sourceFolder.move(targetFolder.getFullPath(), false, false, monitor);
                            toggle = true;
                            break;
                        }
                        case 2: {
                            break block15;
                        }
                        case 3: {
                            toggle = true;
                            break;
                        }
                    }
                }
                this.tv.refresh((Object)targetNode, true);
                this.tv.refresh((Object)((PrjViewXMLNode)sourceNode.getParent()), true);
            }
            ++i;
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dragEnter(DropTargetEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.tv.getSelection();
        this.selectionList = selection.toList();
    }
}

