/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.plugin.views.PrjViewDragListener;
import com.ecc.ide.plugin.views.PrjViewDropListener;
import com.ecc.ide.plugin.views.PrjViewTreePanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.views.actions.PrjViewActionGroup;
import java.util.HashMap;
import org.apache.tools.ant.BuildListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PrjViewPanel
extends Composite {
    private PrjViewTreePanel prjViewTreePanel = null;
    private DragSource source;
    private DropTarget target;
    private static PrjViewPanel prjViewPanel = null;
    private DropTarget dropTarget;

    public PrjViewPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        prjViewPanel = this;
    }

    public static PrjViewPanel getPrjViewPanel() {
        return prjViewPanel;
    }

    public void reload() {
        try {
            StructuredSelection select = (StructuredSelection)this.prjViewTreePanel.getTreeViewer().getSelection();
            PrjViewXMLNode node = (PrjViewXMLNode)select.getFirstElement();
            this.reload(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reload(PrjViewXMLNode node) {
        final PrjViewXMLNode anode = node;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (anode == null || PrjViewXMLNode.PROJECTNODE.equals(anode.getNodeName())) {
                        PrjViewXMLNode.nodesMap = new HashMap();
                        PrjViewXMLNode.refreshDescFile();
                        PrjViewPanel.this.prjViewTreePanel.setInput(ResourcesPlugin.getWorkspace());
                        IDEContent.refreshSettings();
                        IDEProfile.refreshSettings();
                    } else {
                        PrjViewPanel.this.prjViewTreePanel.getTreeViewer().refresh((Object)anode);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.getDisplay().asyncExec(runnable);
    }

    private void initialize() {
        this.setSize(new Point(300, 200));
        this.setLayout((Layout)new FillLayout());
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayout((Layout)new FillLayout());
        this.prjViewTreePanel = new PrjViewTreePanel(composite_1, 0, false);
        this.prjViewTreePanel.setInput(ResourcesPlugin.getWorkspace());
        this.prjViewTreePanel.getTreeViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                try {
                    TreeItem[] items = PrjViewPanel.this.prjViewTreePanel.getTreeViewer().getTree().getSelection();
                    PrjViewXMLNode node = (PrjViewXMLNode)items[0].getData();
                    if (node.obj instanceof IFolder) {
                        return;
                    }
                    PrjViewPanel.this.openSelectedResource(node, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        PrjViewActionGroup group = new PrjViewActionGroup(this);
        this.setDragAndDrop();
    }

    public TreeViewer getTreeViewer() {
        return this.prjViewTreePanel.getTreeViewer();
    }

    public void openSelectedResource(PrjViewXMLNode node, BuildListener aListener) {
        if (node == null) {
            return;
        }
        final BuildListener listener = aListener;
        final PrjViewXMLNode tempnode = node;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                tempnode.openEditor(listener);
            }
        });
    }

    private void setDragAndDrop() {
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getInstance()};
        this.source = new DragSource((Control)this.prjViewTreePanel.getTreeViewer().getTree(), 3);
        this.source.setTransfer(types);
        this.source.addDragListener((DragSourceListener)new PrjViewDragListener(this.prjViewTreePanel.getTreeViewer()));
        this.target = new DropTarget((Control)this.prjViewTreePanel.getTreeViewer().getTree(), 3);
        Transfer[] types2 = new Transfer[]{TextTransfer.getInstance()};
        Transfer[] types3 = new Transfer[types.length + types2.length];
        int i = 0;
        while (i < types.length) {
            types3[i] = types[i];
            ++i;
        }
        i = 0;
        while (i < types2.length) {
            types3[i + types.length] = types2[i];
            ++i;
        }
        this.target.setTransfer(types3);
        this.target.addDropListener((DropTargetListener)new PrjViewDropListener(this.prjViewTreePanel.getTreeViewer()));
    }

    public void creatDictDropTarget() {
        this.dropTarget = new DropTarget((Control)this.prjViewTreePanel.getTreeViewer().getTree(), 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.dropTarget.setTransfer(types);
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                TextTransfer transfer = TextTransfer.getInstance();
                if (transfer.isSupportedType(event.currentDataType)) {
                    String source = (String)event.data;
                    if (source.indexOf(";") == source.lastIndexOf(";")) {
                        source = source.substring(0, source.length() - 1);
                    }
                    int temp = PrjViewPanel.this.getBounds().y;
                    Composite obj = PrjViewPanel.this.getParent();
                    while (obj != null) {
                        temp += obj.getBounds().y;
                        obj = obj.getParent();
                    }
                    temp = event.y - temp;
                }
            }
        });
    }

    public void setSelectTreeNode(IFile file) {
        this.prjViewTreePanel.setSelectTreeNode(file);
    }
}

