/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.plugin.views.PrjViewTreeContentProvider;
import com.ecc.ide.plugin.views.PrjViewTreeLabelProvider;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class PrjViewTreePanel
extends Composite {
    private TreeViewer tv;

    public PrjViewTreePanel(Composite parent, int style, boolean singleSelectFlag) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.tv = singleSelectFlag ? new TreeViewer((Composite)this, 2820) : new TreeViewer((Composite)this, 2818);
        this.tv.setContentProvider((IContentProvider)new PrjViewTreeContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new PrjViewTreeLabelProvider());
    }

    public void setInput(Object rootObject) {
        this.tv.getTree().removeAll();
        this.tv.setInput(rootObject);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void reload() {
    }

    public TreeViewer getTreeViewer() {
        return this.tv;
    }

    public void addNodeFilter(final String[] nodeTypes) {
        this.tv.addFilter(new ViewerFilter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean select(Viewer viewer, Object parentElement, Object element) {
                try {
                    PrjViewXMLNode node = (PrjViewXMLNode)element;
                    if (node.obj instanceof IFolder) return true;
                    if (node.getNodeName().equalsIgnoreCase("FOLDER")) {
                        return true;
                    }
                    int i = 0;
                    while (true) {
                        if (i >= nodeTypes.length) {
                            return false;
                        }
                        if (node.getNodeName().equalsIgnoreCase(nodeTypes[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        });
    }

    public void setSelectTreeNode(IFile file) {
        try {
            this.tv.expandAll();
            IProject project = file.getProject();
            TreeItem selectItem = null;
            int i = 0;
            while (i < this.tv.getTree().getItems().length) {
                TreeItem item = this.tv.getTree().getItems()[i];
                if (project.equals((Object)((PrjViewXMLNode)item.getData()).getProject())) {
                    item.setExpanded(true);
                    selectItem = item;
                } else {
                    item.setExpanded(false);
                }
                ++i;
            }
            this.setSelectTreeNode(selectItem, file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setSelectTreeNode(TreeItem parent, IFile file) {
        try {
            if (parent == null) {
                return;
            }
            TreeItem selectItem = null;
            int i = 0;
            while (i < parent.getItems().length) {
                TreeItem item = parent.getItems()[i];
                PrjViewXMLNode node = (PrjViewXMLNode)item.getData();
                if (node.obj != null && node.obj instanceof IResource) {
                    if (file.getLocation().toOSString().startsWith(((IResource)node.obj).getLocation().toOSString())) {
                        item.setExpanded(true);
                        selectItem = item;
                    } else {
                        item.setExpanded(false);
                    }
                } else {
                    item.setExpanded(false);
                }
                ++i;
            }
            if (selectItem == null) {
                this.tv.getTree().setSelection(new TreeItem[]{parent});
            }
            this.setSelectTreeNode(selectItem, file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

