/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProblemViewDialog
extends Dialog {
    private boolean showDetail = false;
    private Composite container;
    public static final int ERROR = 2;
    public static final int INFORMATION = 0;
    public static final int QUESTION = 3;
    public static final int WARNING = 1;
    private String message;
    private String detailMessage;
    private Image image;
    private Text text;
    private Button button;
    private GridData textGridData;

    public ProblemViewDialog(Shell parentShell) {
        super(parentShell);
    }

    public ProblemViewDialog(Shell parentShell, int imageType, String message, String detailMessage) {
        super(parentShell);
        switch (imageType) {
            case 2: {
                this.image = this.getSWTImage(1);
                break;
            }
            case 0: {
                this.image = this.getSWTImage(2);
                break;
            }
            case 3: {
                this.image = this.getSWTImage(4);
                break;
            }
            case 1: {
                this.image = this.getSWTImage(8);
            }
        }
        this.message = message;
        this.detailMessage = detailMessage != null && detailMessage.length() > 1 ? detailMessage : message;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 10;
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        if (this.image != null) {
            Label label = new Label(container, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setImage(this.image);
        }
        Label label_1 = new Label(container, 64);
        label_1.setLayoutData((Object)new GridData(1792));
        label_1.setText(this.message);
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout());
        this.button = new Button(composite, 0);
        this.button.setLayoutData((Object)new GridData());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProblemViewDialog.this.showDetail) {
                    ProblemViewDialog.this.showDetailMessage();
                } else {
                    ProblemViewDialog.this.hideDetailMessage();
                }
            }
        });
        this.button.setText("Detail >>");
        this.text = new Text(container, 2818);
        this.textGridData = new GridData(770);
        this.textGridData.heightHint = 0;
        this.textGridData.horizontalSpan = 2;
        this.text.setLayoutData((Object)this.textGridData);
        if (this.detailMessage != null) {
            this.text.setText(this.detailMessage);
        } else if (this.message != null) {
            this.text.setText(this.message);
        } else {
            this.text.setText("No detail Infos!");
        }
        this.text.setVisible(false);
        this.container = container;
        return container;
    }

    private void showDetailMessage() {
        this.showDetail = true;
        this.text.setVisible(true);
        this.button.setText("Detail <<");
        this.textGridData.heightHint = 160;
        this.getShell().setSize(500, 400);
        this.container.layout(true);
        this.getShell().layout(true);
    }

    private void hideDetailMessage() {
        this.showDetail = false;
        this.text.setVisible(false);
        this.textGridData.heightHint = 5;
        this.button.setText("Detail >>");
        this.getShell().setSize(500, 200);
        this.container.layout(true);
        this.getShell().layout(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(500, 200);
    }

    private Image getSWTImage(final int imageID) {
        Shell shell = this.getShell();
        if (shell == null) {
            shell = this.getParentShell();
        }
        final Display display = shell == null ? Display.getCurrent() : shell.getDisplay();
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }
}

