/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.views.ViewResourceChangeListener;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class ProjectExplorerView
extends ViewPart {
    private Action refreshAction;
    public Action syncedAction;
    PrjViewPanel prjViewPanel = null;
    PrjViewSelectionAdapter prjViewSelectionAdapter = null;
    static ViewResourceChangeListener rsListener = null;
    private CustomFiltersActionGroup filtersActionGroup = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.prjViewPanel = new PrjViewPanel(parent, 0);
        this.prjViewSelectionAdapter = new PrjViewSelectionAdapter(this.prjViewPanel);
        this.filtersActionGroup = new CustomFiltersActionGroup((IViewPart)this, (StructuredViewer)this.prjViewPanel.getTreeViewer());
        this.makeActions();
        if (rsListener == null) {
            rsListener = new ViewResourceChangeListener(this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)rsListener, 4);
        }
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                ProjectExplorerView.this.prjViewPanel.reload(null);
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        try {
            URL url = ECCIDEPlugin.getDefault().find((IPath)new Path("icons/refresh.gif"));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.refreshAction.setImageDescriptor(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.refreshAction);
        this.syncedAction = new Action("Link with Editor", 2){

            public void run() {
                if (ProjectExplorerView.this.syncedAction.isChecked()) {
                    ProjectExplorerView.this.syncedAction.setChecked(true);
                    ProjectExplorerView.this.prjViewPanel.getTreeViewer().getTree().addSelectionListener((SelectionListener)ProjectExplorerView.this.prjViewSelectionAdapter);
                } else {
                    ProjectExplorerView.this.syncedAction.setChecked(false);
                    ProjectExplorerView.this.prjViewPanel.getTreeViewer().getTree().removeSelectionListener((SelectionListener)ProjectExplorerView.this.prjViewSelectionAdapter);
                }
            }
        };
        this.syncedAction.setChecked(false);
        this.syncedAction.setText("Link with Editor");
        this.syncedAction.setToolTipText("Link with Editor");
        try {
            URL url = ECCIDEPlugin.getDefault().find((IPath)new Path("icons/link.png"));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.syncedAction.setImageDescriptor(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        manager.add((IAction)this.syncedAction);
        this.filtersActionGroup.fillActionBars(bars);
        String[] filters = this.filtersActionGroup.internalGetEnabledFilterIds();
        int i = 0;
        while (i < filters.length) {
            System.out.println("filters: " + filters[i]);
            ++i;
        }
    }

    public void setFocus() {
    }

    public void setSelectTreeNode(IFile file) {
        this.prjViewPanel.setSelectTreeNode(file);
    }

    private static final class PrjViewSelectionAdapter
    extends SelectionAdapter {
        private PrjViewPanel prjViewPanel;

        public PrjViewSelectionAdapter(PrjViewPanel prjViewPanel) {
            this.prjViewPanel = prjViewPanel;
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
            PrjViewXMLNode selectNode = (PrjViewXMLNode)selection.getFirstElement();
            IResource resource = (IResource)selectNode.obj;
            IWorkbenchPage workbenchPage = ECCIDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart pkgExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer");
            if (pkgExplorer != null) {
                ((ISetSelectionTarget)pkgExplorer).selectReveal((ISelection)new StructuredSelection((Object)resource));
            }
        }
    }
}

