/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.properties.ProjectPropertyPanel;
import com.ecc.ide.plugin.views.IDESellection;
import com.ecc.ide.plugin.views.Messages;
import com.ecc.ide.plugin.wizards.NewHtmlLayoutWizard;
import com.ecc.ide.plugin.wizards.NewHtmlTaskInfoWizard;
import com.ecc.ide.plugin.wizards.NewKJavaTransactionWizard;
import com.ecc.ide.plugin.wizards.NewMCIActionComponentWizard;
import com.ecc.ide.plugin.wizards.NewMCIServiceComponentWizard;
import com.ecc.ide.plugin.wizards.NewMCITransactionWizard;
import com.ecc.ide.plugin.wizards.NewMVCModelWizard;
import com.ecc.ide.plugin.wizards.NewTellerTransactionWizard;
import com.ecc.ide.plugin.wizards.NewWMLTransactionWizard;
import com.ecc.ide.popup.actions.BuildAllHtmlTrxAction;
import com.ecc.ide.popup.actions.BuildAllKJavaTrxAction;
import com.ecc.ide.popup.actions.BuildAllMCITrxAction;
import com.ecc.ide.popup.actions.BuildAllTellerTrxAction;
import com.ecc.ide.popup.actions.BuildAllWMLTrxAction;
import com.ecc.ide.popup.actions.BuildHtmlTrxAction;
import com.ecc.ide.popup.actions.BuildHtmlTrxDesignDocumentAction;
import com.ecc.ide.popup.actions.BuildKJavaTrxAction;
import com.ecc.ide.popup.actions.BuildKJavaTrxDesignDocumentAction;
import com.ecc.ide.popup.actions.BuildMCIProjectAction;
import com.ecc.ide.popup.actions.BuildMCIProjectDesignDocumentAction;
import com.ecc.ide.popup.actions.BuildMCITrxAction;
import com.ecc.ide.popup.actions.BuildMCITrxDesignDocumentAction;
import com.ecc.ide.popup.actions.BuildTellerProjectAction;
import com.ecc.ide.popup.actions.BuildTellerTrxAction;
import com.ecc.ide.popup.actions.BuildTellerTrxDesignDocumentAction;
import com.ecc.ide.popup.actions.BuildWMLTrxAction;
import com.ecc.ide.popup.actions.BuildWMLTrxDesignDocumentAction;
import com.ecc.ide.popup.actions.ImportSettingFilesAction;
import com.ecc.ide.popup.actions.RefreshSettingsAction;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ProjectPanel
extends Composite
implements ISelectionProvider,
IResourceChangeListener {
    private Tree tree;
    private Menu prjMenu;
    private Menu mciMenu;
    private Menu htmlMenu;
    private Menu wmlMenu;
    private Menu kjavaMenu;
    private Menu tellerMenu;
    private Menu documentMenu;
    private IDESellection curSellection;
    private Image folderImage;
    private Image prjImage;
    private Image mciTrxImage;
    private Image htmlTrxImage;
    private Image kjavaTrxImage;
    private Image wapTrxImage;
    private Image tellerTrxImage;
    private Image layoutImage;
    private Image taskTreeImage;
    private Image wordImage;
    private Image importImage;
    private Image refreshImage;
    private Image runtimeImage;
    private List listeners;

    public ProjectPanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Image img = new Image(null, ECCIDEPlugin.getFile("icons/refresh.gif"));
        this.tree = new Tree((Composite)this, 2048);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectPanel.this.openSelectedResource();
            }

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.setActiveItem();
            }
        });
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initialize();
    }

    public void reload() {
        this.tree.removeAll();
        this.loadProjectTreeInfo();
    }

    private void initialize() {
        this.loadIcons();
        this.initializeMenu();
        this.loadProjectTreeInfo();
    }

    private void loadProjectTreeInfo() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject prj = projects[i];
            IFile file = prj.getFile("ECCMCIProject.xml");
            if (file != null && file.exists()) {
                this.loadEMPProjectInfo(prj, null);
            }
            ++i;
        }
    }

    private void initializeMenu() {
        this.prjMenu = new Menu((Control)this.tree);
        MenuItem newMenuItem = new MenuItem(this.prjMenu, 64);
        newMenuItem.setText(Messages.getString("ECCIDEProjectPanel.new"));
        Menu menu_1 = new Menu(newMenuItem);
        newMenuItem.setMenu(menu_1);
        MenuItem newBusinessLogicItem = new MenuItem(menu_1, 0);
        newBusinessLogicItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewBusinessLogic();
            }
        });
        newBusinessLogicItem.setText(Messages.getString("ECCIDEProjectPanel.businessLogic"));
        if (this.mciTrxImage != null) {
            newBusinessLogicItem.setImage(this.mciTrxImage);
        }
        MenuItem actionBeanMenuItem = new MenuItem(menu_1, 0);
        actionBeanMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewActionBean();
            }
        });
        actionBeanMenuItem.setText(Messages.getString("ECCIDEProjectPanel.actionBean"));
        MenuItem serviceBeanMenuItem = new MenuItem(menu_1, 0);
        serviceBeanMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewServiceBean();
            }
        });
        serviceBeanMenuItem.setText(Messages.getString("ECCIDEProjectPanel.serviceBean"));
        new MenuItem(menu_1, 2);
        MenuItem htmlBusinessLogicMenuItem = new MenuItem(menu_1, 0);
        htmlBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlBusinessLogic();
            }
        });
        htmlBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.htmlCltBusinessLogic"));
        if (this.htmlTrxImage != null) {
            htmlBusinessLogicMenuItem.setImage(this.htmlTrxImage);
        }
        MenuItem htmlLayoutMenuItem = new MenuItem(menu_1, 0);
        htmlLayoutMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlLayout();
            }
        });
        htmlLayoutMenuItem.setText(Messages.getString("ECCIDEProjectPanel.htmlLayout"));
        if (this.layoutImage != null) {
            htmlLayoutMenuItem.setImage(this.layoutImage);
        }
        MenuItem htmltaskmenuMenuItem = new MenuItem(menu_1, 0);
        htmltaskmenuMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlTaskMenu();
            }
        });
        htmltaskmenuMenuItem.setText(Messages.getString("ECCIDEProjectPanel.htmlTaskMenu"));
        if (this.taskTreeImage != null) {
            htmltaskmenuMenuItem.setImage(this.taskTreeImage);
        }
        new MenuItem(menu_1, 2);
        MenuItem wmlBusinessLogicMenuItem = new MenuItem(menu_1, 0);
        wmlBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewWmlBusinessLogic();
            }
        });
        wmlBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.wmlCltBusinessLogic"));
        if (this.wapTrxImage != null) {
            wmlBusinessLogicMenuItem.setImage(this.wapTrxImage);
        }
        new MenuItem(menu_1, 2);
        MenuItem kjavaBusinessLogicMenuItem = new MenuItem(menu_1, 0);
        kjavaBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewKJavaBusinessLogic();
            }
        });
        kjavaBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.kjavaCltBusinessLogic"));
        if (this.kjavaTrxImage != null) {
            kjavaBusinessLogicMenuItem.setImage(this.kjavaTrxImage);
        }
        new MenuItem(menu_1, 2);
        MenuItem tellerBusinessLogicMenuItem = new MenuItem(menu_1, 0);
        tellerBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewTellerBusinessLogic();
            }
        });
        tellerBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.tellerCltBusinessLogic"));
        if (this.tellerTrxImage != null) {
            tellerBusinessLogicMenuItem.setImage(this.tellerTrxImage);
        }
        MenuItem buildMenuItem = new MenuItem(this.prjMenu, 64);
        buildMenuItem.setText(Messages.getString("ECCIDEProjectPanel.build"));
        if (this.runtimeImage != null) {
            buildMenuItem.setImage(this.runtimeImage);
        }
        Menu menu = new Menu(buildMenuItem);
        buildMenuItem.setMenu(menu);
        MenuItem projectSettingsMenuItem = new MenuItem(menu, 0);
        projectSettingsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildProjectSettings();
            }
        });
        projectSettingsMenuItem.setText(Messages.getString("ECCIDEProjectPanel.projectSettings"));
        MenuItem allBusinessLogicMenuItem = new MenuItem(menu, 0);
        allBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllBusinessLogic();
            }
        });
        allBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.allBusinessLogic"));
        if (this.mciTrxImage != null) {
            allBusinessLogicMenuItem.setImage(this.mciTrxImage);
        }
        MenuItem projectDocumentMenuItem = new MenuItem(menu, 0);
        projectDocumentMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildProjectDocument();
            }
        });
        projectDocumentMenuItem.setText(Messages.getString("ECCIDEProjectPanel.projectDocument"));
        if (this.wordImage != null) {
            projectDocumentMenuItem.setImage(this.wordImage);
        }
        new MenuItem(menu, 2);
        MenuItem tellerClientProjectMenuItem = new MenuItem(menu, 0);
        tellerClientProjectMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTellerProjectSettings();
            }
        });
        tellerClientProjectMenuItem.setText(Messages.getString("ECCIDEProjectPanel.tellerCltPrjSettings"));
        MenuItem tellerClientProjectMenuItem_1 = new MenuItem(menu, 0);
        tellerClientProjectMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.tellerCltPrjDocument"));
        if (this.wordImage != null) {
            tellerClientProjectMenuItem_1.setImage(this.wordImage);
        }
        MenuItem allTellerClientMenuItem = new MenuItem(menu, 0);
        allTellerClientMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllTellerBusinessLogic();
            }
        });
        allTellerClientMenuItem.setText(Messages.getString("ECCIDEProjectPanel.allTellerCltLogic"));
        if (this.tellerTrxImage != null) {
            allTellerClientMenuItem.setImage(this.tellerTrxImage);
        }
        new MenuItem(menu, 2);
        MenuItem allHtmlBusinessMenuItem = new MenuItem(menu, 0);
        allHtmlBusinessMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllHtmlBusinessLogic();
            }
        });
        allHtmlBusinessMenuItem.setText(Messages.getString("ECCIDEProjectPanel.allHtmlCltLogic"));
        if (this.htmlTrxImage != null) {
            allHtmlBusinessMenuItem.setImage(this.htmlTrxImage);
        }
        MenuItem allWmlBusinessMenuItem = new MenuItem(menu, 0);
        allWmlBusinessMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllWmlBusinessLogic();
            }
        });
        allWmlBusinessMenuItem.setText(Messages.getString("ECCIDEProjectPanel.allWMLCltLogic"));
        if (this.wapTrxImage != null) {
            allWmlBusinessMenuItem.setImage(this.wapTrxImage);
        }
        MenuItem allKjavaBusinessMenuItem = new MenuItem(menu, 0);
        allKjavaBusinessMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllKJavaBusinessLogic();
            }
        });
        allKjavaBusinessMenuItem.setText(Messages.getString("ECCIDEProjectPanel.allKJavaCltLogic"));
        if (this.kjavaTrxImage != null) {
            allKjavaBusinessMenuItem.setImage(this.kjavaTrxImage);
        }
        new MenuItem(this.prjMenu, 2);
        MenuItem refreshMenuItem = new MenuItem(this.prjMenu, 0);
        refreshMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.reloadProjectSettings();
            }
        });
        refreshMenuItem.setText(Messages.getString("ECCIDEProjectPanel.refreshSettings"));
        if (this.refreshImage != null) {
            refreshMenuItem.setImage(this.refreshImage);
        }
        MenuItem importMenuItem = new MenuItem(this.prjMenu, 0);
        importMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.importProjectSettings();
            }
        });
        importMenuItem.setText(Messages.getString("ECCIDEProjectPanel.import"));
        if (this.importImage != null) {
            importMenuItem.setImage(this.importImage);
        }
        MenuItem menuItem = new MenuItem(this.prjMenu, 0);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem.setImage(this.refreshImage);
        }
        new MenuItem(this.prjMenu, 2);
        MenuItem propertiesMenuItem = new MenuItem(this.prjMenu, 0);
        propertiesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.showProjectProperties();
            }
        });
        propertiesMenuItem.setText(Messages.getString("ECCIDEProjectPanel.properties"));
        this.mciMenu = new Menu((Control)this.tree);
        MenuItem addNewBusinessMenuItem = new MenuItem(this.mciMenu, 0);
        addNewBusinessMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewBusinessLogic();
            }
        });
        addNewBusinessMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewBusinessLogic"));
        if (this.mciTrxImage != null) {
            addNewBusinessMenuItem.setImage(this.mciTrxImage);
        }
        MenuItem buildAllBusinessMenuItem = new MenuItem(this.mciMenu, 0);
        buildAllBusinessMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllBusinessLogic();
            }
        });
        buildAllBusinessMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildAllBusinessLogic"));
        if (this.runtimeImage != null) {
            buildAllBusinessMenuItem.setImage(this.runtimeImage);
        }
        new MenuItem(this.mciMenu, 2);
        MenuItem buildBusinessLogicMenuItem = new MenuItem(this.mciMenu, 0);
        buildBusinessLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheBusinessLogic();
            }
        });
        buildBusinessLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheBusinessLogic"));
        if (this.runtimeImage != null) {
            buildBusinessLogicMenuItem.setImage(this.runtimeImage);
        }
        MenuItem buildBusinessLogicMenuItem_1 = new MenuItem(this.mciMenu, 0);
        buildBusinessLogicMenuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheBusinessLogicDocument();
            }
        });
        buildBusinessLogicMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.buildTheBusinessLogicDocument"));
        if (this.wordImage != null) {
            buildBusinessLogicMenuItem_1.setImage(this.wordImage);
        }
        new MenuItem(this.mciMenu, 2);
        MenuItem menuItem_1 = new MenuItem(this.mciMenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_1.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_1.setImage(this.refreshImage);
        }
        this.htmlMenu = new Menu((Control)this.tree);
        MenuItem addNewHtmlMenuItem = new MenuItem(this.htmlMenu, 0);
        addNewHtmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlBusinessLogic();
            }
        });
        addNewHtmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewHtmlBusinessLogic"));
        if (this.htmlTrxImage != null) {
            addNewHtmlMenuItem.setImage(this.htmlTrxImage);
        }
        MenuItem addNewHtmlMenuItem_1 = new MenuItem(this.htmlMenu, 0);
        addNewHtmlMenuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlLayout();
            }
        });
        addNewHtmlMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.createNewHtmlLayout"));
        if (this.layoutImage != null) {
            addNewHtmlMenuItem_1.setImage(this.layoutImage);
        }
        MenuItem createNewHtmlMenuItem = new MenuItem(this.htmlMenu, 0);
        createNewHtmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewHtmlTaskMenu();
            }
        });
        createNewHtmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewHtmlTasktree"));
        if (this.taskTreeImage != null) {
            createNewHtmlMenuItem.setImage(this.taskTreeImage);
        }
        new MenuItem(this.htmlMenu, 2);
        MenuItem buildAllHtmlMenuItem = new MenuItem(this.htmlMenu, 0);
        buildAllHtmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllHtmlBusinessLogic();
            }
        });
        buildAllHtmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildAllHtmlBusinessLogic"));
        if (this.runtimeImage != null) {
            buildAllHtmlMenuItem.setImage(this.runtimeImage);
        }
        new MenuItem(this.htmlMenu, 2);
        MenuItem buildTheHtmlMenuItem = new MenuItem(this.htmlMenu, 0);
        buildTheHtmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheHtmlBusinessLogic();
            }
        });
        buildTheHtmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheHtmlBusinessLogic"));
        if (this.runtimeImage != null) {
            buildTheHtmlMenuItem.setImage(this.runtimeImage);
        }
        MenuItem buildTheLogicMenuItem = new MenuItem(this.htmlMenu, 0);
        buildTheLogicMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheHtmlBusinessLogicDocument();
            }
        });
        buildTheLogicMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheHtmlBusinessLogicDocument"));
        if (this.wordImage != null) {
            buildTheLogicMenuItem.setImage(this.wordImage);
        }
        new MenuItem(this.htmlMenu, 2);
        MenuItem menuItem_2 = new MenuItem(this.htmlMenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_2.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_2.setImage(this.refreshImage);
        }
        this.wmlMenu = new Menu((Control)this.tree);
        MenuItem createNewWmlMenuItem = new MenuItem(this.wmlMenu, 0);
        createNewWmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewWmlBusinessLogic();
            }
        });
        createNewWmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewWMLBusinessLogic"));
        if (this.wapTrxImage != null) {
            createNewWmlMenuItem.setImage(this.wapTrxImage);
        }
        MenuItem buildAllWmlMenuItem = new MenuItem(this.wmlMenu, 0);
        buildAllWmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllWmlBusinessLogic();
            }
        });
        buildAllWmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildAllWMLBusinessLogic"));
        if (this.runtimeImage != null) {
            buildAllWmlMenuItem.setImage(this.runtimeImage);
        }
        new MenuItem(this.wmlMenu, 2);
        MenuItem buildTheWmlMenuItem = new MenuItem(this.wmlMenu, 0);
        buildTheWmlMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheWmlBusinessLogic();
            }
        });
        buildTheWmlMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheWMLBusinessLogic"));
        if (this.runtimeImage != null) {
            buildTheWmlMenuItem.setImage(this.runtimeImage);
        }
        MenuItem buildTheWmlMenuItem_1 = new MenuItem(this.wmlMenu, 0);
        buildTheWmlMenuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheWmlBusinessLogicDocument();
            }
        });
        buildTheWmlMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.buildTheWMLBusinessLogicDocument"));
        if (this.wordImage != null) {
            buildTheWmlMenuItem_1.setImage(this.wordImage);
        }
        new MenuItem(this.wmlMenu, 2);
        MenuItem menuItem_3 = new MenuItem(this.wmlMenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_3.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_3.setImage(this.refreshImage);
        }
        this.kjavaMenu = new Menu((Control)this.tree);
        MenuItem createNewKjavaMenuItem = new MenuItem(this.kjavaMenu, 0);
        createNewKjavaMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewKJavaBusinessLogic();
            }
        });
        createNewKjavaMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewKJavaBusinessLogic"));
        if (this.kjavaTrxImage != null) {
            createNewKjavaMenuItem.setImage(this.kjavaTrxImage);
        }
        MenuItem buildAllKjavaMenuItem = new MenuItem(this.kjavaMenu, 0);
        buildAllKjavaMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllKJavaBusinessLogic();
            }
        });
        buildAllKjavaMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildAllKJavaBusinessLogic"));
        if (this.runtimeImage != null) {
            buildAllKjavaMenuItem.setImage(this.runtimeImage);
        }
        new MenuItem(this.kjavaMenu, 2);
        MenuItem buildTheKjavaMenuItem = new MenuItem(this.kjavaMenu, 0);
        buildTheKjavaMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheKJavaBusinessLogic();
            }
        });
        buildTheKjavaMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheKJavaBusinessLogic"));
        if (this.runtimeImage != null) {
            buildTheKjavaMenuItem.setImage(this.runtimeImage);
        }
        MenuItem buildTheKjavaMenuItem_1 = new MenuItem(this.kjavaMenu, 0);
        buildTheKjavaMenuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheKJavaBusinessLogicDocument();
            }
        });
        buildTheKjavaMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.buildTheKJavaBusinessLogicDocument"));
        if (this.wordImage != null) {
            buildTheKjavaMenuItem_1.setImage(this.wordImage);
        }
        new MenuItem(this.kjavaMenu, 2);
        MenuItem menuItem_4 = new MenuItem(this.kjavaMenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_4.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_4.setImage(this.refreshImage);
        }
        this.tellerMenu = new Menu((Control)this.tree);
        MenuItem createNewTellerMenuItem = new MenuItem(this.tellerMenu, 0);
        createNewTellerMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.createNewTellerBusinessLogic();
            }
        });
        createNewTellerMenuItem.setText(Messages.getString("ECCIDEProjectPanel.createNewTellerBusinessLogic"));
        if (this.tellerTrxImage != null) {
            createNewTellerMenuItem.setImage(this.tellerTrxImage);
        }
        MenuItem buildAllTellerMenuItem = new MenuItem(this.tellerMenu, 0);
        buildAllTellerMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildAllTellerBusinessLogic();
            }
        });
        buildAllTellerMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildAllTellerBusinessLogic"));
        if (this.runtimeImage != null) {
            buildAllTellerMenuItem.setImage(this.runtimeImage);
        }
        new MenuItem(this.tellerMenu, 2);
        MenuItem buildTheTellerMenuItem = new MenuItem(this.tellerMenu, 0);
        buildTheTellerMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheTellerBusinessLogic();
            }
        });
        buildTheTellerMenuItem.setText(Messages.getString("ECCIDEProjectPanel.buildTheTellerBusinessLogic"));
        if (this.runtimeImage != null) {
            buildTheTellerMenuItem.setImage(this.runtimeImage);
        }
        MenuItem buildTheTellerMenuItem_1 = new MenuItem(this.tellerMenu, 0);
        buildTheTellerMenuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.buildTheTellerBusinessLogicDocument();
            }
        });
        buildTheTellerMenuItem_1.setText(Messages.getString("ECCIDEProjectPanel.buildTheTellerBusinessLogicDocument"));
        if (this.wordImage != null) {
            buildTheTellerMenuItem_1.setImage(this.wordImage);
        }
        new MenuItem(this.tellerMenu, 2);
        MenuItem menuItem_5 = new MenuItem(this.tellerMenu, 0);
        menuItem_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_5.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_5.setImage(this.refreshImage);
        }
        this.documentMenu = new Menu((Control)this.tree);
        MenuItem menuItem_6 = new MenuItem(this.documentMenu, 0);
        menuItem_6.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPanel.this.refreshCurrentSelection();
            }
        });
        menuItem_6.setText(Messages.getString("ECCIDEProjectPanel.refresh"));
        if (this.refreshImage != null) {
            menuItem_6.setImage(this.refreshImage);
        }
    }

    private void loadDesignFile(IProject prj, TreeItem pItem, String subFolder, String[] suffix, Image icon, String excludeFolder) {
        try {
            IResource resource;
            IFolder folder = prj.getFolder(subFolder);
            pItem.setData((Object)folder);
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                resource = resources[i];
                if (resource.getType() == 2) {
                    String folderName = resource.getName();
                    if (excludeFolder == null || excludeFolder.indexOf(folderName) == -1) {
                        TreeItem item = new TreeItem(pItem, 0);
                        item.setData((Object)resource);
                        item.setText(resource.getName());
                        if (this.folderImage != null) {
                            item.setImage(this.folderImage);
                        }
                        this.loadFolderInfo(prj, item, resource, suffix, icon, excludeFolder);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < resources.length) {
                resource = resources[i];
                if (resource.getType() == 1) {
                    int kk = 0;
                    while (kk < suffix.length) {
                        String suf = suffix[kk];
                        if (resource.getName().endsWith(suf)) {
                            String name;
                            TreeItem item = new TreeItem(pItem, 0);
                            item.setData((Object)resource);
                            if (icon != null) {
                                item.setImage(icon);
                            }
                            if ((name = resource.getName()).indexOf(".") != -1) {
                                name = name.substring(0, name.lastIndexOf("."));
                            }
                            item.setText(name);
                            break;
                        }
                        ++kk;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void loadFolderInfo(IProject prj, TreeItem pItem, IResource pResource, String[] suffix, Image icon, String excludeFolder) {
        try {
            IResource resource;
            IResource[] resources = ((IFolder)pResource).members();
            int i = 0;
            while (i < resources.length) {
                resource = resources[i];
                if (resource.getType() == 2) {
                    String folderName = resource.getName();
                    if (excludeFolder == null || excludeFolder.indexOf(folderName) == -1) {
                        TreeItem item = new TreeItem(pItem, 0);
                        item.setData((Object)resource);
                        item.setText(resource.getName());
                        if (this.folderImage != null) {
                            item.setImage(this.folderImage);
                        }
                        this.loadFolderInfo(prj, item, resource, suffix, icon, excludeFolder);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < resources.length) {
                resource = resources[i];
                if (resource.getType() == 1) {
                    int kk = 0;
                    while (kk < suffix.length) {
                        String suf = suffix[kk];
                        if (resource.getName().endsWith(suf)) {
                            TreeItem item = new TreeItem(pItem, 0);
                            item.setText(resource.getName());
                            item.setData((Object)resource);
                            if (icon == null) break;
                            item.setImage(icon);
                            break;
                        }
                        ++kk;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadIcons() {
        try {
            this.folderImage = new Image(null, ECCIDEPlugin.getFile("icons/folder.gif"));
            this.prjImage = new Image(null, ECCIDEPlugin.getFile("icons/addMCINature.gif"));
            this.mciTrxImage = new Image(null, ECCIDEPlugin.getFile("icons/mciTrx.gif"));
            this.htmlTrxImage = new Image(null, ECCIDEPlugin.getFile("icons/htmlTrx.gif"));
            this.kjavaTrxImage = new Image(null, ECCIDEPlugin.getFile("icons/kjavaTrx.gif"));
            this.wapTrxImage = new Image(null, ECCIDEPlugin.getFile("icons/wapTrx.gif"));
            this.tellerTrxImage = new Image(null, ECCIDEPlugin.getFile("icons/tellerTrx.gif"));
            this.layoutImage = new Image(null, ECCIDEPlugin.getFile("icons/newLayout.gif"));
            this.taskTreeImage = new Image(null, ECCIDEPlugin.getFile("icons/newTaskTree.gif"));
            this.wordImage = new Image(null, ECCIDEPlugin.getFile("icons/word.gif"));
            this.importImage = new Image(null, ECCIDEPlugin.getFile("icons/import.gif"));
            this.refreshImage = new Image(null, ECCIDEPlugin.getFile("icons/refresh.gif"));
            this.runtimeImage = new Image(null, ECCIDEPlugin.getFile("icons/runtime.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openSelectedResource() {
        TreeItem[] items = this.tree.getSelection();
        if (items.length != 1) {
            return;
        }
        Object data = items[0].getData();
        if (data == null) {
            return;
        }
        if (data instanceof IProject) {
            return;
        }
        if (!(data instanceof IResource)) {
            return;
        }
        final IResource resource = (IResource)data;
        if (resource.getType() == 2) {
            return;
        }
        String id = null;
        String extention = resource.getFileExtension();
        if ("ECCMCIProject.xml".equals(resource.getName())) {
            id = "com.ecc.ide.plugin.editors.ECCPrjSettingsEditor";
        }
        if ("jsp".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.jsp.JSPEditor";
        } else if ("jtx".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.JSPTransactionEditor";
        } else if ("mvc".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.MVCModelEditor";
        } else if ("mtx".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.MCITransactionEditor";
        } else if ("biz".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.EMPBusinessLogicEditor";
        } else if ("wtx".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.WMLTransactionEditor";
        } else if ("ktx".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.KJavaTransactionEditor";
        } else if ("ttx".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.TellerTransactionEditor";
        } else if ("tsk".equalsIgnoreCase(extention)) {
            id = "com.ecc.ide.plugin.editors.HtmlTaskInfoEditor";
        }
        final String editorId = id;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IFile file = resource.getProject().getFile(resource.getProjectRelativePath());
                    if (editorId != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorId, (boolean)true);
                    } else {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setActiveItem() {
        TreeItem pItem;
        this.tree.setMenu(null);
        TreeItem[] items = this.tree.getSelection();
        if (items.length != 1) {
            return;
        }
        Object data = items[0].getData();
        this.curSellection = new IDESellection(data);
        this.fireSelectionChangedEvent();
        if (data != null && data instanceof IProject) {
            this.tree.setMenu(this.prjMenu);
            return;
        }
        TreeItem aItem = pItem = items[0];
        while (aItem.getParentItem() != null) {
            pItem = aItem;
            aItem = aItem.getParentItem();
        }
        if (pItem == items[0] && !(data instanceof String)) {
            return;
        }
        String pType = (String)pItem.getData();
        if ("BL".equals(pType)) {
            this.tree.setMenu(this.mciMenu);
        } else if ("html".equals(pType)) {
            this.tree.setMenu(this.htmlMenu);
        } else if ("wml".equals(pType)) {
            this.tree.setMenu(this.wmlMenu);
        } else if ("kjava".equals(pType)) {
            this.tree.setMenu(this.kjavaMenu);
        } else if ("teller".equals(pType)) {
            this.tree.setMenu(this.tellerMenu);
        } else if ("document".equals(pType)) {
            this.tree.setMenu(this.documentMenu);
        }
        if (pItem == items[0]) {
            IProject project = (IProject)items[0].getParentItem().getData();
            this.curSellection = new IDESellection(project);
        }
    }

    private void createNewBusinessLogic() {
        NewMCITransactionWizard wizard = new NewMCITransactionWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewHtmlBusinessLogic() {
        NewMVCModelWizard wizard = new NewMVCModelWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewHtmlLayout() {
        NewHtmlLayoutWizard wizard = new NewHtmlLayoutWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewHtmlTaskMenu() {
        NewHtmlTaskInfoWizard wizard = new NewHtmlTaskInfoWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewWmlBusinessLogic() {
        NewWMLTransactionWizard wizard = new NewWMLTransactionWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewKJavaBusinessLogic() {
        NewKJavaTransactionWizard wizard = new NewKJavaTransactionWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewTellerBusinessLogic() {
        NewTellerTransactionWizard wizard = new NewTellerTransactionWizard();
        this.openTheNewWizard(wizard);
    }

    private void openTheNewWizard(Wizard wizard) {
        if (wizard instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.getWorkbench(), (IStructuredSelection)this.curSellection);
        }
        WizardDialog wizarddialog = new WizardDialog(this.getWorkbenchWindow().getShell(), (IWizard)wizard);
        wizarddialog.create();
        String s = wizard.getWindowTitle();
        if (s != null) {
            wizarddialog.getShell().setText(s);
        }
        wizarddialog.open();
        this.refreshCurrentSelection();
    }

    private void createNewActionBean() {
        NewMCIActionComponentWizard wizard = new NewMCIActionComponentWizard();
        this.openTheNewWizard(wizard);
    }

    private void createNewServiceBean() {
        NewMCIServiceComponentWizard wizard = new NewMCIServiceComponentWizard();
        this.openTheNewWizard(wizard);
    }

    private void buildProjectSettings() {
        BuildMCIProjectAction action = new BuildMCIProjectAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildAllBusinessLogic() {
        BuildAllMCITrxAction action = new BuildAllMCITrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheBusinessLogicDocument() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".mtx")) {
            return;
        }
        BuildMCITrxDesignDocumentAction action = new BuildMCITrxDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheBusinessLogic() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".mtx")) {
            return;
        }
        BuildMCITrxAction action = new BuildMCITrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheHtmlBusinessLogic() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".jtx")) {
            return;
        }
        BuildHtmlTrxAction action = new BuildHtmlTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheHtmlBusinessLogicDocument() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".jtx")) {
            return;
        }
        BuildHtmlTrxDesignDocumentAction action = new BuildHtmlTrxDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheWmlBusinessLogic() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".wtx")) {
            return;
        }
        BuildWMLTrxAction action = new BuildWMLTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheWmlBusinessLogicDocument() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".wtx")) {
            return;
        }
        BuildWMLTrxDesignDocumentAction action = new BuildWMLTrxDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheKJavaBusinessLogic() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".ktx")) {
            return;
        }
        BuildKJavaTrxAction action = new BuildKJavaTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheKJavaBusinessLogicDocument() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".ktx")) {
            return;
        }
        BuildKJavaTrxDesignDocumentAction action = new BuildKJavaTrxDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheTellerBusinessLogic() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".ttx")) {
            return;
        }
        BuildTellerTrxAction action = new BuildTellerTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTheTellerBusinessLogicDocument() {
        IResource resource = (IResource)this.curSellection.getFirstElement();
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.getName().endsWith(".ttx")) {
            return;
        }
        BuildTellerTrxDesignDocumentAction action = new BuildTellerTrxDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void showProjectProperties() {
        final IProject project = (IProject)this.curSellection.getFirstElement();
        XMLNode projectSettingNode = null;
        try {
            projectSettingNode = IDEContent.getSettingNode(project, 35);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Shell parent = this.getShell();
        final Shell shell = new Shell(parent, 67696);
        shell.setLayout((Layout)new GridLayout());
        shell.setText(Messages.getString("ProjectPropertyPanel.projectSettings"));
        final ProjectPropertyPanel projectPropertyPanel = new ProjectPropertyPanel((Composite)shell, 0);
        projectPropertyPanel.setProjectSettingNode(projectSettingNode);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Button button = new Button(composite, 0);
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                projectPropertyPanel.performOk();
                IDEContent.saveSettingNode(project, 35);
                shell.dispose();
            }
        });
        button.setText("OK");
        Button button_1 = new Button(composite, 0);
        GridData gridData_1 = new GridData(128);
        gridData_1.widthHint = 80;
        button_1.setLayoutData((Object)gridData_1);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                projectPropertyPanel.performDefaults();
            }
        });
        button_1.setText("default");
        Button button_2 = new Button(composite, 0);
        GridData gridData_2 = new GridData(128);
        gridData_2.widthHint = 80;
        button_2.setLayoutData((Object)gridData_2);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        button_2.setText("Cancel");
        Rectangle rect = shell.getDisplay().getBounds();
        rect.x = (rect.width - 400) / 2;
        rect.y = (rect.height - 450) / 3;
        rect.width = 400;
        rect.height = 450;
        shell.setBounds(rect);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void reloadProjectSettings() {
        RefreshSettingsAction action = new RefreshSettingsAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildAllKJavaBusinessLogic() {
        BuildAllKJavaTrxAction action = new BuildAllKJavaTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildAllWmlBusinessLogic() {
        BuildAllWMLTrxAction action = new BuildAllWMLTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildAllHtmlBusinessLogic() {
        BuildAllHtmlTrxAction action = new BuildAllHtmlTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildAllTellerBusinessLogic() {
        BuildAllTellerTrxAction action = new BuildAllTellerTrxAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildTellerProjectSettings() {
        BuildTellerProjectAction action = new BuildTellerProjectAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    private void buildProjectDocument() {
        BuildMCIProjectDesignDocumentAction action = new BuildMCIProjectDesignDocumentAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench iworkbench = this.getWorkbench();
        IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        if (iworkbenchwindow == null) {
            IWorkbenchWindow[] aiworkbenchwindow = iworkbench.getWorkbenchWindows();
            int i = 0;
            while (i < aiworkbenchwindow.length) {
                if (!aiworkbenchwindow[i].getShell().isDisposed()) {
                    iworkbenchwindow = aiworkbenchwindow[i];
                    break;
                }
                ++i;
            }
        }
        return iworkbenchwindow;
    }

    private void refreshCurrentSelection() {
        TreeItem pItem;
        TreeItem[] items = this.tree.getSelection();
        if (items.length != 1) {
            return;
        }
        Object data = items[0].getData();
        this.curSellection = new IDESellection(data);
        if (data != null && data instanceof IProject) {
            TreeItem[] childs = items[0].getItems();
            int i = 0;
            while (i < childs.length) {
                childs[i].dispose();
                ++i;
            }
            this.loadEMPProjectInfo((IProject)data, items[0]);
            this.tree.showItem(items[0]);
            return;
        }
        TreeItem aItem = pItem = items[0];
        while (aItem.getParentItem() != null) {
            pItem = aItem;
            aItem = aItem.getParentItem();
        }
        if (pItem == items[0] && !(data instanceof String)) {
            return;
        }
        IProject project = (IProject)pItem.getParentItem().getData();
        String pType = (String)pItem.getData();
        XMLNode prjSettingsNode = null;
        try {
            prjSettingsNode = IDEContent.getSettingNode(project, 35);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IDEProjectSettings settings = new IDEProjectSettings(prjSettingsNode);
        String webRoot = settings.getWebContentPath();
        String jspRoot = settings.getJspRootPath();
        String htmlJspRoot = settings.getHtmlJspPath();
        String kjavaJspRoot = settings.getKJavaJspPath();
        String wmlJspRoot = settings.getWmlJspPath();
        htmlJspRoot = htmlJspRoot.length() > 0 ? String.valueOf(webRoot) + "/" + jspRoot + "/" + htmlJspRoot : String.valueOf(webRoot) + "/" + jspRoot;
        wmlJspRoot = String.valueOf(webRoot) + "/" + jspRoot + "/" + wmlJspRoot;
        kjavaJspRoot = String.valueOf(webRoot) + "/" + jspRoot + "/" + kjavaJspRoot;
        if ("BL".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    this.loadFolderInfo(project, items[0], resource, new String[]{".mtx", ".biz"}, this.mciTrxImage, null);
                    this.tree.showItem(pItem);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                this.loadDesignFile(project, pItem, "designFiles/MCITrxs", new String[]{".mtx", ".biz"}, this.mciTrxImage, null);
                pItem.setData((Object)"BL");
                this.tree.showItem(pItem);
            }
        } else if ("html".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    TreeItem childItem = items[0];
                    while (childItem.getParentItem() != pItem) {
                        childItem = childItem.getParentItem();
                    }
                    IResource aResource = (IResource)childItem.getData();
                    String resName = aResource.getName();
                    if ("htmlTrxs".equals(resName)) {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".jtx", ".mvc"}, this.htmlTrxImage, null);
                    } else {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".jsp"}, this.htmlTrxImage, "wml;kjava;WEB-INF;META-INF;theme;CVS;tellerClient;");
                    }
                    this.tree.showItem(items[0]);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                TreeItem designFileItem = new TreeItem(pItem, 0);
                designFileItem.setText(Messages.getString("ECCIDEProjectPanel.businessLogic"));
                if (this.htmlTrxImage != null) {
                    designFileItem.setImage(this.htmlTrxImage);
                }
                this.loadDesignFile(project, designFileItem, "designFiles/htmlTrxs", new String[]{".jtx", ".mvc"}, this.htmlTrxImage, null);
                TreeItem jspFileItem = new TreeItem(pItem, 0);
                jspFileItem.setText(Messages.getString("ECCIDEProjectPanel.jspFiles"));
                if (this.htmlTrxImage != null) {
                    jspFileItem.setImage(this.htmlTrxImage);
                }
                this.loadDesignFile(project, jspFileItem, htmlJspRoot, new String[]{".jsp"}, this.htmlTrxImage, "wml;kjava;WEB-INF;META-INF;theme;CVS;tellerClient;");
                this.tree.showItem(pItem);
            }
        } else if ("wml".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    TreeItem childItem = items[0];
                    while (childItem.getParentItem() != pItem) {
                        childItem = childItem.getParentItem();
                    }
                    IResource aResource = (IResource)childItem.getData();
                    String resName = aResource.getName();
                    if ("wmlTrxs".equals(resName)) {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".wtx"}, this.wapTrxImage, null);
                    } else {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".jsp"}, this.htmlTrxImage, null);
                    }
                    this.tree.showItem(items[0]);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                TreeItem wmlDesignFileItem = new TreeItem(pItem, 0);
                wmlDesignFileItem.setText(Messages.getString("ECCIDEProjectPanel.businessLogic"));
                if (this.wapTrxImage != null) {
                    wmlDesignFileItem.setImage(this.wapTrxImage);
                }
                this.loadDesignFile(project, wmlDesignFileItem, "designFiles/wmlTrxs", new String[]{".wtx"}, this.wapTrxImage, null);
                TreeItem wmlJspFileItem = new TreeItem(pItem, 0);
                wmlJspFileItem.setText(Messages.getString("ECCIDEProjectPanel.jspFiles"));
                if (this.htmlTrxImage != null) {
                    wmlJspFileItem.setImage(this.htmlTrxImage);
                }
                this.loadDesignFile(project, wmlJspFileItem, wmlJspRoot, new String[]{".jsp"}, this.htmlTrxImage, null);
                this.tree.showItem(pItem);
            }
        } else if ("kjava".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    TreeItem childItem = items[0];
                    while (childItem.getParentItem() != pItem) {
                        childItem = childItem.getParentItem();
                    }
                    IResource aResource = (IResource)childItem.getData();
                    String resName = aResource.getName();
                    if ("kjavaTrxs".equals(resName)) {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".ktx"}, this.kjavaTrxImage, null);
                    } else {
                        this.loadFolderInfo(project, items[0], resource, new String[]{".jsp"}, this.htmlTrxImage, null);
                    }
                    this.tree.showItem(items[0]);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                TreeItem kjavaDesignFileItem = new TreeItem(pItem, 0);
                kjavaDesignFileItem.setText(Messages.getString("ECCIDEProjectPanel.businessLogic"));
                if (this.kjavaTrxImage != null) {
                    kjavaDesignFileItem.setImage(this.kjavaTrxImage);
                }
                this.loadDesignFile(project, kjavaDesignFileItem, "designFiles/kjavaTrxs", new String[]{".ktx"}, this.kjavaTrxImage, null);
                TreeItem kjavaJspFileItem = new TreeItem(pItem, 0);
                kjavaJspFileItem.setText(Messages.getString("ECCIDEProjectPanel.jspFiles"));
                if (this.htmlTrxImage != null) {
                    kjavaJspFileItem.setImage(this.htmlTrxImage);
                }
                this.loadDesignFile(project, kjavaJspFileItem, kjavaJspRoot, new String[]{".jsp"}, this.htmlTrxImage, null);
                this.tree.showItem(pItem);
            }
        } else if ("teller".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    this.loadFolderInfo(project, items[0], resource, new String[]{".ttx"}, this.tellerTrxImage, null);
                    this.tree.showItem(pItem);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                this.loadDesignFile(project, pItem, "designFiles/tellerTrxs", new String[]{".ttx"}, this.tellerTrxImage, null);
                pItem.setData((Object)"teller");
                this.tree.showItem(pItem);
            }
        } else if ("document".equals(pType)) {
            if (data != null && data instanceof IResource) {
                IResource resource = (IResource)data;
                if (resource.getType() == 2) {
                    TreeItem[] childs = items[0].getItems();
                    int i = 0;
                    while (i < childs.length) {
                        childs[i].dispose();
                        ++i;
                    }
                    this.loadFolderInfo(project, items[0], resource, new String[]{".doc"}, this.wordImage, "templet;");
                    this.tree.showItem(pItem);
                }
            } else if (items[0] == pItem) {
                TreeItem[] childs = pItem.getItems();
                int i = 0;
                while (i < childs.length) {
                    childs[i].dispose();
                    ++i;
                }
                this.loadDesignFile(project, pItem, "designFiles/documents", new String[]{".doc"}, this.wordImage, "templet;");
                pItem.setData((Object)"document");
            }
        }
    }

    private void importProjectSettings() {
        ImportSettingFilesAction action = new ImportSettingFilesAction();
        action.selectionChanged(null, (ISelection)this.curSellection);
        action.run((IAction)null);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.curSellection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionChangedEvent() {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)this.listeners.get(i);
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.curSellection));
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.reload();
    }

    private void loadAppNodes(IProject prj, TreeItem pItem) {
        try {
            IFolder folder = prj.getFolder("designFiles");
            pItem.setData((Object)folder);
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                XMLNode aAppNode;
                IFolder childFolder;
                IResource descFile;
                IResource resource = resources[i];
                if (resource.getType() == 2 && (descFile = (childFolder = (IFolder)resource).findMember("desc.xml")) != null && (aAppNode = this.loadXMLFile(descFile.getLocation().toOSString())) != null) {
                    TreeItem appItem = new TreeItem(pItem, 0);
                    appItem.setText(aAppNode.getAttrValue("name"));
                    appItem.setData((Object)appItem);
                    appItem.setImage(this.taskTreeImage);
                    this.loadAppPresentationNode(prj, appItem, aAppNode.getAttrValue("id"));
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLNode loadXMLFile(String fileName) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(fileName);
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadEMPProjectInfo(IProject prj, TreeItem prjItem) {
        TreeItem item = prjItem;
        if (item == null) {
            item = new TreeItem(this.tree, 0);
            item.setText(prj.getName());
            item.setData((Object)prj);
            if (this.prjImage != null) {
                item.setImage(this.prjImage);
            }
        }
        TreeItem presentationItem = new TreeItem(item, 0);
        presentationItem.setText("\u8868\u73b0\u903b\u8f91");
        presentationItem.setImage(this.taskTreeImage);
        this.loadAppNodes(prj, presentationItem);
        TreeItem mciTrxDesignFileItem = new TreeItem(item, 0);
        mciTrxDesignFileItem.setText(Messages.getString("ECCIDEProjectPanel.businessLogic"));
        if (this.mciTrxImage != null) {
            mciTrxDesignFileItem.setImage(this.mciTrxImage);
        }
        this.loadDesignFile(prj, mciTrxDesignFileItem, "designFiles/MCITrxs", new String[]{".mtx", ".biz"}, this.mciTrxImage, null);
        mciTrxDesignFileItem.setData((Object)"BL");
        TreeItem documentItem = new TreeItem(item, 0);
        documentItem.setText(Messages.getString("ECCIDEProjectPanel.designDocument"));
        if (this.wordImage != null) {
            documentItem.setImage(this.wordImage);
        }
        this.loadDesignFile(prj, documentItem, "designFiles/documents", new String[]{".doc"}, this.wordImage, "templet");
        documentItem.setData((Object)"document");
        try {
            IFile mciPrjSetting = prj.getFile("ECCMCIProject.xml");
            TreeItem itemPrjSetting = new TreeItem(item, 0);
            if (this.prjImage != null) {
                itemPrjSetting.setImage(this.prjImage);
            }
            itemPrjSetting.setText(Messages.getString("ECCIDEProjectPanel.prjSettings"));
            itemPrjSetting.setData((Object)mciPrjSetting);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadAppPresentationNode(IProject prj, TreeItem pItem, String appid) {
        TreeItem designFileItem = new TreeItem(pItem, 0);
        designFileItem.setText("MVC\u63a7\u5236\u903b\u8f91");
        if (this.htmlTrxImage != null) {
            designFileItem.setImage(this.htmlTrxImage);
        }
        this.loadDesignFile(prj, designFileItem, "designFiles/" + appid, new String[]{".jtx", ".mvc"}, this.htmlTrxImage, null);
        TreeItem jspFileItem = new TreeItem(pItem, 0);
        jspFileItem.setText(Messages.getString("ECCIDEProjectPanel.jspFiles"));
        if (this.htmlTrxImage != null) {
            jspFileItem.setImage(this.htmlTrxImage);
        }
        XMLNode prjSettingsNode = null;
        try {
            prjSettingsNode = IDEContent.getSettingNode(prj, 35);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IDEProjectSettings settings = new IDEProjectSettings(prjSettingsNode);
        String webRoot = settings.getWebContentPath();
        String jspRoot = settings.getJspRootPath();
        String htmlJspRoot = settings.getHtmlJspPath();
        htmlJspRoot = htmlJspRoot.length() > 0 ? String.valueOf(webRoot) + "/" + jspRoot + "/" + htmlJspRoot : String.valueOf(webRoot) + "/" + jspRoot;
        this.loadDesignFile(prj, jspFileItem, htmlJspRoot, new String[]{".jsp"}, this.htmlTrxImage, "wml;kjava;WEB-INF;META-INF;theme;CVS;tellerClient;");
    }
}

