/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.emp.ide.biz.debug.BizDebugWizard;
import com.ecc.emp.ide.biz.debug.DebugBizInfo;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class DebugBizAction
extends Action {
    private PrjViewPanel prjViewPanel = null;
    private IProject project;

    public DebugBizAction(PrjViewPanel prjViewPanel) {
        this.setText("\u8c03\u8bd5\u4e1a\u52a1\u6784\u4ef6");
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        try {
            IStructuredSelection selection1 = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
            PrjViewXMLNode node1 = (PrjViewXMLNode)selection1.getFirstElement();
        }
        catch (Exception selection1) {
            // empty catch block
        }
        try {
            Properties properties = this.getProperties();
            if (properties == null) {
                MessageDialog.openError((Shell)this.prjViewPanel.getShell(), (String)"\u9519\u8bef", (String)"\u8def\u5f84\u914d\u7f6e\u4e0d\u6b63\u786e");
                return;
            }
            String rootPath = String.valueOf(this.project.getFolder(IDEContent.getPRJSettings(this.project).getWebContentPath()).getLocation().toOSString()) + "\\";
            DebugBizInfo debugInfo = this.getDebugBizInfo(properties);
            if (debugInfo == null) {
                return;
            }
            properties.setProperty("rootPath", rootPath);
            properties.setProperty("logSettingFile", String.valueOf(this.getTempPath()) + "\\logging.xml");
            properties.setProperty("kcoll", debugInfo.inputDatas);
            properties.setProperty("class", debugInfo.testClassName);
            properties.setProperty("factoryName", this.getFactoryName());
            this.saveProerties(properties);
            this.runJava(DebugBizInfo.defaultTestClass, new String[]{this.getTempPath(), debugInfo.bizId, debugInfo.opId});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runJava(String testClassName, String[] args) {
        block11: {
            try {
                IVMRunner vmRunner;
                IJavaProject javaProject = JavaCore.create((IProject)this.project);
                IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                if (vmInstall == null) {
                    vmInstall = JavaRuntime.getDefaultVMInstall();
                }
                if (vmInstall == null || (vmRunner = vmInstall.getVMRunner("run")) == null) break block11;
                String[] classPath = null;
                try {
                    classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (classPath == null) break block11;
                VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(testClassName, classPath);
                vmConfig.setProgramArguments(args);
                Launch launch = new Launch(null, "run", null);
                vmRunner.run(vmConfig, (ILaunch)launch, null);
                IProcess[] processes = launch.getProcesses();
                if (processes.length == 0) {
                    return;
                }
                while (true) {
                    try {
                        if (processes[0].getExitValue() == 0) {
                            String out = processes[0].getStreamsProxy().getOutputStreamMonitor().getContents();
                            IDEContent.getConsole().print(out);
                            break;
                        }
                        if (1 == processes[0].getExitValue()) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DebugBizInfo getDebugBizInfo(Properties properties) {
        IStructuredSelection selection1 = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        PrjViewXMLNode node1 = (PrjViewXMLNode)selection1.getFirstElement();
        IFile bizfile = (IFile)node1.obj;
        String testClassName = properties.getProperty("class");
        BizDebugWizard wizard = new BizDebugWizard();
        DebugBizInfo debugInfo = wizard.getDebugBizInfo(bizfile, testClassName);
        return debugInfo;
    }

    private String getFactoryName() {
        IStructuredSelection selection1 = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        PrjViewXMLNode node1 = (PrjViewXMLNode)selection1.getFirstElement();
        IFile bizfile = (IFile)node1.obj;
        this.project = bizfile.getProject();
        String factoryName = IDEContent.getGroupId(bizfile.getLocation().toString());
        return factoryName;
    }

    private String getTempPath() {
        String str = String.valueOf(this.project.getLocation().toOSString()) + "\\designFiles\\.debug\\bizs\\";
        File folder = new File(str);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return str;
    }

    private Properties getProperties() {
        try {
            if (this.project == null) {
                this.getFactoryName();
            }
            Properties properties = new Properties();
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\biz_run.properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            properties.load(new FileInputStream(propertyFile));
            return properties;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveProerties(Properties properties) {
        try {
            File propertyFile = new File(String.valueOf(this.getTempPath()) + "\\biz_run.properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            FileOutputStream os = new FileOutputStream(propertyFile);
            properties.save(os, "");
            os.flush();
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

