/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.emp.ide.rule.debug.DebugRuleInfo;
import com.ecc.emp.ide.rule.debug.RuleDebugWizard;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DebugRuleAction
extends Action {
    private PrjViewPanel prjViewPanel = null;
    private IProject project;

    public DebugRuleAction(PrjViewPanel prjViewPanel) {
        this.setText("\u8c03\u8bd5\u4e1a\u52a1\u89c4\u5219");
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        try {
            DebugRuleInfo debugInfo = this.getDebugRuleInfo();
            if (debugInfo == null) {
                return;
            }
            this.runJava(debugInfo.testClassName, new String[]{this.getRulePath(debugInfo.ruleSetId), debugInfo.ruleSetId, debugInfo.ruleId, debugInfo.tempPath});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runJava(String testClassName, String[] args) {
        block11: {
            try {
                IVMRunner vmRunner;
                IJavaProject javaProject = JavaCore.create((IProject)this.project);
                IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                if (vmInstall == null) {
                    vmInstall = JavaRuntime.getDefaultVMInstall();
                }
                if (vmInstall == null || (vmRunner = vmInstall.getVMRunner("run")) == null) break block11;
                String[] classPath = null;
                try {
                    classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (classPath == null) break block11;
                VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(testClassName, classPath);
                vmConfig.setProgramArguments(args);
                Launch launch = new Launch(null, "run", null);
                vmRunner.run(vmConfig, (ILaunch)launch, null);
                IProcess[] processes = launch.getProcesses();
                if (processes.length == 0) {
                    return;
                }
                while (true) {
                    try {
                        if (processes[0].getExitValue() == 0) {
                            String out = processes[0].getStreamsProxy().getOutputStreamMonitor().getContents();
                            IDEContent.getConsole().print(out);
                            break;
                        }
                        if (1 == processes[0].getExitValue()) {
                            String out = processes[0].getStreamsProxy().getErrorStreamMonitor().getContents();
                            IDEContent.getConsole().print(out);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DebugRuleInfo getDebugRuleInfo() {
        IStructuredSelection selection1 = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        PrjViewXMLNode node1 = (PrjViewXMLNode)selection1.getFirstElement();
        IFile ruleFile = (IFile)node1.obj;
        this.project = ruleFile.getProject();
        RuleDebugWizard wizard = new RuleDebugWizard();
        DebugRuleInfo info = wizard.getDebugBizInfo(ruleFile);
        return info;
    }

    private String getRulePath(String ruleSetId) {
        String webcontentPath = IDEContent.getPRJSettings(this.project).getWebContentPath();
        String str = String.valueOf(this.project.getFolder(String.valueOf(webcontentPath) + "\\WEB-INF\\rules").getLocation().toOSString()) + "\\" + ruleSetId + ".rule";
        return str;
    }
}

