/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteAction
extends Action {
    private PrjViewPanel prjViewPanel = null;
    private IProject project;

    public DeleteAction(PrjViewPanel prjViewPanel) {
        this.setText("\u5220\u9664");
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        List selectionList = selection.toList();
        boolean result = MessageDialog.openConfirm(null, (String)"\u786e\u8ba4", (String)("\u786e\u8ba4\u5220\u9664\u8be5" + selectionList.size() + "\u9879?"));
        if (!result) {
            return;
        }
        try {
            int i = 0;
            while (i < selectionList.size()) {
                PrjViewXMLNode node = (PrjViewXMLNode)selectionList.get(i);
                IResource resource = (IResource)node.obj;
                if (this.project == null) {
                    this.project = resource.getProject();
                }
                if (resource.exists()) {
                    this.deleteResource(resource);
                    node.delete();
                    this.prjViewPanel.reload((PrjViewXMLNode)node.getParent());
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteResource(IResource resource) {
        try {
            String relatedPath;
            String webContentPath = IDEContent.getPRJSettings(this.project).getWebContentPath();
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IResource[] subPesources = folder.members();
                int i = 0;
                while (i < subPesources.length) {
                    this.deleteResource(subPesources[i]);
                    ++i;
                }
                relatedPath = folder.getLocation().toOSString();
                relatedPath = relatedPath.substring(relatedPath.indexOf("designFiles") - 1);
                IFolder relatedFolder = this.project.getFolder(relatedPath = relatedPath.replaceAll("designFiles", String.valueOf(webContentPath) + "/WEB-INF"));
                if (relatedFolder.exists()) {
                    relatedFolder.delete(true, null);
                }
            }
            if (resource instanceof IFile) {
                IFile relatedFile;
                String relatedPath2;
                IFile relatedFile2;
                IFile file = (IFile)resource;
                if ("biz".equalsIgnoreCase(file.getFileExtension())) {
                    String bizGrpId = IDEContent.getGroupId(file.getProjectRelativePath().toOSString());
                    relatedPath = "/" + webContentPath + "/WEB-INF/bizs/" + bizGrpId + "/operations/" + file.getName().substring(0, file.getName().indexOf(".")) + ".xml";
                    relatedFile2 = this.project.getFile(relatedPath);
                    if (relatedFile2.exists()) {
                        relatedFile2.delete(true, null);
                    }
                }
                if ("mvc".equalsIgnoreCase(file.getFileExtension())) {
                    String mvcGrpId = IDEContent.getGroupId(file.getProjectRelativePath().toOSString());
                    relatedPath = "/" + webContentPath + "/WEB-INF/mvcs/" + mvcGrpId + "/actions/" + file.getName().substring(0, file.getName().indexOf(".")) + ".xml";
                    relatedFile2 = this.project.getFile(relatedPath);
                    if (relatedFile2.exists()) {
                        relatedFile2.delete(true, null);
                    }
                }
                if ("jsp".equalsIgnoreCase(file.getFileExtension()) || "tsk".equalsIgnoreCase(file.getFileExtension())) {
                    relatedPath2 = file.getLocation().toOSString();
                    relatedPath2 = relatedPath2.substring(relatedPath2.indexOf("designFiles") - 1);
                    relatedFile = this.project.getFile(relatedPath2 = relatedPath2.replaceAll("designFiles", String.valueOf(webContentPath) + "/WEB-INF"));
                    if (relatedFile.exists()) {
                        relatedFile.delete(true, null);
                    }
                }
                if ("table".equals(file.getFileExtension()) && (relatedFile = this.project.getFile(relatedPath2 = "/" + webContentPath + "/WEB-INF/tables/" + file.getName().substring(0, file.getName().indexOf(".")) + ".xml")).exists()) {
                    relatedFile.delete(true, null);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
    }
}

