/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EditTargetXMLAction
extends Action {
    private PrjViewPanel prjViewPanel = null;
    private PrjViewXMLNode node = null;

    public EditTargetXMLAction(PrjViewPanel prjViewPanel) {
        this.setText("\u6253\u5f00\u76ee\u6807\u6587\u4ef6");
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        PrjViewXMLNode node = (PrjViewXMLNode)selection.getFirstElement();
        IFile file = this.getTargetXMLPath(node);
        if (file == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            String editorId = "org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart";
            if (file.getName().endsWith(".jsp")) {
                editorId = "org.eclipse.jst.jsp.core.jspsource.source";
            }
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorId, (boolean)true);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private IFile getTargetXMLPath(PrjViewXMLNode node) {
        if (!(node.obj instanceof IFile)) {
            return null;
        }
        String fileName = ((IFile)node.obj).getLocation().toOSString();
        if (fileName.endsWith("biz")) {
            String bizid = IDEContent.getGroupId(fileName);
            String targetFileName = String.valueOf(fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length() - "biz".length())) + "xml";
            IDEProjectSettings settings = IDEContent.getPRJSettings(node.getProject());
            String webPath = settings.getWebContentPath();
            targetFileName = String.valueOf(webPath) + "\\WEB-INF\\bizs\\" + bizid + "\\operations\\" + targetFileName;
            IFile file = node.getProject().getFile(targetFileName);
            if (file != null && file.exists()) {
                return file;
            }
            return null;
        }
        if (fileName.endsWith("mvc")) {
            String bizid = IDEContent.getGroupId(fileName);
            String targetFileName = String.valueOf(fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length() - "mvc".length())) + "xml";
            IDEProjectSettings settings = IDEContent.getPRJSettings(node.getProject());
            String webPath = settings.getWebContentPath();
            targetFileName = String.valueOf(webPath) + "\\WEB-INF\\mvcs\\" + bizid + "\\actions\\" + targetFileName;
            IFile file = node.getProject().getFile(targetFileName);
            if (file != null && file.exists()) {
                return file;
            }
            return null;
        }
        if (fileName.endsWith("grd")) {
            String bizid = IDEContent.getGroupId(fileName);
            String targetFileName = String.valueOf(fileName.substring(fileName.lastIndexOf(String.valueOf(bizid) + "\\") + bizid.length() + 1, fileName.length() - "grd".length())) + "jsp";
            IDEProjectSettings settings = IDEContent.getPRJSettings(node.getProject());
            String webPath = settings.getWebContentPath();
            targetFileName = String.valueOf(webPath) + "\\WEB-INF\\mvcs\\" + bizid + "\\" + targetFileName;
            IFile file = node.getProject().getFile(targetFileName);
            if (file != null && file.exists()) {
                return file;
            }
            return null;
        }
        if (fileName.endsWith("acc")) {
            String targetFileName = String.valueOf(fileName.substring(fileName.lastIndexOf("\\") + 1, fileName.length() - "acc".length())) + "xml";
            IDEProjectSettings settings = IDEContent.getPRJSettings(node.getProject());
            String webPath = settings.getWebContentPath();
            targetFileName = String.valueOf(webPath) + "\\WEB-INF\\channels\\" + targetFileName;
            IFile file = node.getProject().getFile(targetFileName);
            if (file != null && file.exists()) {
                return file;
            }
            return null;
        }
        return null;
    }
}

