/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.plugin.views.actions.NewFileWizardPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewFileWizard
extends Wizard
implements INewWizard {
    private NewFileWizardPage page;
    public String fileName;
    public String templateFileName;
    private IProject project = null;
    private IFolder parentFolder = null;
    private String title = "";
    private String label = "";
    private String templateType = "";
    private String ext = "";

    public NewFileWizard(IProject project, String title, String label, String templateType, String ext) {
        this.setNeedsProgressMonitor(true);
        this.title = title;
        this.label = label;
        this.templateType = templateType;
        this.ext = ext;
        this.project = project;
    }

    public void addPages() {
        try {
            this.getShell().setBounds(200, 50, 600, 600);
            this.page = new NewFileWizardPage(this.project, this.title, this.label, this.templateType);
            this.addPage((IWizardPage)this.page);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean performFinish() {
        String fileName = this.page.getFileName();
        this.templateFileName = this.page.getTemplateId();
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        if (!fileName.endsWith("." + this.ext)) {
            fileName = String.valueOf(fileName) + "." + this.ext;
        }
        if (this.parentFolder == null || this.parentFolder.findMember(fileName) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728!");
            return false;
        }
        this.fileName = fileName;
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSelection(IStructuredSelection selection) {
    }

    public void setParentFolder(Object parentFolder) {
        if (parentFolder instanceof IFolder) {
            this.parentFolder = (IFolder)parentFolder;
        }
    }
}

