/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class NewFileWizardPage
extends WizardPage {
    private Text templateDescText;
    private static String baseFolder = "buildDef/wizards/";
    private List templateList;
    private Text fileNameTextField;
    private String title;
    private String idtext;
    private String templateId;
    private Label templateImageLabel;
    private Hashtable templates = new Hashtable();
    private Label msglabel;
    private IProject project;

    public NewFileWizardPage(IProject project, String title, String idtext, String templateId) {
        super("wizardPage");
        this.setTitle("EMP Application");
        this.setDescription(title);
        this.title = title;
        this.idtext = idtext;
        this.templateId = templateId;
        this.project = project;
        this.setTemplates(templateId);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Label");
        label.setText(this.idtext);
        this.fileNameTextField = new Text(composite, 2048);
        this.fileNameTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (NewFileWizardPage.this.project == null) {
                    return;
                }
                String fileId = NewFileWizardPage.this.fileNameTextField.getText();
                if (IDEContent.getFile(NewFileWizardPage.this.project, fileId, NewFileWizardPage.this.templateId) != null) {
                    NewFileWizardPage.this.msglabel.setText("\u540c\u540d\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
                    NewFileWizardPage.this.msglabel.setForeground(SWTResourceManager.getColor(255, 0, 0));
                } else {
                    NewFileWizardPage.this.msglabel.setText("\u540d\u79f0\u53ef\u4f7f\u7528");
                    NewFileWizardPage.this.msglabel.setForeground(SWTResourceManager.getColor(0, 0, 0));
                }
            }
        });
        this.fileNameTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        this.msglabel = new Label(composite, 0);
        this.msglabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new FillLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        SashForm sashForm = new SashForm((Composite)group, 0);
        sashForm.setCapture(true);
        this.templateList = new List((Composite)sashForm, 2048);
        this.templateList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewFileWizardPage.this.selectTemplate();
            }
        });
        Composite composite_1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout((Layout)gridLayout_1);
        this.templateDescText = new Text(composite_1, 2818);
        this.templateDescText.setEditable(false);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 41;
        this.templateDescText.setLayoutData((Object)gridData);
        this.templateImageLabel = new Label(composite_1, 0);
        this.templateImageLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        Enumeration keys = this.templates.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            TemplateObj obj = (TemplateObj)this.templates.get(key);
            key = obj.getId();
            this.templateList.add(key);
            this.templateList.setData(key, (Object)obj);
        }
        this.templateList.setSelection(0);
        this.selectTemplate();
        sashForm.setWeights(new int[]{1, 3});
    }

    public void selectTemplate() {
        String key = this.templateList.getSelection()[0];
        final TemplateObj templateObj = (TemplateObj)this.templateList.getData(key);
        this.templateDescText.setText(templateObj.getDesc());
        this.templateImageLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    int h;
                    Rectangle rect = templateObj.getImage().getBounds();
                    Rectangle rect1 = NewFileWizardPage.this.templateImageLabel.getBounds();
                    int w = rect1.width;
                    if (rect.width < w) {
                        w = rect.width;
                    }
                    if (rect.height < (h = rect1.height)) {
                        h = rect.height;
                    }
                    e.gc.fillRectangle(0, 0, rect1.width, rect1.height);
                    e.gc.drawImage(templateObj.getImage(), rect.x, rect.y, rect.width, rect.height, 0, 0, w, h);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.templateImageLabel.redraw();
    }

    private void setTemplates(String templateId) {
        String aTemplateId2;
        File file;
        String folderName = ECCIDEPlugin.getDir(String.valueOf(baseFolder) + templateId);
        if (folderName == null || folderName.length() == 0) {
            return;
        }
        File templateDir = new File(folderName);
        if (!templateDir.exists()) {
            return;
        }
        File[] files = templateDir.listFiles();
        int i = 0;
        while (i < files.length) {
            file = files[i];
            if (file.getName().endsWith(".tpl")) {
                try {
                    aTemplateId2 = file.getName().substring(0, file.getName().lastIndexOf("."));
                    this.templates.put(aTemplateId2, new TemplateObj(file));
                }
                catch (Exception aTemplateId2) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.project != null) {
            folderName = String.valueOf(this.project.getLocation().toOSString()) + "/designFiles/commons/wizards/" + templateId;
            if (folderName == null || folderName.length() == 0) {
                return;
            }
            templateDir = new File(folderName);
            if (!templateDir.exists()) {
                return;
            }
            files = templateDir.listFiles();
            i = 0;
            while (i < files.length) {
                file = files[i];
                if (file.getName().endsWith(".tpl")) {
                    try {
                        aTemplateId2 = file.getName().substring(0, file.getName().lastIndexOf("."));
                        this.templates.put(aTemplateId2, new TemplateObj(file));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public String getFileName() {
        return this.fileNameTextField.getText();
    }

    public String getTemplateId() {
        try {
            String key = this.templateList.getSelection()[0];
            TemplateObj templateObj = (TemplateObj)this.templateList.getData(key);
            return templateObj.getFileName();
        }
        catch (Exception e) {
            return "";
        }
    }

    class TemplateObj {
        private Image image = null;
        private Properties properties = new Properties();
        private File templateFile;

        public TemplateObj(File templateFile) throws Exception {
            this.templateFile = templateFile;
            String lastKey = "";
            try {
                String str;
                FileReader fr = new FileReader(templateFile);
                LineNumberReader reader = new LineNumberReader(fr);
                while ((str = reader.readLine()) != null) {
                    if (str.length() == 0) continue;
                    if (str.indexOf("=") == -1) {
                        str = this.properties.get(lastKey) + "\r\n" + str;
                        this.properties.put(lastKey, str);
                        continue;
                    }
                    String key = str.substring(0, str.indexOf("="));
                    String value = str.substring(str.indexOf("=") + 1);
                    this.properties.put(key, value);
                    lastKey = key;
                }
                reader.close();
                fr.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            try {
                this.image = new Image(null, ECCIDEPlugin.getFile(String.valueOf(baseFolder) + NewFileWizardPage.this.templateId + "/" + this.properties.getProperty("image")));
            }
            catch (Exception e) {
                try {
                    String temp = this.templateFile.getPath();
                    temp = temp.substring(0, temp.lastIndexOf(this.templateFile.getName()));
                    this.image = new Image(null, String.valueOf(temp) + this.properties.getProperty("image"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.image;
        }

        public String getId() {
            return this.properties.getProperty("id");
        }

        public String getFileName() {
            return this.properties.getProperty("fileName");
        }

        public String getDesc() {
            return this.properties.getProperty("desc");
        }
    }
}

