/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ReloadEMPAction
extends Action {
    private PrjViewPanel prjViewPanel = null;
    private PrjViewXMLNode node = null;
    private int jmxServerPort = 10330;
    private String jmxServerHost = "localhost";

    public ReloadEMPAction(PrjViewPanel prjViewPanel) {
        this.setText("\u91cd\u8f7dEMP\u914d\u7f6e");
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        this.node = (PrjViewXMLNode)selection.getFirstElement();
        if (!(this.node.obj instanceof IFolder)) {
            return;
        }
        IFolder folder = (IFolder)this.node.obj;
        String pName = folder.getParent().getName();
        this.setJMXServerPort(folder.getProject());
        if (!this.checkServerStatus(folder.getProject())) {
            return;
        }
    }

    private void reloadAllMvcGrp(IFolder folder) {
        try {
            if (folder == null) {
                return;
            }
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                IFolder subFolder;
                if (!(resources[i] instanceof IFolder) || (subFolder = (IFolder)resources[i]).findMember("mvcdefine.xml") == null) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void setJMXServerPort(IProject project) {
        String destPath = "/WEB-INF/EMPJMXContext.xml";
        IDEProjectSettings prjSettings = IDEContent.getPRJSettings(project);
        destPath = String.valueOf(prjSettings.getWebContentPath()) + destPath;
        IFile destFile = project.getFile(destPath);
        if (!destFile.exists()) {
            return;
        }
        try {
            XMLLoader loader = new XMLLoader();
            loader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode jmxNode = (XMLNode)loader.loadXMLFile(destFile.getLocation().toOSString());
            this.jmxServerPort = Integer.parseInt(jmxNode.findChild("registry").getAttrValue("port"));
            this.jmxServerHost = jmxNode.findChild("registry").getAttrValue("host");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkServerStatus(IProject project) {
        return false;
    }
}

