/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.ant.AntObject;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.views.actions.BaseAction;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.apache.tools.ant.BuildEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TableTempletAction
extends BaseAction {
    private static final String buildFilePath = "designFiles/.templets/templetbuild.xml";
    private String bizGroupId;
    private String mvcGroupId;
    private String modelId;
    private boolean commitWay = false;

    public TableTempletAction(PrjViewPanel prjViewPanel) {
        this.prjViewPanel = prjViewPanel;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        this.node = (PrjViewXMLNode)selection.getFirstElement();
        String antTargetName = this.getAntTargetName((IFile)this.node.obj);
        if (antTargetName == null) {
            return;
        }
        AntObject antObject = this.getAntObject(buildFilePath, antTargetName, "\u81ea\u52a8\u6784\u9020\u8868\u6a21\u578b\u64cd\u4f5c\u7684\u8868\u73b0\u903b\u8f91\u548c\u4e1a\u52a1\u903b\u8f91");
        this.modelId = this.getTableNode().findChild("TableModel").getAttrValue("id");
        antObject.setProperty("ModelId", this.modelId);
        antObject.setProperty("modelId", this.modelId.toLowerCase());
        IFile file = (IFile)this.node.obj;
        antObject.setProperty("modelFile", file.getProjectRelativePath().toString());
        String subPath = file.getParent().getLocation().toString();
        subPath = subPath.substring(subPath.indexOf("designFiles/tables") + "designFiles/tables".length());
        if (!subPath.equals("") && subPath.startsWith("/")) {
            subPath = String.valueOf(subPath.substring(1)) + "/";
        }
        antObject.setProperty("subPath", subPath);
        this.mvcGroupId = this.getMvcGrpId(this.node.getProject());
        antObject.setProperty("mvcGroupId", this.mvcGroupId);
        antObject.setProperty("commitWay", String.valueOf(this.commitWay));
        RunAntInIDE.run(antObject);
    }

    private String getAntTargetName(IFile file) {
        XMLNode node;
        block4: {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            try {
                node = (XMLNode)xmlLoader.loadXMLFile(file.getLocation().toOSString());
                if (node.getChild("TableModel").findChild("One2MultiRef") == null) break block4;
                return "templet_multi_onebyone";
            }
            catch (Exception e) {
                return null;
            }
        }
        if (node.getChild("TableModel").findChild("One2OneRef") != null) {
            return "templet_joined";
        }
        return "templet_single";
    }

    public void buildFinished(BuildEvent arg0) {
        IFolder folder;
        IProject project;
        try {
            project = this.node.getProject();
            folder = project.getFolder("designFiles/bizs/" + this.bizGroupId + "/tables");
            if (!folder.exists()) {
                folder = project.getFolder("designFiles/bizs/" + this.mvcGroupId);
            }
            folder.refreshLocal(2, null);
            PrjViewXMLNode bizsNode = (PrjViewXMLNode)PrjViewXMLNode.nodesMap.get(folder);
            if (bizsNode == null) {
                bizsNode = (PrjViewXMLNode)PrjViewXMLNode.nodesMap.get(folder.getParent());
            }
            this.prjViewPanel.reload(bizsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            project = this.node.getProject();
            folder = project.getFolder("designFiles/mvcs/" + this.mvcGroupId + "/tables/");
            if (!folder.exists()) {
                folder = project.getFolder("designFiles/mvcs/" + this.mvcGroupId);
            }
            folder.refreshLocal(2, null);
            PrjViewXMLNode mvcsNode = (PrjViewXMLNode)PrjViewXMLNode.nodesMap.get(folder);
            if (mvcsNode == null) {
                mvcsNode = (PrjViewXMLNode)PrjViewXMLNode.nodesMap.get(folder.getParent());
            }
            this.prjViewPanel.reload(mvcsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isAllInDict() {
        boolean flag;
        block10: {
            XMLNode tableNode;
            XMLNode dataDict;
            block9: {
                flag = false;
                dataDict = null;
                try {
                    dataDict = IDEContent.getSettingNode(this.node.getProject(), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tableNode = this.getTableNode();
                if (tableNode != null) break block9;
                return false;
            }
            try {
                int w = 0;
                int i = 0;
                while (i < tableNode.getChilds().size()) {
                    XMLNode columnNode = (XMLNode)tableNode.getChilds().elementAt(i);
                    if ("column".equals(columnNode.getNodeName())) {
                        ++w;
                        String refId = columnNode.getAttrValue("dataName");
                        XMLNode dataElement = dataDict.findChildNodeWithAttrValue("dataElement", "id", refId);
                        XMLNode dataCollection = dataDict.findChildNodeWithAttrValue("dataCollection", "id", refId);
                        if (dataElement == null && dataCollection == null) {
                            flag = true;
                            break;
                        }
                    }
                    ++i;
                }
                if (w != 0) break block10;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return !flag;
    }

    private XMLNode getTableNode() {
        XMLNode tableNode = null;
        try {
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            IFile file = (IFile)this.node.obj;
            tableNode = (XMLNode)xmlLoader2.loadXMLContent(file.getContents());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableNode;
    }

    private String getMvcGrpId(IProject project) {
        IDEProjectSettings settings = new IDEProjectSettings(project);
        IFolder designFolder = project.getFolder(String.valueOf(settings.getWebContentPath()) + "/WEB-INF");
        if (designFolder == null) {
            return "";
        }
        try {
            IFolder mvcsFolder = designFolder.getFolder("mvcs");
            IResource[] resources = mvcsFolder.members();
            String mvcGrpId = "";
            int i = 0;
            while (i < resources.length) {
                mvcGrpId = resources[i].getName();
                if (resources[i] instanceof IFolder) {
                    return mvcGrpId;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

