/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TableTempletWizardPage
extends WizardPage {
    public Text dataSourceText;
    public Text tableServiceText;
    public Text tableNameText;
    public Text BizGrpIdText;
    public Text MvcGrpText;
    private IProject project;
    private PrjViewXMLNode node;
    private XMLNode tableNode;

    public TableTempletWizardPage(IProject prj, PrjViewXMLNode node) {
        super("wizardPage");
        this.setTitle("EMP Application");
        this.setDescription("\u81ea\u52a8\u6784\u9020\u5355\u8868\u64cd\u4f5c\u4e1a\u52a1\u903b\u8f91\u548c\u8868\u73b0\u903b\u8f91");
        this.project = prj;
        this.node = node;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText("\u8868\u73b0\u903b\u8f91\u5206\u7ec4\uff1a");
        this.MvcGrpText = new Text(container, 2048);
        this.MvcGrpText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button mvcgrpbtn = new Button(container, 0);
        mvcgrpbtn.setEnabled(false);
        mvcgrpbtn.setText(">>");
        Label label_1 = new Label(container, 0);
        label_1.setText("\u4e1a\u52a1\u903b\u8f91\u5206\u7ec4\uff1a");
        this.BizGrpIdText = new Text(container, 2048);
        this.BizGrpIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button bizgrpbtn = new Button(container, 0);
        bizgrpbtn.setEnabled(false);
        bizgrpbtn.setText(">>");
        Label label_2 = new Label(container, 0);
        label_2.setText("\u8868\u540d\uff1a");
        this.tableNameText = new Text(container, 2048);
        this.tableNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button tablename = new Button(container, 0);
        tablename.setVisible(false);
        tablename.setText(">>");
        Label label_3 = new Label(container, 0);
        label_3.setText("\u6240\u9009\u7528\u7684\u6570\u636e\u6e90\uff1a");
        this.dataSourceText = new Text(container, 2048);
        this.dataSourceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button datasourcebtn = new Button(container, 0);
        datasourcebtn.setEnabled(false);
        datasourcebtn.setText(">>");
        Label label_4 = new Label(container, 0);
        label_4.setText("\u6240\u9009\u7528\u7684TableService\uff1a");
        this.tableServiceText = new Text(container, 2048);
        this.tableServiceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button tableServicebtn = new Button(container, 0);
        tableServicebtn.setEnabled(false);
        tableServicebtn.setText(">>");
        this.init();
    }

    private void init() {
        int i;
        String bizGrpId;
        IResource[] resources;
        IFolder designFolder = this.project.getFolder("designFiles");
        if (designFolder == null) {
            return;
        }
        try {
            IFolder bizsFolder = designFolder.getFolder("bizs");
            resources = bizsFolder.members();
            bizGrpId = "";
            i = 0;
            while (i < resources.length) {
                bizGrpId = resources[i].getName();
                if (resources[i] instanceof IFolder) break;
                ++i;
            }
            this.BizGrpIdText.setText(bizGrpId);
        }
        catch (Exception bizsFolder) {
            // empty catch block
        }
        try {
            String bizGrpId2 = this.BizGrpIdText.getText();
            ArrayList list = this.getDataSource(bizGrpId2);
            if (list.size() > 0) {
                this.dataSourceText.setText((String)list.get(0));
            }
            if ((list = this.getTableService(bizGrpId2)).size() > 0) {
                this.tableServiceText.setText((String)list.get(0));
            }
        }
        catch (Exception bizGrpId2) {
            // empty catch block
        }
        try {
            IFolder mvcsFolder = designFolder.getFolder("mvcs");
            resources = mvcsFolder.members();
            bizGrpId = "";
            i = 0;
            while (i < resources.length) {
                bizGrpId = resources[i].getName();
                if (resources[i] instanceof IFolder) break;
                ++i;
            }
            this.MvcGrpText.setText(bizGrpId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tableNameText.setText(this.getTableName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getTableName() {
        this.getTableNode();
        if (this.tableNode == null) {
            return "";
        }
        String tableName = this.tableNode.getAttrValue("tableName");
        return tableName;
    }

    private XMLNode getTableNode() {
        if (this.tableNode == null) {
            IFile file = (IFile)this.node.obj;
            this.tableNode = this.loadXMLFile(file.getLocation().toOSString());
        }
        return this.tableNode;
    }

    private XMLNode loadXMLFile(String fileName) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(fileName);
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ArrayList getDataSource(String bizGrpId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            XMLNode svcNode = IDEContent.getSettingNode(this.project, bizGrpId, 12);
            if (svcNode == null) {
                return result;
            }
            int i = 0;
            while (i < svcNode.getChilds().size()) {
                XMLNode node = (XMLNode)svcNode.getChilds().elementAt(i);
                if ("JDBCDriverDataSource".equals(node.getNodeName())) {
                    result.add(node.getAttrValue("id"));
                }
                if ("JNDIDataSource".equals(node.getNodeName())) {
                    result.add(node.getAttrValue("id"));
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private ArrayList getTableService(String bizGrpId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            XMLNode svcNode = IDEContent.getSettingNode(this.project, bizGrpId, 12);
            if (svcNode == null) {
                return result;
            }
            int i = 0;
            while (i < svcNode.getChilds().size()) {
                XMLNode node = (XMLNode)svcNode.getChilds().elementAt(i);
                if ("TableService".equals(node.getNodeName())) {
                    result.add(node.getAttrValue("id"));
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

